/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.hssf.record.ObjRecord;
import org.apache.poi.hssf.record.aggregates.BOFRecordAggregate;
import org.apache.poi.hssf.usermodel.HSSFChart;
import org.apache.poi.hssf.usermodel.HSSFSimpleShape;
import org.apache.poi.ss.usermodel.ClientAnchor;

public class HSSFChartShape
extends HSSFSimpleShape {
    private BOFRecordAggregate _bofAgg;
    private HSSFChart _chart;
    private String _name;
    private long _chartId;
    private static AtomicLong idseq = new AtomicLong();

    public HSSFChartShape(EscherContainerRecord spContainer, ObjRecord objRecord, BOFRecordAggregate bofAgg) {
        super(spContainer, objRecord);
        this._bofAgg = bofAgg;
        this._chartId = idseq.incrementAndGet();
    }

    protected BOFRecordAggregate getBOFRecordAggregate() {
        return this._bofAgg;
    }

    public void setChart(HSSFChart chart) {
        this._chart = chart;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public ClientAnchor getPreferredSize() {
        return (ClientAnchor)((Object)this.getAnchor());
    }

    public HSSFChart getChart() {
        return this._chart;
    }

    public String getChartId() {
        return Long.toHexString(this._chartId);
    }

    public void setClientAnchor(ClientAnchor newanchor) {
        throw new RuntimeException("not implement in hssf format");
    }
}

