/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.chart;

import java.util.Map;
import java.util.function.Supplier;
import org.apache.poi.hssf.record.HSSFRecordTypes;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.GenericRecordUtil;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndianOutput;

public final class PieRecord
extends StandardRecord {
    public static final short sid = 4121;
    private short field_1_anStart;
    private short field_2_pcDonut;
    private short field_3_formatFlags;
    private static final BitField shadow = BitFieldFactory.getInstance(1);
    private static final BitField leaderLines = BitFieldFactory.getInstance(2);

    public PieRecord() {
    }

    public PieRecord(RecordInputStream in) {
        this.field_1_anStart = in.readShort();
        this.field_2_pcDonut = in.readShort();
        this.field_3_formatFlags = in.readShort();
    }

    @Override
    protected int getDataSize() {
        return 6;
    }

    @Override
    public void serialize(LittleEndianOutput out) {
        out.writeShort(this.field_1_anStart);
        out.writeShort(this.field_2_pcDonut);
        out.writeShort(this.field_3_formatFlags);
    }

    @Override
    public PieRecord copy() {
        return (PieRecord)this.clone();
    }

    @Override
    public short getSid() {
        return 4121;
    }

    @Override
    public HSSFRecordTypes getGenericRecordType() {
        return HSSFRecordTypes.PieRecord;
    }

    public Object clone() {
        PieRecord rec = new PieRecord();
        rec.field_1_anStart = this.field_1_anStart;
        rec.field_2_pcDonut = this.field_2_pcDonut;
        rec.field_3_formatFlags = this.field_3_formatFlags;
        return rec;
    }

    public short getFormatFlags() {
        return this.field_3_formatFlags;
    }

    public void setFormatFlags(short field_3_formatFlags) {
        this.field_3_formatFlags = field_3_formatFlags;
    }

    public short getAnStart() {
        return this.field_1_anStart;
    }

    public void setAnStart(short field_1_anStart) {
        this.field_1_anStart = field_1_anStart;
    }

    public short getPcDonut() {
        return this.field_2_pcDonut;
    }

    public void setPcDonut(short field_2_pcDonut) {
        this.field_2_pcDonut = field_2_pcDonut;
    }

    public void setShowLdrLines(boolean value) {
        this.field_3_formatFlags = leaderLines.setShortBoolean(this.field_3_formatFlags, value);
    }

    public boolean isShowLdrLines() {
        return leaderLines.isSet(this.field_3_formatFlags);
    }

    public void setShadow(boolean value) {
        this.field_3_formatFlags = shadow.setShortBoolean(this.field_3_formatFlags, value);
    }

    public boolean isShadow() {
        return shadow.isSet(this.field_3_formatFlags);
    }

    @Override
    public Map<String, Supplier<?>> getGenericProperties() {
        return GenericRecordUtil.getGenericProperties("anStart", () -> "0x" + HexDump.toHex(this.field_1_anStart), "pcDonut", () -> "0x" + HexDump.toHex(this.field_2_pcDonut), "formatFlags", () -> "0x" + HexDump.toHex(this.field_3_formatFlags), "shadow", this::isShadow, "showLdrLines", this::isShowLdrLines);
    }
}

