/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.chart;

import java.util.Map;
import java.util.function.Supplier;
import org.apache.poi.hssf.record.HSSFRecordTypes;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.GenericRecordUtil;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndianOutput;

public final class LineRecord
extends StandardRecord {
    public static final short sid = 4120;
    private short field_1_formatFlags;
    private static final BitField stacked = BitFieldFactory.getInstance(1);
    private static final BitField percent = BitFieldFactory.getInstance(2);
    private static final BitField shadow = BitFieldFactory.getInstance(4);

    public LineRecord() {
    }

    public LineRecord(RecordInputStream in) {
        this.field_1_formatFlags = in.readShort();
    }

    @Override
    protected int getDataSize() {
        return 2;
    }

    @Override
    public void serialize(LittleEndianOutput out) {
        out.writeShort(this.field_1_formatFlags);
    }

    @Override
    public LineRecord copy() {
        return (LineRecord)this.clone();
    }

    @Override
    public short getSid() {
        return 4120;
    }

    @Override
    public HSSFRecordTypes getGenericRecordType() {
        return HSSFRecordTypes.LineRecord;
    }

    public Object clone() {
        LineRecord rec = new LineRecord();
        rec.field_1_formatFlags = this.field_1_formatFlags;
        return rec;
    }

    public short getFormatFlags() {
        return this.field_1_formatFlags;
    }

    public void setFormatFlags(short field_3_formatFlags) {
        this.field_1_formatFlags = field_3_formatFlags;
    }

    public void setPercent(boolean value) {
        this.field_1_formatFlags = percent.setShortBoolean(this.field_1_formatFlags, value);
    }

    public boolean isPercent() {
        return percent.isSet(this.field_1_formatFlags);
    }

    public void setStacked(boolean value) {
        this.field_1_formatFlags = stacked.setShortBoolean(this.field_1_formatFlags, value);
    }

    public boolean isStacked() {
        return stacked.isSet(this.field_1_formatFlags);
    }

    public void setShadow(boolean value) {
        this.field_1_formatFlags = shadow.setShortBoolean(this.field_1_formatFlags, value);
    }

    public boolean isShadow() {
        return shadow.isSet(this.field_1_formatFlags);
    }

    @Override
    public Map<String, Supplier<?>> getGenericProperties() {
        return GenericRecordUtil.getGenericProperties("formatFlags", () -> "0x" + HexDump.toHex(this.field_1_formatFlags), "stacked", this::isStacked, "percent", this::isPercent, "shadow", this::isShadow);
    }
}

