/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.Map;
import java.util.function.Supplier;
import org.apache.poi.hssf.record.HSSFRecordTypes;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.hssf.record.common.FtrHeader;
import org.apache.poi.util.GenericRecordUtil;
import org.apache.poi.util.LittleEndianOutput;

public class MTRSettingsRecord
extends StandardRecord {
    public static final short sid = 2202;
    private FtrHeader futureHeader;
    int fMTREnabled;
    int fUserSetThreadCount;
    int cUserThreadCount;

    public MTRSettingsRecord() {
        this.futureHeader = new FtrHeader();
        this.futureHeader.setRecordType((short)2202);
    }

    public MTRSettingsRecord(RecordInputStream in) {
        this.futureHeader = new FtrHeader(in);
        this.fMTREnabled = in.readInt();
        this.fUserSetThreadCount = in.readInt();
        this.cUserThreadCount = in.readInt();
    }

    @Override
    public short getSid() {
        return 2202;
    }

    @Override
    public HSSFRecordTypes getGenericRecordType() {
        return HSSFRecordTypes.MTR_SETTINGS;
    }

    public int getUserThreadCount() {
        return this.cUserThreadCount;
    }

    public void setUserThreadCount(int count) {
        if (count < 1 || count > 1024) {
            count = 1;
        }
        this.cUserThreadCount = count;
    }

    public boolean isMTREnabled() {
        return this.fMTREnabled != 0;
    }

    public boolean isUserSetThreadCount() {
        return this.fUserSetThreadCount != 0;
    }

    public void setMTREnabled(boolean flag) {
        this.fMTREnabled = flag ? 1 : 0;
    }

    public void setUserSetThreadCount(boolean flag) {
        this.fUserSetThreadCount = flag ? 1 : 0;
    }

    @Override
    public void serialize(LittleEndianOutput out) {
        this.futureHeader.serialize(out);
        out.writeInt(this.fMTREnabled);
        out.writeInt(this.fUserSetThreadCount);
        out.writeInt(this.cUserThreadCount);
    }

    @Override
    public MTRSettingsRecord copy() {
        return (MTRSettingsRecord)this.clone();
    }

    public Object clone() {
        return this.cloneViaReserialise();
    }

    @Override
    protected int getDataSize() {
        return 24;
    }

    @Override
    public Map<String, Supplier<?>> getGenericProperties() {
        return GenericRecordUtil.getGenericProperties("fMTREnabled", this::isMTREnabled, "fUserSetThreadCount", this::isUserSetThreadCount, "cUserThreadCount", this::getUserThreadCount);
    }
}

