/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.Map;
import java.util.function.Supplier;
import org.apache.poi.hssf.record.HSSFRecordTypes;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.hssf.record.common.FtrHeader;
import org.apache.poi.util.GenericRecordUtil;
import org.apache.poi.util.LittleEndianOutput;

public class ForceFullCalculationRecord
extends StandardRecord {
    public static final short sid = 2211;
    private FtrHeader futureHeader;
    int fNoDeps;

    public ForceFullCalculationRecord() {
        this.futureHeader = new FtrHeader();
        this.futureHeader.setRecordType((short)2211);
    }

    public ForceFullCalculationRecord(RecordInputStream in) {
        this.futureHeader = new FtrHeader(in);
        this.fNoDeps = in.readInt();
    }

    @Override
    public short getSid() {
        return 2211;
    }

    @Override
    public HSSFRecordTypes getGenericRecordType() {
        return HSSFRecordTypes.FORCE_FULL_CALCULATION;
    }

    public boolean isNoDeps() {
        return this.fNoDeps != 0;
    }

    public void setNoDeps(boolean flag) {
        this.fNoDeps = flag ? 1 : 0;
    }

    @Override
    public void serialize(LittleEndianOutput out) {
        this.futureHeader.serialize(out);
        out.writeInt(this.fNoDeps);
    }

    @Override
    public ForceFullCalculationRecord copy() {
        return (ForceFullCalculationRecord)this.clone();
    }

    public Object clone() {
        return this.cloneViaReserialise();
    }

    @Override
    protected int getDataSize() {
        return 16;
    }

    @Override
    public Map<String, Supplier<?>> getGenericProperties() {
        return GenericRecordUtil.getGenericProperties("fNoDeps", this::isNoDeps);
    }
}

