/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.Map;
import java.util.function.Supplier;
import org.apache.poi.hssf.record.EnhancedProtection;
import org.apache.poi.hssf.record.HSSFRecordTypes;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.hssf.record.common.FtrHeader;
import org.apache.poi.util.GenericRecordUtil;
import org.apache.poi.util.LittleEndianOutput;

public final class FeatHdrRecord
extends StandardRecord {
    public static final int SHAREDFEATURES_ISFPROTECTION = 2;
    public static final int SHAREDFEATURES_ISFFEC2 = 3;
    public static final int SHAREDFEATURES_ISFFACTOID = 4;
    public static final int SHAREDFEATURES_ISFLIST = 5;
    public static final short sid = 2151;
    private final FtrHeader futureHeader;
    private int isf_sharedFeatureType;
    private byte reserved;
    private long cbHdrData;
    private byte[] rgbHdrData;
    private Object shared;

    public FeatHdrRecord() {
        this.futureHeader = new FtrHeader();
        this.futureHeader.setRecordType((short)2151);
    }

    public FeatHdrRecord(int sharedFutureType) {
        this();
        this.isf_sharedFeatureType = sharedFutureType;
        switch (this.isf_sharedFeatureType) {
            case 2: {
                this.shared = new EnhancedProtection();
                this.cbHdrData = -1L;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown shardFutureType: " + sharedFutureType);
            }
        }
    }

    public FeatHdrRecord(FeatHdrRecord other) {
        super(other);
        this.futureHeader = other.futureHeader.copy();
        this.isf_sharedFeatureType = other.isf_sharedFeatureType;
        this.reserved = other.reserved;
        this.cbHdrData = other.cbHdrData;
        this.rgbHdrData = other.rgbHdrData == null ? null : (byte[])other.rgbHdrData.clone();
    }

    public FeatHdrRecord(RecordInputStream in) {
        this.futureHeader = new FtrHeader(in);
        this.isf_sharedFeatureType = in.readShort();
        this.reserved = in.readByte();
        this.cbHdrData = in.readInt();
        switch (this.isf_sharedFeatureType) {
            case 2: {
                this.shared = this.cbHdrData == -1L ? new EnhancedProtection(in) : new EnhancedProtection();
                break;
            }
            default: {
                this.rgbHdrData = in.readRemainder();
            }
        }
    }

    @Override
    public short getSid() {
        return 2151;
    }

    @Override
    public void serialize(LittleEndianOutput out) {
        this.futureHeader.serialize(out);
        out.writeShort(this.isf_sharedFeatureType);
        out.writeByte(this.reserved);
        out.writeInt((int)this.cbHdrData);
        switch (this.isf_sharedFeatureType) {
            case 2: {
                ((EnhancedProtection)this.shared).serialize(out);
                break;
            }
            default: {
                out.write(this.rgbHdrData);
            }
        }
    }

    @Override
    protected int getDataSize() {
        int sz = 19;
        switch (this.isf_sharedFeatureType) {
            case 2: {
                sz += 4;
                break;
            }
            default: {
                sz += this.rgbHdrData.length;
            }
        }
        return sz;
    }

    @Override
    public FeatHdrRecord copy() {
        return new FeatHdrRecord(this);
    }

    @Override
    public HSSFRecordTypes getGenericRecordType() {
        return HSSFRecordTypes.FEAT_HDR;
    }

    @Override
    public Map<String, Supplier<?>> getGenericProperties() {
        return GenericRecordUtil.getGenericProperties("futureHeader", () -> this.futureHeader, "isf_sharedFeatureType", () -> this.isf_sharedFeatureType, "reserved", () -> this.reserved, "cbHdrData", () -> this.cbHdrData, "rgbHdrData", () -> this.rgbHdrData);
    }

    public boolean isEnhancedProtection() {
        return this.isf_sharedFeatureType == 2;
    }

    public EnhancedProtection getEnhancedProtection() {
        return this.isEnhancedProtection() ? (EnhancedProtection)this.shared : null;
    }
}

