/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.Map;
import java.util.function.Supplier;
import org.apache.poi.hssf.record.HSSFRecordTypes;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.hssf.record.common.FtrHeader;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.GenericRecordUtil;
import org.apache.poi.util.LittleEndianOutput;

public class Compat12Record
extends StandardRecord {
    private static final BitField fNoCompatChk = BitFieldFactory.getInstance(1);
    public static final short sid = 2188;
    private FtrHeader futureHeader;
    int bits;

    public Compat12Record() {
        this.futureHeader = new FtrHeader();
        this.futureHeader.setRecordType((short)2188);
    }

    public Compat12Record(RecordInputStream in) {
        this.futureHeader = new FtrHeader(in);
        this.bits = in.readInt();
    }

    @Override
    public short getSid() {
        return 2188;
    }

    @Override
    public HSSFRecordTypes getGenericRecordType() {
        return HSSFRecordTypes.COMPAT_12;
    }

    public boolean isNoCompatibleCheck() {
        return fNoCompatChk.isSet(this.bits);
    }

    public void setNoCompatibleCheck(boolean flag) {
        this.bits = fNoCompatChk.setBoolean(this.bits, flag);
    }

    @Override
    public void serialize(LittleEndianOutput out) {
        this.futureHeader.serialize(out);
        out.writeInt(this.bits);
    }

    @Override
    public Compat12Record copy() {
        return (Compat12Record)this.clone();
    }

    public Object clone() {
        return this.cloneViaReserialise();
    }

    @Override
    protected int getDataSize() {
        return 16;
    }

    @Override
    public Map<String, Supplier<?>> getGenericProperties() {
        return GenericRecordUtil.getGenericProperties("bits", () -> Integer.toHexString(this.bits), "fNoCompatChk", this::isNoCompatibleCheck);
    }
}

