/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xssf.usermodel.helpers;

import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellFormula;
import org.zkoss.poi.ss.formula.EvaluationWorkbook;
import org.zkoss.poi.ss.formula.FormulaParser;
import org.zkoss.poi.ss.formula.FormulaRenderer;
import org.zkoss.poi.ss.formula.FormulaRenderingWorkbook;
import org.zkoss.poi.ss.formula.ptg.NamePtg;
import org.zkoss.poi.ss.formula.ptg.NameXPtg;
import org.zkoss.poi.ss.formula.ptg.Ptg;
import org.zkoss.poi.ss.usermodel.Cell;
import org.zkoss.poi.ss.usermodel.Row;
import org.zkoss.poi.ss.usermodel.Sheet;
import org.zkoss.poi.xssf.usermodel.XSSFCell;
import org.zkoss.poi.xssf.usermodel.XSSFEvaluationWorkbook;
import org.zkoss.poi.xssf.usermodel.XSSFName;
import org.zkoss.poi.xssf.usermodel.XSSFWorkbook;

public final class XSSFFormulaUtils {
    private final XSSFWorkbook _wb;
    private final XSSFEvaluationWorkbook _fpwb;

    public XSSFFormulaUtils(XSSFWorkbook wb) {
        this._wb = wb;
        this._fpwb = XSSFEvaluationWorkbook.create(this._wb);
    }

    public void updateSheetName(final int sheetIndex, final String name) {
        FormulaRenderingWorkbook frwb = new FormulaRenderingWorkbook(){

            @Override
            public EvaluationWorkbook.ExternalSheet getExternalSheet(int externSheetIndex) {
                return XSSFFormulaUtils.this._fpwb.getExternalSheet(externSheetIndex);
            }

            @Override
            public String getSheetNameByExternSheet(int externSheetIndex) {
                if (externSheetIndex == sheetIndex) {
                    return name;
                }
                return XSSFFormulaUtils.this._fpwb.getSheetNameByExternSheet(externSheetIndex);
            }

            @Override
            public String resolveNameXText(NameXPtg nameXPtg) {
                return XSSFFormulaUtils.this._fpwb.resolveNameXText(nameXPtg);
            }

            @Override
            public String getNameText(NamePtg namePtg) {
                return XSSFFormulaUtils.this._fpwb.getNameText(namePtg);
            }

            @Override
            public String getExternalLinkIndexFromBookName(String bookname) {
                return XSSFFormulaUtils.this._fpwb.getExternalLinkIndexFromBookName(bookname);
            }

            @Override
            public String getFullNameText(NamePtg namePtg) {
                return XSSFFormulaUtils.this._fpwb.getNameText(namePtg);
            }
        };
        for (int i = 0; i < this._wb.getNumberOfNames(); ++i) {
            XSSFName nm = this._wb.getNameAt(i);
            if (nm.getSheetIndex() != -1 && nm.getSheetIndex() != sheetIndex) continue;
            this.updateName(nm, frwb);
        }
        for (Sheet sh : this._wb) {
            for (Row row : sh) {
                for (Cell cell : row) {
                    if (cell.getCellType() != 2) continue;
                    this.updateFormula((XSSFCell)cell, frwb);
                }
            }
        }
    }

    private void updateFormula(XSSFCell cell, FormulaRenderingWorkbook frwb) {
        int sheetIndex;
        Ptg[] ptgs;
        String updatedFormula;
        String formula;
        CTCellFormula f = cell.getCTCell().getF();
        if (f != null && (formula = f.getStringValue()) != null && formula.length() > 0 && !formula.equals(updatedFormula = FormulaRenderer.toFormulaString(frwb, ptgs = FormulaParser.parse(formula, this._fpwb, 0, sheetIndex = this._wb.getSheetIndex(cell.getSheet()))))) {
            f.setStringValue(updatedFormula);
        }
    }

    private void updateName(XSSFName name, FormulaRenderingWorkbook frwb) {
        int sheetIndex;
        Ptg[] ptgs;
        String updatedFormula;
        String formula = name.getRefersToFormula();
        if (formula != null && !formula.equals(updatedFormula = FormulaRenderer.toFormulaString(frwb, ptgs = FormulaParser.parse(formula, this._fpwb, 4, sheetIndex = name.getSheetIndex())))) {
            name.setRefersToFormula(updatedFormula);
        }
    }
}

