/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xssf.usermodel.helpers;

public class HeaderFooterHelper {
    private static final String HeaderFooterEntity_L = "&L";
    private static final String HeaderFooterEntity_C = "&C";
    private static final String HeaderFooterEntity_R = "&R";
    public static final String HeaderFooterEntity_File = "&F";
    public static final String HeaderFooterEntity_Date = "&D";
    public static final String HeaderFooterEntity_Time = "&T";
    private String[] _parts;

    public String getLeftSection(String string) {
        return this.getParts(string)[0];
    }

    public String getCenterSection(String string) {
        return this.getParts(string)[1];
    }

    public String getRightSection(String string) {
        return this.getParts(string)[2];
    }

    public String setLeftSection(String string, String newLeft) {
        String[] parts = this.getParts(string);
        parts[0] = newLeft;
        return this.joinParts(parts);
    }

    public String setCenterSection(String string, String newCenter) {
        String[] parts = this.getParts(string);
        parts[1] = newCenter;
        return this.joinParts(parts);
    }

    public String setRightSection(String string, String newRight) {
        String[] parts = this.getParts(string);
        parts[2] = newRight;
        return this.joinParts(parts);
    }

    private String joinParts(String[] parts) {
        return this.joinParts(parts[0], parts[1], parts[2]);
    }

    private String joinParts(String l, String c, String r) {
        StringBuffer ret = new StringBuffer();
        if (c.length() > 0) {
            ret.append(HeaderFooterEntity_C);
            ret.append(c);
        }
        if (l.length() > 0) {
            ret.append(HeaderFooterEntity_L);
            ret.append(l);
        }
        if (r.length() > 0) {
            ret.append(HeaderFooterEntity_R);
            ret.append(r);
        }
        return ret.toString();
    }

    private String[] getParts(String text) {
        if (this._parts != null) {
            return this._parts;
        }
        String _left = "";
        String _center = "";
        String _right = "";
        if (text == null || text.length() == 0) {
            this._parts = new String[]{_left, _center, _right};
            return this._parts;
        }
        block5: while (text.length() > 1) {
            int part = 67;
            int start = 0;
            if (text.charAt(0) == '&') {
                part = text.charAt(1);
                start = 2;
            }
            int pos1 = 0;
            int pos = text.length();
            switch (part) {
                case 76: {
                    pos1 = HeaderFooterHelper.indexOf(text, HeaderFooterEntity_L);
                    if (pos1 >= 0) {
                        pos = Math.min(pos, pos1);
                    }
                    if ((pos1 = HeaderFooterHelper.indexOf(text, HeaderFooterEntity_C)) >= 0) {
                        pos = Math.min(pos, pos1);
                    }
                    if ((pos1 = HeaderFooterHelper.indexOf(text, HeaderFooterEntity_R)) >= 0) {
                        pos = Math.min(pos, pos1);
                    }
                    _left = _left + text.substring(start, pos);
                    text = text.substring(pos);
                    continue block5;
                }
                case 67: {
                    pos1 = HeaderFooterHelper.indexOf(text, HeaderFooterEntity_L);
                    if (pos1 >= 0) {
                        pos = Math.min(pos, pos1);
                    }
                    if ((pos1 = HeaderFooterHelper.indexOf(text, HeaderFooterEntity_C)) >= 0) {
                        pos = Math.min(pos, pos1);
                    }
                    if ((pos1 = HeaderFooterHelper.indexOf(text, HeaderFooterEntity_R)) >= 0) {
                        pos = Math.min(pos, pos1);
                    }
                    _center = _center + text.substring(start, pos);
                    text = text.substring(pos);
                    continue block5;
                }
                case 82: {
                    pos1 = HeaderFooterHelper.indexOf(text, HeaderFooterEntity_L);
                    if (pos1 >= 0) {
                        pos = Math.min(pos, pos1);
                    }
                    if ((pos1 = HeaderFooterHelper.indexOf(text, HeaderFooterEntity_C)) >= 0) {
                        pos = Math.min(pos, pos1);
                    }
                    if ((pos1 = HeaderFooterHelper.indexOf(text, HeaderFooterEntity_R)) >= 0) {
                        pos = Math.min(pos, pos1);
                    }
                    _right = _right + text.substring(start, pos);
                    text = text.substring(pos);
                    continue block5;
                }
            }
            _center = _center + text.substring(start);
            break;
        }
        this._parts = new String[]{_left, _center, _right};
        return this._parts;
    }

    private static int indexOf(String text, String token) {
        int start = 1;
        while ((start = text.indexOf(token, start)) >= 0) {
            int count = 1;
            int j = start;
            while (--j >= 0 && text.charAt(j) == '&') {
                ++count;
            }
            if (count & true) {
                return start;
            }
            ++start;
        }
        return start;
    }
}

