/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xssf.usermodel.charts;

import java.util.ArrayList;
import java.util.List;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTAxDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBarChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBarSer;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTLineSer;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPlotArea;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTSerTx;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTStockChart;
import org.zkoss.poi.ss.usermodel.Chart;
import org.zkoss.poi.ss.usermodel.charts.AbstractCategoryDataSerie;
import org.zkoss.poi.ss.usermodel.charts.CategoryData;
import org.zkoss.poi.ss.usermodel.charts.CategoryDataSerie;
import org.zkoss.poi.ss.usermodel.charts.ChartAxis;
import org.zkoss.poi.ss.usermodel.charts.ChartDataSource;
import org.zkoss.poi.ss.usermodel.charts.ChartTextSource;
import org.zkoss.poi.xssf.usermodel.XSSFChart;
import org.zkoss.poi.xssf.usermodel.charts.XSSFChartAxDataSource;
import org.zkoss.poi.xssf.usermodel.charts.XSSFChartNumDataSource;
import org.zkoss.poi.xssf.usermodel.charts.XSSFChartTextSource;
import org.zkoss.poi.xssf.usermodel.charts.XSSFChartUtil;

public class XSSFStockChartData
implements CategoryData {
    private CTBarChart ctBarChart;
    private CTStockChart ctStockChart;
    private List<CategoryDataSerie> barSeries = new ArrayList<CategoryDataSerie>();
    private List<CategoryDataSerie> stockSeries = new ArrayList<CategoryDataSerie>();

    public XSSFStockChartData() {
    }

    public XSSFStockChartData(XSSFChart chart) {
        this();
        CTStockChart[] plotCharts;
        XSSFChartNumDataSource vals;
        XSSFChartAxDataSource cats;
        XSSFChartTextSource title;
        CTPlotArea plotArea = chart.getCTChart().getPlotArea();
        CTBarChart[] barCharts = plotArea.getBarChartArray();
        if (barCharts != null && barCharts.length > 0) {
            this.ctBarChart = barCharts[0];
        }
        if (this.ctBarChart != null) {
            CTBarSer[] bsers = this.ctBarChart.getSerArray();
            for (int j = 0; j < bsers.length; ++j) {
                CTBarSer ser = bsers[j];
                CTSerTx serTx = ser.getTx();
                title = serTx == null ? null : new XSSFChartTextSource(serTx);
                cats = new XSSFChartAxDataSource(ser.getCat());
                vals = new XSSFChartNumDataSource(ser.getVal());
                this.addBarSerie(j, title, cats, vals);
            }
        }
        if ((plotCharts = plotArea.getStockChartArray()) != null && plotCharts.length > 0) {
            this.ctStockChart = plotCharts[0];
        }
        if (this.ctStockChart != null) {
            CTLineSer[] bsers = this.ctStockChart.getSerArray();
            for (int j = 0; j < bsers.length; ++j) {
                CTLineSer ser = bsers[j];
                title = new XSSFChartTextSource(ser.getTx());
                cats = new XSSFChartAxDataSource(ser.getCat());
                vals = new XSSFChartNumDataSource(ser.getVal());
                this.addStockSerie(j, title, cats, vals);
            }
        }
    }

    @Override
    public void fillChart(Chart chart, ChartAxis ... axis) {
        CTPlotArea plotArea;
        XSSFChart xssfChart;
        if (!(chart instanceof XSSFChart)) {
            throw new IllegalArgumentException("Chart must be instance of XSSFChart");
        }
        if (this.ctBarChart == null) {
            xssfChart = (XSSFChart)chart;
            plotArea = xssfChart.getCTChart().getPlotArea();
            this.ctBarChart = plotArea.addNewBarChart();
            this.ctBarChart.addNewVaryColors().setVal(true);
            for (CategoryDataSerie s : this.barSeries) {
                ((Serie)s).addToChart(this.ctBarChart);
            }
        }
        if (this.ctStockChart == null) {
            xssfChart = (XSSFChart)chart;
            plotArea = xssfChart.getCTChart().getPlotArea();
            this.ctStockChart = plotArea.addNewStockChart();
            for (CategoryDataSerie s : this.stockSeries) {
                ((Serie)s).addToChart(this.ctStockChart);
            }
        }
    }

    private CategoryDataSerie addBarSerie(int order, ChartTextSource title, ChartDataSource<?> cats, ChartDataSource<? extends Number> vals) {
        return this.addSerie0(order, title, cats, vals, this.barSeries);
    }

    private CategoryDataSerie addStockSerie(int order, ChartTextSource title, ChartDataSource<?> cats, ChartDataSource<? extends Number> vals) {
        return this.addSerie0(order, title, cats, vals, this.stockSeries);
    }

    private CategoryDataSerie addSerie0(int order, ChartTextSource title, ChartDataSource<?> cats, ChartDataSource<? extends Number> vals, List<CategoryDataSerie> series) {
        if (!vals.isNumeric()) {
            throw new IllegalArgumentException("Bar data source must be numeric.");
        }
        Serie newSerie = new Serie(order, order, title, cats, vals);
        series.add(newSerie);
        return newSerie;
    }

    @Override
    public List<? extends CategoryDataSerie> getSeries() {
        ArrayList<CategoryDataSerie> series = new ArrayList<CategoryDataSerie>();
        series.addAll(this.barSeries);
        series.addAll(this.stockSeries);
        return series;
    }

    @Override
    public CategoryDataSerie addSerie(int order, ChartTextSource title, ChartDataSource<?> cats, ChartDataSource<? extends Number> vals) {
        if (!vals.isNumeric()) {
            throw new IllegalArgumentException("data source must be numeric.");
        }
        int numOfSeries = this.barSeries.size() + this.stockSeries.size();
        Serie newSerie = new Serie(numOfSeries, order, title, cats, vals);
        if (numOfSeries > 0) {
            this.stockSeries.add(newSerie);
        } else {
            this.barSeries.add(newSerie);
        }
        return newSerie;
    }

    static class Serie
    extends AbstractCategoryDataSerie {
        protected Serie(int id, int order, ChartTextSource title, ChartDataSource<?> cats, ChartDataSource<? extends Number> vals) {
            super(id, order, title, cats, vals);
        }

        protected void addToChart(CTBarChart ctBarChart) {
            CTBarSer barSer = ctBarChart.addNewSer();
            barSer.addNewIdx().setVal((long)this.id);
            barSer.addNewOrder().setVal((long)this.order);
            if (this.title != null) {
                CTSerTx tx = barSer.addNewTx();
                XSSFChartUtil.buildSerTx(tx, this.title);
            }
            if (this.categories != null && this.categories.getPointCount() > 0) {
                CTAxDataSource cats = barSer.addNewCat();
                XSSFChartUtil.buildAxDataSource(cats, this.categories);
            }
            CTNumDataSource vals = barSer.addNewVal();
            XSSFChartUtil.buildNumDataSource(vals, this.values);
        }

        protected void addToChart(CTStockChart ctStockChart) {
            CTLineSer lineSer = ctStockChart.addNewSer();
            lineSer.addNewIdx().setVal((long)this.id);
            lineSer.addNewOrder().setVal((long)this.order);
            CTSerTx tx = lineSer.addNewTx();
            XSSFChartUtil.buildSerTx(tx, this.title);
            CTAxDataSource cats = lineSer.addNewCat();
            XSSFChartUtil.buildAxDataSource(cats, this.categories);
            CTNumDataSource vals = lineSer.addNewVal();
            XSSFChartUtil.buildNumDataSource(vals, this.values);
        }
    }
}

