/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xssf.usermodel.charts;

import java.util.ArrayList;
import java.util.List;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTAxDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTDPt;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTMarker;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPlotArea;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTScatterChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTScatterSer;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTSerTx;
import org.openxmlformats.schemas.drawingml.x2006.chart.STMarkerStyle;
import org.openxmlformats.schemas.drawingml.x2006.chart.STScatterStyle;
import org.zkoss.poi.ss.usermodel.Chart;
import org.zkoss.poi.ss.usermodel.charts.AbstractXYDataSerie;
import org.zkoss.poi.ss.usermodel.charts.ChartAxis;
import org.zkoss.poi.ss.usermodel.charts.ChartDataSource;
import org.zkoss.poi.ss.usermodel.charts.ChartTextSource;
import org.zkoss.poi.ss.usermodel.charts.XYData;
import org.zkoss.poi.ss.usermodel.charts.XYDataSerie;
import org.zkoss.poi.xssf.usermodel.XSSFChart;
import org.zkoss.poi.xssf.usermodel.charts.XSSFChartAxDataSource;
import org.zkoss.poi.xssf.usermodel.charts.XSSFChartNumDataSource;
import org.zkoss.poi.xssf.usermodel.charts.XSSFChartTextSource;
import org.zkoss.poi.xssf.usermodel.charts.XSSFChartUtil;

public class XSSFScatChartData
implements XYData {
    private CTScatterChart ctScatterChart;
    private List<XYDataSerie> series = new ArrayList<XYDataSerie>();

    public XSSFScatChartData() {
    }

    public XSSFScatChartData(XSSFChart chart) {
        this();
        CTPlotArea plotArea = chart.getCTChart().getPlotArea();
        CTScatterChart[] plotCharts = plotArea.getScatterChartArray();
        if (plotCharts != null && plotCharts.length > 0) {
            this.ctScatterChart = plotCharts[0];
        }
        if (this.ctScatterChart != null) {
            this.ctScatterChart.addNewScatterStyle().setVal(STScatterStyle.LINE_MARKER);
            CTScatterSer[] sers = this.ctScatterChart.getSerArray();
            for (int j = 0; j < sers.length; ++j) {
                CTScatterSer ser = sers[j];
                CTSerTx serTx = ser.getTx();
                XSSFChartTextSource title = serTx == null ? null : new XSSFChartTextSource(serTx);
                ser.addNewSpPr().addNewLn().addNewNoFill();
                CTMarker ctMarker = ser.addNewMarker();
                ctMarker.addNewSymbol().setVal(STMarkerStyle.CIRCLE);
                ctMarker.addNewSize().setVal((short)5);
                XSSFChartAxDataSource xs = new XSSFChartAxDataSource(ser.getXVal());
                XSSFChartNumDataSource ys = new XSSFChartNumDataSource(ser.getYVal());
                this.addSerie(j, title, xs, ys);
            }
        }
    }

    @Override
    public void fillChart(Chart chart, ChartAxis ... axis) {
        if (!(chart instanceof XSSFChart)) {
            throw new IllegalArgumentException("Chart must be instance of XSSFChart");
        }
        if (this.ctScatterChart == null) {
            XSSFChart xssfChart = (XSSFChart)chart;
            CTPlotArea plotArea = xssfChart.getCTChart().getPlotArea();
            this.ctScatterChart = plotArea.addNewScatterChart();
            this.ctScatterChart.addNewVaryColors().setVal(true);
            this.ctScatterChart.addNewScatterStyle().setVal(STScatterStyle.LINE_MARKER);
            for (XYDataSerie s : this.series) {
                ((Serie)s).addToChart(this.ctScatterChart);
            }
        }
        for (ChartAxis a : axis) {
            this.ctScatterChart.addNewAxId().setVal(a.getId());
        }
    }

    @Override
    public List<? extends XYDataSerie> getSeries() {
        return this.series;
    }

    @Override
    public XYDataSerie addSerie(int order, ChartTextSource title, ChartDataSource<? extends Number> xs, ChartDataSource<? extends Number> ys) {
        if (!xs.isNumeric()) {
            xs = XSSFChartUtil.buildDefaultNumDataSource(xs);
        }
        if (!ys.isNumeric()) {
            throw new IllegalArgumentException("Y Axis data source must be numeric.");
        }
        Serie newSerie = new Serie(order, order, title, xs, ys);
        this.series.add(newSerie);
        return newSerie;
    }

    static class Serie
    extends AbstractXYDataSerie {
        protected Serie(int id, int order, ChartTextSource title, ChartDataSource<? extends Number> xs, ChartDataSource<? extends Number> ys) {
            super(id, order, title, xs, ys);
        }

        protected void addToChart(CTScatterChart ctScatterChart) {
            CTScatterSer scatterSer = ctScatterChart.addNewSer();
            scatterSer.addNewIdx().setVal((long)this.id);
            scatterSer.addNewOrder().setVal((long)this.order);
            if (this.title != null) {
                CTSerTx tx = scatterSer.addNewTx();
                XSSFChartUtil.buildSerTx(tx, this.title);
            }
            scatterSer.addNewSpPr().addNewLn().addNewNoFill();
            CTMarker ctMarker = scatterSer.addNewMarker();
            if (this.getColor() != null) {
                XSSFChartUtil.buildFillColor(ctMarker.addNewSpPr(), this.getColor());
            }
            ctMarker.addNewSymbol().setVal(STMarkerStyle.CIRCLE);
            ctMarker.addNewSize().setVal((short)5);
            if (this.getDataPointColors() != null) {
                this.getDataPointColors().forEach((k, v) -> {
                    CTDPt ctDpt = scatterSer.addNewDPt();
                    ctDpt.addNewIdx().setVal((long)k.intValue());
                    XSSFChartUtil.buildFillColor(ctDpt.addNewMarker().addNewSpPr(), v);
                });
            }
            CTAxDataSource cats = scatterSer.addNewXVal();
            XSSFChartUtil.buildAxDataSource(cats, this.xs);
            CTNumDataSource vals = scatterSer.addNewYVal();
            XSSFChartUtil.buildNumDataSource(vals, this.ys);
        }
    }
}

