/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xssf.usermodel.charts;

import java.util.ArrayList;
import java.util.List;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTAxDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTDPt;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPieChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPieSer;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPlotArea;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTSerTx;
import org.zkoss.poi.ss.usermodel.Chart;
import org.zkoss.poi.ss.usermodel.charts.AbstractCategoryDataSerie;
import org.zkoss.poi.ss.usermodel.charts.CategoryData;
import org.zkoss.poi.ss.usermodel.charts.CategoryDataSerie;
import org.zkoss.poi.ss.usermodel.charts.ChartAxis;
import org.zkoss.poi.ss.usermodel.charts.ChartDataSource;
import org.zkoss.poi.ss.usermodel.charts.ChartTextSource;
import org.zkoss.poi.xssf.usermodel.XSSFChart;
import org.zkoss.poi.xssf.usermodel.charts.XSSFChartAxDataSource;
import org.zkoss.poi.xssf.usermodel.charts.XSSFChartNumDataSource;
import org.zkoss.poi.xssf.usermodel.charts.XSSFChartTextSource;
import org.zkoss.poi.xssf.usermodel.charts.XSSFChartUtil;

public class XSSFPieChartData
implements CategoryData {
    private CTPieChart ctPieChart;
    private List<CategoryDataSerie> series = new ArrayList<CategoryDataSerie>();

    public XSSFPieChartData() {
    }

    public XSSFPieChartData(XSSFChart chart) {
        this();
        CTPlotArea plotArea = chart.getCTChart().getPlotArea();
        CTPieChart[] plotCharts = plotArea.getPieChartArray();
        if (plotCharts != null && plotCharts.length > 0) {
            this.ctPieChart = plotCharts[0];
        }
        if (this.ctPieChart != null) {
            CTPieSer[] bsers = this.ctPieChart.getSerArray();
            for (int j = 0; j < bsers.length; ++j) {
                CTPieSer ser = bsers[j];
                CTSerTx serTx = ser.getTx();
                XSSFChartTextSource title = serTx == null ? null : new XSSFChartTextSource(serTx);
                XSSFChartAxDataSource cats = new XSSFChartAxDataSource(ser.getCat());
                XSSFChartNumDataSource vals = new XSSFChartNumDataSource(ser.getVal());
                this.addSerie(j, title, cats, vals);
            }
        }
    }

    @Override
    public CategoryDataSerie addSerie(int order, ChartTextSource title, ChartDataSource<?> cats, ChartDataSource<? extends Number> vals) {
        if (!vals.isNumeric()) {
            throw new IllegalArgumentException("Pie data source must be numeric.");
        }
        Serie newSerie = new Serie(order, order, title, cats, vals);
        this.series.add(newSerie);
        return newSerie;
    }

    @Override
    public void fillChart(Chart chart, ChartAxis ... axis) {
        if (!(chart instanceof XSSFChart)) {
            throw new IllegalArgumentException("Chart must be instance of XSSFChart");
        }
        if (this.ctPieChart == null) {
            XSSFChart xssfChart = (XSSFChart)chart;
            CTPlotArea plotArea = xssfChart.getCTChart().getPlotArea();
            this.ctPieChart = plotArea.addNewPieChart();
            this.ctPieChart.addNewVaryColors().setVal(true);
            for (CategoryDataSerie s : this.series) {
                ((Serie)s).addToChart(this.ctPieChart);
            }
        }
    }

    @Override
    public List<? extends CategoryDataSerie> getSeries() {
        return this.series;
    }

    static class Serie
    extends AbstractCategoryDataSerie {
        protected Serie(int id, int order, ChartTextSource title, ChartDataSource<?> cats, ChartDataSource<? extends Number> vals) {
            super(id, order, title, cats, vals);
        }

        protected void addToChart(CTPieChart ctPieChart) {
            CTPieSer pieSer = ctPieChart.addNewSer();
            pieSer.addNewIdx().setVal((long)this.id);
            pieSer.addNewOrder().setVal((long)this.order);
            if (this.title != null) {
                CTSerTx tx = pieSer.addNewTx();
                XSSFChartUtil.buildSerTx(tx, this.title);
            }
            if (this.color != null) {
                XSSFChartUtil.buildFillColor(pieSer.addNewSpPr(), this.color);
            }
            if (this.dataPointColors != null) {
                this.dataPointColors.forEach((k, v) -> {
                    CTDPt ctDpt = pieSer.addNewDPt();
                    ctDpt.addNewIdx().setVal((long)k.intValue());
                    XSSFChartUtil.buildFillColor(ctDpt.addNewSpPr(), v);
                });
            }
            if (this.categories != null && this.categories.getPointCount() > 0) {
                CTAxDataSource cats = pieSer.addNewCat();
                XSSFChartUtil.buildAxDataSource(cats, this.categories);
            }
            CTNumDataSource vals = pieSer.addNewVal();
            XSSFChartUtil.buildNumDataSource(vals, this.values);
        }
    }
}

