/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xssf.usermodel.charts;

import java.util.regex.Pattern;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTSerTx;
import org.zkoss.poi.ss.formula.SheetNameFormatter;
import org.zkoss.poi.ss.usermodel.charts.ChartTextSource;

public class XSSFChartTextSource
implements ChartTextSource {
    private final CTSerTx tx;

    public XSSFChartTextSource(CTSerTx tx) {
        this.tx = tx;
    }

    @Override
    public boolean isReference() {
        return this.tx == null ? false : this.tx.isSetStrRef();
    }

    @Override
    public String getTextString() {
        return this.tx == null ? "" : this.tx.getV();
    }

    @Override
    public String getFormulaString() {
        return this.tx == null ? null : this.tx.getStrRef().getF();
    }

    @Override
    public void renameSheet(String oldname, String newname) {
        if (this.isReference()) {
            String o = SheetNameFormatter.format(oldname);
            String n = SheetNameFormatter.format(newname);
            String ref = this.tx.getStrRef().getF();
            Pattern p = Pattern.compile(o + "!", 16);
            String newref = p.matcher(ref).replaceAll(n + "!");
            if (!newref.equals(ref)) {
                this.tx.getStrRef().setF(newref);
                if (this.tx.getStrRef().getStrCache() != null) {
                    this.tx.getStrRef().unsetStrCache();
                }
            }
        }
    }
}

