/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xssf.usermodel.charts;

import org.openxmlformats.schemas.drawingml.x2006.chart.CTAxPos;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTCatAx;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTCrosses;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTLblAlgn;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumFmt;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTScaling;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTTickLblPos;
import org.openxmlformats.schemas.drawingml.x2006.chart.STLblAlgn;
import org.openxmlformats.schemas.drawingml.x2006.chart.STTickLblPos;
import org.openxmlformats.schemas.drawingml.x2006.chart.STTickMark;
import org.openxmlformats.schemas.drawingml.x2006.main.CTLineProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNoFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeProperties;
import org.zkoss.poi.ss.usermodel.charts.AxisCrosses;
import org.zkoss.poi.ss.usermodel.charts.AxisLabelAlign;
import org.zkoss.poi.ss.usermodel.charts.AxisOrientation;
import org.zkoss.poi.ss.usermodel.charts.AxisPosition;
import org.zkoss.poi.ss.usermodel.charts.CategoryAxis;
import org.zkoss.poi.ss.usermodel.charts.ChartAxis;
import org.zkoss.poi.xssf.usermodel.XSSFChart;
import org.zkoss.poi.xssf.usermodel.charts.XSSFChartAxis;

public class XSSFCategoryAxis
extends XSSFChartAxis
implements CategoryAxis {
    private CTCatAx ctCatAx;

    public XSSFCategoryAxis(XSSFChart chart, long id, AxisPosition pos) {
        super(chart);
        this.createAxis(id, pos);
    }

    public XSSFCategoryAxis(XSSFChart chart, CTCatAx ctCatAx) {
        super(chart);
        this.ctCatAx = ctCatAx;
    }

    @Override
    public long getId() {
        return this.ctCatAx.getAxId().getVal();
    }

    @Override
    public void setId(long id) {
        this.ctCatAx.getAxId().setVal(id);
    }

    @Override
    public boolean isDelete() {
        return this.ctCatAx.getDelete().getVal();
    }

    @Override
    public void setDelete(boolean delete) {
        this.ctCatAx.getDelete().setVal(delete);
    }

    @Override
    protected CTAxPos getCTAxPos() {
        return this.ctCatAx.getAxPos();
    }

    @Override
    protected CTNumFmt getCTNumFmt() {
        if (this.ctCatAx.isSetNumFmt()) {
            return this.ctCatAx.getNumFmt();
        }
        return this.ctCatAx.addNewNumFmt();
    }

    @Override
    protected CTScaling getCTScaling() {
        return this.ctCatAx.getScaling();
    }

    @Override
    protected CTCrosses getCTCrosses() {
        return this.ctCatAx.getCrosses();
    }

    @Override
    public void crossAxis(ChartAxis axis) {
        this.ctCatAx.getCrossAx().setVal(axis.getId());
    }

    @Override
    public void setMajorGridline(boolean majorGridline) {
        if (majorGridline) {
            this.fillMajorGridline(this.ctCatAx.addNewMajorGridlines());
        } else {
            this.ctCatAx.unsetMajorGridlines();
        }
    }

    private void createAxis(long id, AxisPosition pos) {
        this.ctCatAx = this.chart.getCTChart().getPlotArea().addNewCatAx();
        this.ctCatAx.addNewAxId().setVal(id);
        this.ctCatAx.addNewAxPos();
        this.ctCatAx.addNewDelete();
        this.ctCatAx.addNewScaling();
        this.ctCatAx.addNewCrosses();
        this.ctCatAx.addNewCrossAx();
        this.ctCatAx.addNewTickLblPos().setVal(STTickLblPos.NEXT_TO);
        this.ctCatAx.addNewMajorTickMark().setVal(STTickMark.OUT);
        this.ctCatAx.addNewMinorTickMark().setVal(STTickMark.NONE);
        CTShapeProperties spPr = this.ctCatAx.addNewSpPr();
        spPr.setNoFill(CTNoFillProperties.Factory.newInstance());
        CTLineProperties lnPr = CTLineProperties.Factory.newInstance();
        lnPr.setNoFill(CTNoFillProperties.Factory.newInstance());
        spPr.setLn(lnPr);
        this.setPosition(pos);
        this.setOrientation(AxisOrientation.MIN_MAX);
        this.setCrosses(AxisCrosses.AUTO_ZERO);
    }

    @Override
    protected CTTickLblPos getTickLblPos() {
        return this.ctCatAx.getTickLblPos();
    }

    @Override
    public AxisLabelAlign getLabelAlign() {
        return XSSFCategoryAxis.toLabelAlign(this.ctCatAx.getLblAlgn());
    }

    @Override
    public void setLabelAlign(AxisLabelAlign labelAlign) {
        CTLblAlgn ctLblAlgn = !this.ctCatAx.isSetLblAlgn() ? this.ctCatAx.addNewLblAlgn() : this.ctCatAx.getLblAlgn();
        ctLblAlgn.setVal(XSSFCategoryAxis.fromLabelAlign(labelAlign));
    }

    @Override
    public int getLabelOffset() {
        return 0;
    }

    @Override
    public void setLabelOffset(int offset) {
    }

    private static STLblAlgn.Enum fromLabelAlign(AxisLabelAlign lblAlign) {
        switch (lblAlign) {
            case LEFT: {
                return STLblAlgn.L;
            }
            case CENTER: {
                return STLblAlgn.CTR;
            }
            case RIGHT: {
                return STLblAlgn.R;
            }
        }
        throw new IllegalArgumentException();
    }

    private static AxisLabelAlign toLabelAlign(CTLblAlgn ctLblAlgn) {
        switch (ctLblAlgn.getVal().intValue()) {
            case 1: {
                return AxisLabelAlign.CENTER;
            }
            case 2: {
                return AxisLabelAlign.LEFT;
            }
            case 3: {
                return AxisLabelAlign.RIGHT;
            }
        }
        throw new IllegalArgumentException();
    }
}

