/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xssf.usermodel.charts;

import java.util.ArrayList;
import java.util.List;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTAxDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBubbleChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBubbleSer;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTDPt;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPlotArea;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTSerTx;
import org.zkoss.poi.ss.usermodel.Chart;
import org.zkoss.poi.ss.usermodel.charts.AbstractXYZDataSerie;
import org.zkoss.poi.ss.usermodel.charts.ChartAxis;
import org.zkoss.poi.ss.usermodel.charts.ChartDataSource;
import org.zkoss.poi.ss.usermodel.charts.ChartTextSource;
import org.zkoss.poi.ss.usermodel.charts.XYZData;
import org.zkoss.poi.ss.usermodel.charts.XYZDataSerie;
import org.zkoss.poi.xssf.usermodel.XSSFChart;
import org.zkoss.poi.xssf.usermodel.charts.XSSFChartAxDataSource;
import org.zkoss.poi.xssf.usermodel.charts.XSSFChartNumDataSource;
import org.zkoss.poi.xssf.usermodel.charts.XSSFChartTextSource;
import org.zkoss.poi.xssf.usermodel.charts.XSSFChartUtil;

public class XSSFBubbleChartData
implements XYZData {
    private CTBubbleChart ctBubbleChart;
    private List<XYZDataSerie> series = new ArrayList<XYZDataSerie>();

    public XSSFBubbleChartData() {
    }

    public XSSFBubbleChartData(XSSFChart chart) {
        this();
        CTPlotArea plotArea = chart.getCTChart().getPlotArea();
        CTBubbleChart[] plotCharts = plotArea.getBubbleChartArray();
        if (plotCharts != null && plotCharts.length > 0) {
            this.ctBubbleChart = plotCharts[0];
        }
        if (this.ctBubbleChart != null) {
            CTBubbleSer[] sers = this.ctBubbleChart.getSerArray();
            for (int j = 0; j < sers.length; ++j) {
                CTBubbleSer ser = sers[j];
                CTSerTx serTx = ser.getTx();
                XSSFChartTextSource title = serTx == null ? null : new XSSFChartTextSource(serTx);
                XSSFChartAxDataSource xs = new XSSFChartAxDataSource(ser.getXVal());
                XSSFChartNumDataSource ys = new XSSFChartNumDataSource(ser.getYVal());
                XSSFChartNumDataSource zs = new XSSFChartNumDataSource(ser.getBubbleSize());
                this.addSerie(j, title, xs, ys, zs);
            }
        }
    }

    @Override
    public void fillChart(Chart chart, ChartAxis ... axis) {
        if (!(chart instanceof XSSFChart)) {
            throw new IllegalArgumentException("Chart must be instance of XSSFChart");
        }
        if (this.ctBubbleChart == null) {
            XSSFChart xssfChart = (XSSFChart)chart;
            CTPlotArea plotArea = xssfChart.getCTChart().getPlotArea();
            this.ctBubbleChart = plotArea.addNewBubbleChart();
            this.ctBubbleChart.addNewVaryColors().setVal(true);
            for (XYZDataSerie s : this.series) {
                ((Serie)s).addToChart(this.ctBubbleChart);
            }
        }
        for (ChartAxis a : axis) {
            this.ctBubbleChart.addNewAxId().setVal(a.getId());
        }
    }

    @Override
    public List<? extends XYZDataSerie> getSeries() {
        return this.series;
    }

    @Override
    public XYZDataSerie addSerie(int order, ChartTextSource title, ChartDataSource<? extends Number> xs, ChartDataSource<? extends Number> ys, ChartDataSource<? extends Number> zs) {
        if (!xs.isNumeric()) {
            xs = XSSFChartUtil.buildDefaultNumDataSource(xs);
        }
        if (!ys.isNumeric()) {
            throw new IllegalArgumentException("Y Axis data source must be numeric.");
        }
        if (!zs.isNumeric()) {
            throw new IllegalArgumentException("Bubble size data source must be numeric.");
        }
        Serie newSerie = new Serie(order, order, title, xs, ys, zs);
        this.series.add(newSerie);
        return newSerie;
    }

    static class Serie
    extends AbstractXYZDataSerie {
        protected Serie(int id, int order, ChartTextSource title, ChartDataSource<? extends Number> xs, ChartDataSource<? extends Number> ys, ChartDataSource<? extends Number> zs) {
            super(id, order, title, xs, ys, zs);
        }

        protected void addToChart(CTBubbleChart ctBubbleChart) {
            CTBubbleSer bubbleSer = ctBubbleChart.addNewSer();
            bubbleSer.addNewIdx().setVal((long)this.id);
            bubbleSer.addNewOrder().setVal((long)this.order);
            if (this.title != null) {
                CTSerTx tx = bubbleSer.addNewTx();
                XSSFChartUtil.buildSerTx(tx, this.title);
            }
            if (this.getColor() != null) {
                XSSFChartUtil.buildFillColor(bubbleSer.addNewSpPr(), this.getColor());
            }
            if (this.getDataPointColors() != null) {
                this.getDataPointColors().forEach((k, v) -> {
                    CTDPt ctDpt = bubbleSer.addNewDPt();
                    ctDpt.addNewIdx().setVal((long)k.intValue());
                    XSSFChartUtil.buildFillColor(ctDpt.addNewSpPr(), v);
                });
            }
            CTAxDataSource xs = bubbleSer.addNewXVal();
            XSSFChartUtil.buildAxDataSource(xs, this.xs);
            CTNumDataSource ys = bubbleSer.addNewYVal();
            XSSFChartUtil.buildNumDataSource(ys, this.ys);
            CTNumDataSource zs = bubbleSer.addNewBubbleSize();
            XSSFChartUtil.buildNumDataSource(zs, this.zs);
        }
    }
}

