/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xssf.usermodel.charts;

import java.util.ArrayList;
import java.util.List;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTAreaChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTAreaSer;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTAxDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTGrouping;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPlotArea;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTSerTx;
import org.zkoss.poi.ss.usermodel.Chart;
import org.zkoss.poi.ss.usermodel.charts.AbstractCategoryDataSerie;
import org.zkoss.poi.ss.usermodel.charts.CategoryData;
import org.zkoss.poi.ss.usermodel.charts.CategoryDataSerie;
import org.zkoss.poi.ss.usermodel.charts.ChartAxis;
import org.zkoss.poi.ss.usermodel.charts.ChartDataSource;
import org.zkoss.poi.ss.usermodel.charts.ChartGrouping;
import org.zkoss.poi.ss.usermodel.charts.ChartTextSource;
import org.zkoss.poi.xssf.usermodel.XSSFChart;
import org.zkoss.poi.xssf.usermodel.charts.XSSFChartAxDataSource;
import org.zkoss.poi.xssf.usermodel.charts.XSSFChartNumDataSource;
import org.zkoss.poi.xssf.usermodel.charts.XSSFChartTextSource;
import org.zkoss.poi.xssf.usermodel.charts.XSSFChartUtil;

public class XSSFAreaChartData
implements CategoryData {
    private CTAreaChart ctAreaChart;
    private ChartGrouping _chartGrouping;
    private List<CategoryDataSerie> series = new ArrayList<CategoryDataSerie>();

    public XSSFAreaChartData() {
    }

    public XSSFAreaChartData(XSSFChart chart) {
        this();
        CTPlotArea plotArea = chart.getCTChart().getPlotArea();
        CTAreaChart[] plotCharts = plotArea.getAreaChartArray();
        if (plotCharts != null && plotCharts.length > 0) {
            this.ctAreaChart = plotCharts[0];
        }
        if (this.ctAreaChart != null) {
            CTAreaSer[] bsers = this.ctAreaChart.getSerArray();
            for (int j = 0; j < bsers.length; ++j) {
                CTAreaSer ser = bsers[j];
                CTSerTx serTx = ser.getTx();
                XSSFChartTextSource title = serTx == null ? null : new XSSFChartTextSource(serTx);
                XSSFChartAxDataSource cats = new XSSFChartAxDataSource(ser.getCat());
                XSSFChartNumDataSource vals = new XSSFChartNumDataSource(ser.getVal());
                this.addSerie(j, title, cats, vals);
            }
        }
    }

    public ChartGrouping getGrouping() {
        return XSSFChartUtil.toChartGrouping(this.ctAreaChart.getGrouping());
    }

    public void setGrouping(ChartGrouping grouping) {
        this._chartGrouping = grouping;
        if (this.ctAreaChart != null) {
            CTGrouping ctGrouping = this.ctAreaChart.getGrouping();
            if (ctGrouping == null) {
                ctGrouping = this.ctAreaChart.addNewGrouping();
            }
            ctGrouping.setVal(XSSFChartUtil.fromChartGrouping(this._chartGrouping));
        }
    }

    @Override
    public CategoryDataSerie addSerie(int order, ChartTextSource title, ChartDataSource<?> cats, ChartDataSource<? extends Number> vals) {
        if (!vals.isNumeric()) {
            throw new IllegalArgumentException("Pie data source must be numeric.");
        }
        Serie newSerie = new Serie(order, order, title, cats, vals);
        this.series.add(newSerie);
        return newSerie;
    }

    @Override
    public void fillChart(Chart chart, ChartAxis ... axis) {
        if (!(chart instanceof XSSFChart)) {
            throw new IllegalArgumentException("Chart must be instance of XSSFChart");
        }
        if (this.ctAreaChart == null) {
            XSSFChart xssfChart = (XSSFChart)chart;
            CTPlotArea plotArea = xssfChart.getCTChart().getPlotArea();
            this.ctAreaChart = plotArea.addNewAreaChart();
            this.ctAreaChart.addNewVaryColors().setVal(true);
            this.setGrouping(this._chartGrouping);
            for (CategoryDataSerie s : this.series) {
                ((Serie)s).addToChart(this.ctAreaChart);
            }
        }
        for (ChartAxis a : axis) {
            this.ctAreaChart.addNewAxId().setVal(a.getId());
        }
    }

    @Override
    public List<? extends CategoryDataSerie> getSeries() {
        return this.series;
    }

    static class Serie
    extends AbstractCategoryDataSerie {
        protected Serie(int id, int order, ChartTextSource title, ChartDataSource<?> cats, ChartDataSource<? extends Number> vals) {
            super(id, order, title, cats, vals);
        }

        protected void addToChart(CTAreaChart ctAreaChart) {
            CTAreaSer areaSer = ctAreaChart.addNewSer();
            areaSer.addNewIdx().setVal((long)this.id);
            areaSer.addNewOrder().setVal((long)this.order);
            if (this.title != null) {
                CTSerTx tx = areaSer.addNewTx();
                XSSFChartUtil.buildSerTx(tx, this.title);
            }
            if (this.color != null) {
                XSSFChartUtil.buildFillColor(areaSer.addNewSpPr(), this.color);
            }
            if (this.categories != null && this.categories.getPointCount() > 0) {
                CTAxDataSource cats = areaSer.addNewCat();
                XSSFChartUtil.buildAxDataSource(cats, this.categories);
            }
            CTNumDataSource vals = areaSer.addNewVal();
            XSSFChartUtil.buildNumDataSource(vals, this.values);
        }
    }
}

