/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xssf.usermodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTable;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTableColumn;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTableStyleInfo;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.TableDocument;
import org.zkoss.poi.POIXMLDocumentPart;
import org.zkoss.poi.openxml4j.opc.PackagePart;
import org.zkoss.poi.openxml4j.opc.PackageRelationship;
import org.zkoss.poi.ss.util.CellReference;
import org.zkoss.poi.xssf.usermodel.XSSFAutoFilter;
import org.zkoss.poi.xssf.usermodel.XSSFSheet;
import org.zkoss.poi.xssf.usermodel.XSSFTableColumn;
import org.zkoss.poi.xssf.usermodel.XSSFTableStyleInfo;
import org.zkoss.poi.xssf.usermodel.helpers.XSSFXmlColumnPr;

public class XSSFTable
extends POIXMLDocumentPart {
    private CTTable ctTable;
    private List<XSSFXmlColumnPr> xmlColumnPr;
    private CellReference startCellReference;
    private CellReference endCellReference;
    private String commonXPath;
    private List<XSSFTableColumn> _columns;
    private XSSFAutoFilter _autoFilter;

    public XSSFTable() {
        this.ctTable = CTTable.Factory.newInstance();
        this.initAutoFilter();
    }

    public XSSFTable(PackagePart part, PackageRelationship rel) throws IOException {
        super(part, rel);
        this.readFrom(part.getInputStream());
        this.initAutoFilter();
    }

    public void readFrom(InputStream is) throws IOException {
        try {
            TableDocument doc = TableDocument.Factory.parse((InputStream)is);
            this.ctTable = doc.getTable();
        }
        catch (XmlException e) {
            throw new IOException(e.getLocalizedMessage());
        }
    }

    public XSSFSheet getXSSFSheet() {
        return (XSSFSheet)this.getParent();
    }

    public void writeTo(OutputStream out) throws IOException {
        TableDocument doc = TableDocument.Factory.newInstance();
        doc.setTable(this.ctTable);
        doc.save(out, DEFAULT_XML_OPTIONS);
    }

    @Override
    protected void commit() throws IOException {
        PackagePart part = this.getPackagePart();
        OutputStream out = part.getOutputStream();
        this.writeTo(out);
        out.close();
    }

    public CTTable getCTTable() {
        return this.ctTable;
    }

    public boolean mapsTo(long id) {
        boolean maps = false;
        List<XSSFXmlColumnPr> pointers = this.getXmlColumnPrs();
        for (XSSFXmlColumnPr pointer : pointers) {
            if (pointer.getMapId() != id) continue;
            maps = true;
            break;
        }
        return maps;
    }

    public String getCommonXpath() {
        if (this.commonXPath == null) {
            String[] commonTokens = new String[]{};
            block0: for (CTTableColumn column : this.ctTable.getTableColumns().getTableColumnList()) {
                if (column.getXmlColumnPr() == null) continue;
                String xpath = column.getXmlColumnPr().getXpath();
                String[] tokens = xpath.split("/");
                if (commonTokens.length == 0) {
                    commonTokens = tokens;
                    continue;
                }
                int maxLenght = commonTokens.length > tokens.length ? tokens.length : commonTokens.length;
                for (int i = 0; i < maxLenght; ++i) {
                    if (commonTokens[i].equals(tokens[i])) continue;
                    List<String> subCommonTokens = Arrays.asList(commonTokens).subList(0, i);
                    String[] container = new String[]{};
                    commonTokens = subCommonTokens.toArray(container);
                    continue block0;
                }
            }
            this.commonXPath = "";
            for (int i = 1; i < commonTokens.length; ++i) {
                this.commonXPath = this.commonXPath + "/" + commonTokens[i];
            }
        }
        return this.commonXPath;
    }

    public List<XSSFXmlColumnPr> getXmlColumnPrs() {
        if (this.xmlColumnPr == null) {
            this.xmlColumnPr = new Vector<XSSFXmlColumnPr>();
            for (CTTableColumn column : this.ctTable.getTableColumns().getTableColumnList()) {
                if (column.getXmlColumnPr() == null) continue;
                XSSFXmlColumnPr columnPr = new XSSFXmlColumnPr(this, column, column.getXmlColumnPr());
                this.xmlColumnPr.add(columnPr);
            }
        }
        return this.xmlColumnPr;
    }

    public String getName() {
        return this.ctTable.getName();
    }

    public void setName(String name) {
        if (name == null) {
            this.ctTable.unsetName();
            return;
        }
        this.ctTable.setName(name);
    }

    public String getDisplayName() {
        return this.ctTable.getDisplayName();
    }

    public void setDisplayName(String name) {
        this.ctTable.setDisplayName(name);
    }

    public long getNumerOfMappedColumns() {
        return this.ctTable.getTableColumns().getCount();
    }

    public CellReference getStartCellReference() {
        if (this.startCellReference == null) {
            String ref = this.ctTable.getRef();
            String[] boundaries = ref.split(":");
            String from = boundaries[0];
            this.startCellReference = new CellReference(from);
        }
        return this.startCellReference;
    }

    public CellReference getEndCellReference() {
        if (this.endCellReference == null) {
            String ref = this.ctTable.getRef();
            String[] boundaries = ref.split(":");
            String from = boundaries[1];
            this.endCellReference = new CellReference(from);
        }
        return this.endCellReference;
    }

    public int getRowCount() {
        CellReference from = this.getStartCellReference();
        CellReference to = this.getEndCellReference();
        int rowCount = -1;
        if (from != null && to != null) {
            rowCount = to.getRow() - from.getRow();
        }
        return rowCount;
    }

    public int getHeaderRowCount() {
        return this.ctTable.isSetHeaderRowCount() ? (int)this.ctTable.getHeaderRowCount() : 1;
    }

    public int getTotalsRowCount() {
        return this.ctTable.isSetTotalsRowCount() ? (int)this.ctTable.getTotalsRowCount() : 0;
    }

    public CTTableStyleInfo getTableStyleInfo() {
        return this.ctTable.getTableStyleInfo();
    }

    public List<XSSFTableColumn> getTableColumns() {
        if (this._columns == null) {
            this._columns = new ArrayList<XSSFTableColumn>();
            for (CTTableColumn ctTbCol : this.ctTable.getTableColumns().getTableColumnArray()) {
                this._columns.add(new XSSFTableColumn(ctTbCol));
            }
        }
        return this._columns;
    }

    public XSSFTableColumn addTableColumn() {
        if (this._columns == null) {
            this._columns = new ArrayList<XSSFTableColumn>();
        }
        if (this.ctTable.getTableColumns() == null) {
            this.ctTable.addNewTableColumns();
        }
        CTTableColumn ctTbCol = this.ctTable.getTableColumns().addNewTableColumn();
        XSSFTableColumn col = new XSSFTableColumn(ctTbCol);
        this._columns.add(col);
        this.ctTable.getTableColumns().setCount((long)this._columns.size());
        return col;
    }

    private void initAutoFilter() {
        this._autoFilter = this.ctTable.isSetAutoFilter() ? new XSSFAutoFilter(this.ctTable.getAutoFilter()) : null;
    }

    public XSSFAutoFilter getAutoFilter() {
        return this._autoFilter;
    }

    public void setRef(String ref) {
        this.ctTable.setRef(ref);
    }

    public void setTotalsRowCount(int count) {
        if (count == 0) {
            if (this.ctTable.isSetTotalsRowCount()) {
                this.ctTable.unsetTotalsRowCount();
            }
        } else {
            this.ctTable.setTotalsRowCount((long)count);
        }
    }

    public void setHeaderRowCount(int count) {
        if (count != 0) {
            if (this.ctTable.isSetHeaderRowCount()) {
                this.ctTable.unsetHeaderRowCount();
            }
        } else {
            this.ctTable.setHeaderRowCount((long)count);
        }
    }

    public XSSFTableStyleInfo createTableStyleInfo() {
        CTTableStyleInfo ctInfo = this.ctTable.addNewTableStyleInfo();
        return new XSSFTableStyleInfo(ctInfo);
    }

    public void clearAutoFilter() {
        this._autoFilter = null;
        if (this.ctTable.isSetAutoFilter()) {
            this.ctTable.unsetAutoFilter();
        }
    }

    public XSSFAutoFilter createAutoFilter() {
        if (this.ctTable.isSetHeaderRowCount() && this.ctTable.getHeaderRowCount() == 0L) {
            this._autoFilter = null;
            return null;
        }
        if (!this.ctTable.isSetAutoFilter()) {
            this.ctTable.addNewAutoFilter();
            this.initAutoFilter();
        }
        return this._autoFilter;
    }

    public void setId(int id) {
        this.ctTable.setId((long)id);
    }
}

