/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xssf.usermodel;

import java.util.Iterator;
import java.util.LinkedList;
import org.zkoss.poi.ss.formula.EvaluationCell;
import org.zkoss.poi.ss.formula.EvaluationSheet;
import org.zkoss.poi.xssf.usermodel.XSSFCell;
import org.zkoss.poi.xssf.usermodel.XSSFEvaluationCell;
import org.zkoss.poi.xssf.usermodel.XSSFRow;
import org.zkoss.poi.xssf.usermodel.XSSFSheet;

final class XSSFEvaluationSheet
implements EvaluationSheet {
    private final XSSFSheet _xs;

    public XSSFEvaluationSheet(XSSFSheet sheet) {
        this._xs = sheet;
    }

    public XSSFSheet getXSSFSheet() {
        return this._xs;
    }

    @Override
    public EvaluationCell getCell(int rowIndex, int columnIndex) {
        XSSFRow row = this._xs.getRow(rowIndex);
        if (row == null) {
            return null;
        }
        XSSFCell cell = row.getCell(columnIndex);
        if (cell == null) {
            return null;
        }
        return new XSSFEvaluationCell(cell, this);
    }

    @Override
    public Iterator<EvaluationCell> nonEmptyCellsIterator(int rowStart, int rowEnd, int columnStart, int columnEnd) {
        LinkedList<EvaluationCell> cells = new LinkedList<EvaluationCell>();
        for (int i = rowStart; i < rowEnd; ++i) {
            for (int j = columnStart; j <= columnEnd; ++j) {
                EvaluationCell evaluationCell = this.getCell(i, j);
                if (evaluationCell == null || evaluationCell.getCellType() == 3) continue;
                cells.add(evaluationCell);
            }
        }
        return cells.iterator();
    }

    @Override
    public Iterator<EvaluationCell> nonEmptyCellsIterator(int columnIndex) {
        LinkedList<EvaluationCell> cells = new LinkedList<EvaluationCell>();
        for (int i = this._xs.getFirstRowNum(); i <= this._xs.getLastRowNum(); ++i) {
            EvaluationCell evaluationCell = this.getCell(i, columnIndex);
            if (evaluationCell == null || evaluationCell.getCellType() == 3) continue;
            cells.add(evaluationCell);
        }
        return cells.iterator();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._xs == null ? 0 : this._xs.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XSSFEvaluationSheet other = (XSSFEvaluationSheet)obj;
        return this._xs == other._xs;
    }

    @Override
    public boolean isHidden(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public boolean isRowHidden(int rowIndex) {
        return false;
    }

    @Override
    public boolean isFiltered() {
        return false;
    }
}

