/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xssf.usermodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCustomFilter;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCustomFilters;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFilterColumn;
import org.zkoss.poi.ss.usermodel.CustomFilter;
import org.zkoss.poi.ss.usermodel.CustomFilters;
import org.zkoss.poi.xssf.usermodel.XSSFAutoFilter;
import org.zkoss.poi.xssf.usermodel.XSSFCustomFilter;

public class XSSFCustomFilters
implements CustomFilters,
Serializable {
    private CTCustomFilters _ctFilters;
    private List<XSSFCustomFilter> _filters;

    XSSFCustomFilters(CTCustomFilters ctFilters) {
        this._ctFilters = ctFilters;
        this._filters = new ArrayList<XSSFCustomFilter>();
        if (this._ctFilters != null) {
            for (CTCustomFilter filter : this._ctFilters.getCustomFilterList()) {
                this._filters.add(new XSSFCustomFilter(filter));
            }
        }
    }

    public XSSFCustomFilters(XSSFAutoFilter.XSSFFilterColumn fc) {
        CTFilterColumn ctfc = fc.getCTFilterColumn();
        if (ctfc.isSetCustomFilters()) {
            ctfc.unsetCustomFilters();
        }
        this._ctFilters = ctfc.addNewCustomFilters();
        this._filters = new ArrayList<XSSFCustomFilter>();
    }

    @Override
    public boolean isAnd() {
        return this._ctFilters.isSetAnd() && this._ctFilters.getAnd();
    }

    @Override
    public CustomFilter getCustomFilter1() {
        return this._filters.get(0);
    }

    @Override
    public CustomFilter getCustomFilter2() {
        return this._filters.size() > 1 ? (CustomFilter)this._filters.get(1) : null;
    }

    public void setAnd(boolean and) {
        if (and) {
            this._ctFilters.setAnd(and);
        } else {
            this._ctFilters.unsetAnd();
        }
    }

    public void addCustomFilter(CustomFilter.Operator operator, String value) {
        CTCustomFilter ctFilter = this._ctFilters.addNewCustomFilter();
        XSSFCustomFilter filter = new XSSFCustomFilter(ctFilter);
        filter.setProperties(operator, value);
        this._filters.add(filter);
    }
}

