/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xssf.usermodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTArea3DChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTAreaChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBar3DChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBarChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBoolean;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBubbleChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTCatAx;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTChartSpace;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTDoughnutChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTLine3DChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTLineChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTOfPieChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTOverlap;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPageMargins;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPie3DChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPieChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPlotArea;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPrintSettings;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTRadarChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTScatterChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTStockChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTSurface3DChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTSurfaceChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTTitle;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTValAx;
import org.openxmlformats.schemas.drawingml.x2006.chart.ChartSpaceDocument;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBody;
import org.openxmlformats.schemas.officeDocument.x2006.relationships.STRelationshipId;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.zkoss.poi.POIXMLDocumentPart;
import org.zkoss.poi.openxml4j.opc.PackagePart;
import org.zkoss.poi.openxml4j.opc.PackageRelationship;
import org.zkoss.poi.ss.usermodel.Chart;
import org.zkoss.poi.ss.usermodel.ClientAnchor;
import org.zkoss.poi.ss.usermodel.charts.AxisPosition;
import org.zkoss.poi.ss.usermodel.charts.CategoryDataSerie;
import org.zkoss.poi.ss.usermodel.charts.ChartAxis;
import org.zkoss.poi.ss.usermodel.charts.ChartAxisFactory;
import org.zkoss.poi.ss.usermodel.charts.ChartData;
import org.zkoss.poi.ss.usermodel.charts.ChartTextSource;
import org.zkoss.poi.ss.usermodel.charts.ChartType;
import org.zkoss.poi.util.Internal;
import org.zkoss.poi.xssf.usermodel.XSSFGraphicFrame;
import org.zkoss.poi.xssf.usermodel.XSSFRichTextString;
import org.zkoss.poi.xssf.usermodel.charts.XSSFBar3DChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFBarChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFCategoryAxis;
import org.zkoss.poi.xssf.usermodel.charts.XSSFChartAxis;
import org.zkoss.poi.xssf.usermodel.charts.XSSFChartDataFactory;
import org.zkoss.poi.xssf.usermodel.charts.XSSFChartLegend;
import org.zkoss.poi.xssf.usermodel.charts.XSSFColumn3DChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFColumnChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFDoughnutChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFLine3DChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFLineChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFManualLayout;
import org.zkoss.poi.xssf.usermodel.charts.XSSFPie3DChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFPieChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFValueAxis;
import org.zkoss.poi.xssf.usermodel.charts.XSSFView3D;

public final class XSSFChart
extends POIXMLDocumentPart
implements Chart,
ChartAxisFactory {
    private XSSFGraphicFrame frame;
    private CTChartSpace chartSpace;
    private CTChart chart;
    List<XSSFChartAxis> axis;
    private ClientAnchor _anchor;

    protected XSSFChart() {
        this.axis = new ArrayList<XSSFChartAxis>();
        this.createChart();
    }

    protected XSSFChart(PackagePart part, PackageRelationship rel) throws IOException, XmlException {
        super(part, rel);
        this.chartSpace = ChartSpaceDocument.Factory.parse((InputStream)part.getInputStream()).getChartSpace();
        this.chart = this.chartSpace.getChart();
        this.axis = new ArrayList<XSSFChartAxis>();
    }

    private void createChart() {
        this.chartSpace = CTChartSpace.Factory.newInstance();
        this.chart = this.chartSpace.addNewChart();
        CTPlotArea plotArea = this.chart.addNewPlotArea();
        plotArea.addNewLayout();
        this.chart.addNewPlotVisOnly().setVal(true);
        CTPrintSettings printSettings = this.chartSpace.addNewPrintSettings();
        printSettings.addNewHeaderFooter();
        CTPageMargins pageMargins = printSettings.addNewPageMargins();
        pageMargins.setB(0.75);
        pageMargins.setL(0.7);
        pageMargins.setR(0.7);
        pageMargins.setT(0.75);
        pageMargins.setHeader(0.3);
        pageMargins.setFooter(0.3);
        printSettings.addNewPageSetup();
    }

    @Internal
    public CTChartSpace getCTChartSpace() {
        return this.chartSpace;
    }

    @Internal
    public CTChart getCTChart() {
        return this.chart;
    }

    @Override
    protected void commit() throws IOException {
        XmlOptions xmlOptions = new XmlOptions(DEFAULT_XML_OPTIONS);
        xmlOptions.setSaveSyntheticDocumentElement(new QName(CTChartSpace.type.getName().getNamespaceURI(), "chartSpace", "c"));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("http://schemas.openxmlformats.org/drawingml/2006/main", "a");
        map.put("http://schemas.openxmlformats.org/drawingml/2006/chart", "c");
        map.put(STRelationshipId.type.getName().getNamespaceURI(), "r");
        xmlOptions.setSaveSuggestedPrefixes(map);
        PackagePart part = this.getPackagePart();
        this.clearMemoryPackagePart(part);
        OutputStream out = part.getOutputStream();
        this.chartSpace.save(out, xmlOptions);
        out.close();
    }

    public XSSFGraphicFrame getGraphicFrame() {
        return this.frame;
    }

    protected void setGraphicFrame(XSSFGraphicFrame frame) {
        this.frame = frame;
    }

    @Override
    public XSSFChartDataFactory getChartDataFactory() {
        return XSSFChartDataFactory.getInstance();
    }

    @Override
    public XSSFChart getChartAxisFactory() {
        return this;
    }

    @Override
    public void plot(ChartData data, ChartAxis ... axis) {
        data.fillChart(this, axis);
    }

    @Override
    public XSSFValueAxis createValueAxis(AxisPosition pos) {
        long id = this.axis.size() + 1;
        XSSFValueAxis valueAxis = new XSSFValueAxis(this, id, pos);
        this.axis.add(valueAxis);
        return valueAxis;
    }

    @Override
    public XSSFCategoryAxis createCategoryAxis(AxisPosition pos) {
        long id = this.axis.size() + 1;
        XSSFCategoryAxis valueAxis = new XSSFCategoryAxis(this, id, pos);
        this.axis.add(valueAxis);
        return valueAxis;
    }

    public List<? extends XSSFChartAxis> getAxis() {
        if (this.axis.isEmpty() && this.hasAxis()) {
            this.parseAxis();
        }
        return this.axis;
    }

    @Override
    public XSSFManualLayout getManualLayout() {
        return new XSSFManualLayout(this);
    }

    @Override
    public boolean isPlotOnlyVisibleCells() {
        return this.chart.getPlotVisOnly().getVal();
    }

    @Override
    public void setPlotOnlyVisibleCells(boolean plotVisOnly) {
        this.chart.getPlotVisOnly().setVal(plotVisOnly);
    }

    @Override
    public void setTitle(String title) {
        CTTitle ctTitle = this.chart.addNewTitle();
        CTTextBody textBody = ctTitle.addNewTx().addNewRich();
        textBody.addNewBodyPr();
        textBody.addNewP().addNewR().setT(title);
        ctTitle.addNewOverlay().setVal(false);
    }

    public XSSFRichTextString getTitle() {
        if (!this.chart.isSetTitle()) {
            return null;
        }
        CTTitle title = this.chart.getTitle();
        StringBuffer text = new StringBuffer();
        XmlObject[] t = title.selectPath("declare namespace a='http://schemas.openxmlformats.org/drawingml/2006/main' .//a:t");
        for (int m = 0; m < t.length; ++m) {
            NodeList kids = t[m].getDomNode().getChildNodes();
            for (int n = 0; n < kids.getLength(); ++n) {
                if (!(kids.item(n) instanceof Text)) continue;
                text.append(kids.item(n).getNodeValue());
            }
        }
        return new XSSFRichTextString(text.toString());
    }

    public boolean hasLegend() {
        return this.chart.isSetLegend();
    }

    @Override
    public XSSFChartLegend getOrCreateLegend() {
        return new XSSFChartLegend(this);
    }

    @Override
    public void deleteLegend() {
        if (this.chart.isSetLegend()) {
            this.chart.unsetLegend();
        }
    }

    private boolean hasAxis() {
        CTPlotArea ctPlotArea = this.chart.getPlotArea();
        int totalAxisCount = ctPlotArea.sizeOfValAxArray() + ctPlotArea.sizeOfCatAxArray() + ctPlotArea.sizeOfDateAxArray() + ctPlotArea.sizeOfSerAxArray();
        return totalAxisCount > 0;
    }

    private void parseAxis() {
        this.parseValueAxis();
        this.parseCategoryAxis();
    }

    private void parseValueAxis() {
        for (CTValAx valAx : this.chart.getPlotArea().getValAxList()) {
            this.axis.add(new XSSFValueAxis(this, valAx));
        }
    }

    private void parseCategoryAxis() {
        for (CTCatAx catAx : this.chart.getPlotArea().getCatAxList()) {
            this.axis.add(new XSSFCategoryAxis(this, catAx));
        }
    }

    public String getChartTitle() {
        XSSFRichTextString rstr = this.getTitle();
        return rstr == null ? null : rstr.toString();
    }

    @Override
    public XSSFView3D getOrCreateView3D() {
        return new XSSFView3D(this);
    }

    @Override
    public void deleteView3D() {
        if (this.chart.isSetView3D()) {
            this.chart.unsetView3D();
        }
    }

    public boolean isSetView3D() {
        return this.chart.isSetView3D();
    }

    public boolean isAutoTitleDeleted() {
        CTBoolean b = this.chart.getAutoTitleDeleted();
        return b != null ? b.getVal() : false;
    }

    @Override
    public void renameSheet(String oldname, String newname) {
        switch (this.getChartType()) {
            case Pie: {
                XSSFPieChartData data = new XSSFPieChartData(this);
                this.renameSheet(data.getSeries(), oldname, newname);
                break;
            }
            case Pie3D: {
                XSSFPie3DChartData data = new XSSFPie3DChartData(this);
                this.renameSheet(data.getSeries(), oldname, newname);
                break;
            }
            case Doughnut: {
                XSSFDoughnutChartData data = new XSSFDoughnutChartData(this);
                this.renameSheet(data.getSeries(), oldname, newname);
                break;
            }
            case Bar3D: {
                XSSFBar3DChartData data = new XSSFBar3DChartData(this);
                this.renameSheet(data.getSeries(), oldname, newname);
                break;
            }
            case Column3D: {
                XSSFColumn3DChartData data = new XSSFColumn3DChartData(this);
                this.renameSheet(data.getSeries(), oldname, newname);
                break;
            }
            case Bar: {
                XSSFBarChartData data = new XSSFBarChartData(this);
                this.renameSheet(data.getSeries(), oldname, newname);
                break;
            }
            case Column: {
                XSSFColumnChartData data = new XSSFColumnChartData(this);
                this.renameSheet(data.getSeries(), oldname, newname);
                break;
            }
            case Line3D: {
                XSSFLine3DChartData data = new XSSFLine3DChartData(this);
                this.renameSheet(data.getSeries(), oldname, newname);
                break;
            }
            case Line: {
                XSSFLineChartData data = new XSSFLineChartData(this);
                this.renameSheet(data.getSeries(), oldname, newname);
                break;
            }
        }
    }

    private void renameSheet(List<? extends CategoryDataSerie> series, String oldname, String newname) {
        for (CategoryDataSerie categoryDataSerie : series) {
            ChartTextSource title = categoryDataSerie.getTitle();
            if (title != null) {
                title.renameSheet(oldname, newname);
            }
            categoryDataSerie.getCategories().renameSheet(oldname, newname);
            categoryDataSerie.getValues().renameSheet(oldname, newname);
        }
    }

    public ChartType getChartType() {
        CTPlotArea plotArea = this.chart.getPlotArea();
        CTArea3DChart[] area3ds = plotArea.getArea3DChartArray();
        if (area3ds != null && area3ds.length > 0) {
            return ChartType.Area3D;
        }
        CTAreaChart[] areas = plotArea.getAreaChartArray();
        if (areas != null && areas.length > 0) {
            return ChartType.Area;
        }
        CTBar3DChart[] bar3ds = plotArea.getBar3DChartArray();
        if (bar3ds != null && bar3ds.length > 0) {
            switch (bar3ds[0].getBarDir().getVal().intValue()) {
                case 1: {
                    return ChartType.Bar3D;
                }
            }
            return ChartType.Column3D;
        }
        CTBarChart[] bars = plotArea.getBarChartArray();
        if (bars != null && bars.length > 0) {
            switch (bars[0].getBarDir().getVal().intValue()) {
                case 1: {
                    return ChartType.Bar;
                }
            }
            return ChartType.Column;
        }
        CTBubbleChart[] bubbles = plotArea.getBubbleChartArray();
        if (bubbles != null && bubbles.length > 0) {
            return ChartType.Bubble;
        }
        CTDoughnutChart[] donuts = plotArea.getDoughnutChartArray();
        if (donuts != null && donuts.length > 0) {
            return ChartType.Doughnut;
        }
        CTLine3DChart[] line3ds = plotArea.getLine3DChartArray();
        if (line3ds != null && line3ds.length > 0) {
            return ChartType.Line3D;
        }
        CTLineChart[] lines = plotArea.getLineChartArray();
        if (lines != null && lines.length > 0) {
            return ChartType.Line;
        }
        CTOfPieChart[] ofpies = plotArea.getOfPieChartArray();
        if (ofpies != null && ofpies.length > 0) {
            return ChartType.OfPie;
        }
        CTPie3DChart[] pie3ds = plotArea.getPie3DChartArray();
        if (pie3ds != null && pie3ds.length > 0) {
            return ChartType.Pie3D;
        }
        CTPieChart[] pies = plotArea.getPieChartArray();
        if (pies != null && pies.length > 0) {
            return ChartType.Pie;
        }
        CTRadarChart[] radars = plotArea.getRadarChartArray();
        if (radars != null && radars.length > 0) {
            return ChartType.Radar;
        }
        CTScatterChart[] scatters = plotArea.getScatterChartArray();
        if (scatters != null && scatters.length > 0) {
            return ChartType.Scatter;
        }
        CTStockChart[] stocks = plotArea.getStockChartArray();
        if (stocks != null && stocks.length > 0) {
            return ChartType.Stock;
        }
        CTSurface3DChart[] surface3ds = plotArea.getSurface3DChartArray();
        if (surface3ds != null && surface3ds.length > 0) {
            return ChartType.Surface3D;
        }
        CTSurfaceChart[] surfaces = plotArea.getSurfaceChartArray();
        if (surfaces != null && surfaces.length > 0) {
            return ChartType.Surface;
        }
        return null;
    }

    @Override
    public ClientAnchor getPreferredSize() {
        return this._anchor;
    }

    @Override
    public void setClientAnchor(ClientAnchor newanchor) {
        if (this._anchor == null) {
            this._anchor = newanchor;
        } else {
            this._anchor.setCol1(newanchor.getCol1());
            this._anchor.setCol2(newanchor.getCol2());
            this._anchor.setDx1(newanchor.getDx1());
            this._anchor.setDx2(newanchor.getDx2());
            this._anchor.setDy1(newanchor.getDy1());
            this._anchor.setDy2(newanchor.getDy2());
            this._anchor.setRow1(newanchor.getRow1());
            this._anchor.setRow2(newanchor.getRow2());
        }
    }

    @Override
    public String getChartId() {
        return this.getPackageRelationship().getId();
    }

    public int getBarOverlap() {
        CTPlotArea plotArea = this.chart.getPlotArea();
        CTBarChart[] bars = plotArea.getBarChartArray();
        if (bars != null && bars.length > 0) {
            CTBarChart barChart = bars[0];
            if (barChart.isSetOverlap()) {
                return barChart.getOverlap().getVal();
            }
            switch (barChart.getGrouping().getVal().intValue()) {
                case 2: {
                    return 0;
                }
                case 3: {
                    return 0;
                }
                case 4: {
                    return 100;
                }
                case 1: {
                    return 100;
                }
            }
        }
        return 0;
    }

    public void setBarOverlap(int overlap) {
        CTPlotArea plotArea = this.chart.getPlotArea();
        CTBarChart[] bars = plotArea.getBarChartArray();
        if (bars != null && bars.length > 0) {
            CTBarChart barChart = bars[0];
            CTOverlap ov = !barChart.isSetOverlap() ? barChart.addNewOverlap() : barChart.getOverlap();
            ov.setVal((byte)overlap);
        }
    }
}

