/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xslf.model.geom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openxmlformats.schemas.drawingml.x2006.main.CTCustomGeometry2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGeomGuide;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGeomGuideList;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGeomRect;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2DList;
import org.zkoss.poi.xslf.model.geom.AdjustValue;
import org.zkoss.poi.xslf.model.geom.ClosePathCommand;
import org.zkoss.poi.xslf.model.geom.Guide;
import org.zkoss.poi.xslf.model.geom.LineToCommand;
import org.zkoss.poi.xslf.model.geom.MoveToCommand;
import org.zkoss.poi.xslf.model.geom.Path;

public class CustomGeometry
implements Iterable<Path> {
    List<Guide> adjusts = new ArrayList<Guide>();
    List<Guide> guides = new ArrayList<Guide>();
    List<Path> paths = new ArrayList<Path>();
    Path textBounds;

    public CustomGeometry(CTCustomGeometry2D geom) {
        CTPath2DList pathLst;
        CTGeomGuideList gdLst;
        CTGeomGuideList avLst = geom.getAvLst();
        if (avLst != null) {
            for (CTGeomGuide gd : avLst.getGdList()) {
                this.adjusts.add(new AdjustValue(gd));
            }
        }
        if ((gdLst = geom.getGdLst()) != null) {
            for (CTGeomGuide gd : gdLst.getGdList()) {
                this.guides.add(new Guide(gd));
            }
        }
        if ((pathLst = geom.getPathLst()) != null) {
            for (CTPath2D spPath : pathLst.getPathList()) {
                this.paths.add(new Path(spPath));
            }
        }
        if (geom.isSetRect()) {
            CTGeomRect rect = geom.getRect();
            this.textBounds = new Path();
            this.textBounds.addCommand(new MoveToCommand(rect.getL().toString(), rect.getT().toString()));
            this.textBounds.addCommand(new LineToCommand(rect.getR().toString(), rect.getT().toString()));
            this.textBounds.addCommand(new LineToCommand(rect.getR().toString(), rect.getB().toString()));
            this.textBounds.addCommand(new LineToCommand(rect.getL().toString(), rect.getB().toString()));
            this.textBounds.addCommand(new ClosePathCommand());
        }
    }

    @Override
    public Iterator<Path> iterator() {
        return this.paths.iterator();
    }

    public Path getTextBounds() {
        return this.textBounds;
    }
}

