/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.util;

public class RefUtil {
    public static final long PEAK_RESIDENT_BYTES = 0x30000000000000L;
    private static final long NO_COL_REF = 0x10000000000000L;
    private static final long IS_COL_RELATIVE = 0x400000000000L;
    private static final long NO_ROW_REF = 0x20000000000000L;
    private static final long IS_ROW_RELATIVE = 0x800000000000L;
    private static final int MAX_COL_LIMIT = 16383;
    private static final int MAX_ROW_LIMIT = 1048575;

    public static boolean isAbsCol(long refHash) {
        return RefUtil.hasColRef(refHash) && RefUtil._isAbsCol(refHash);
    }

    private static boolean _isAbsCol(long refHash) {
        return (refHash & 0x400000000000L) == 0L;
    }

    public static boolean hasColRef(long refHash) {
        return (refHash & 0x10000000000000L) == 0L;
    }

    public static boolean isAbsRow(long refHash) {
        return RefUtil.hasRowRef(refHash) && RefUtil._isAbsRow(refHash);
    }

    private static boolean _isAbsRow(long refHash) {
        return (refHash & 0x800000000000L) == 0L;
    }

    public static boolean hasRowRef(long refHash) {
        return (refHash & 0x20000000000000L) == 0L;
    }

    public static long getColIndex(long refHash) {
        return refHash >> 32 & 0x3FFFL;
    }

    public static long getRowIndex(long refHash) {
        return refHash & 0xFFFFFL;
    }

    public static long toColHash(long col, boolean var1) {
        return var1 ? col << 32 | 0x20400000000000L : col << 32 | 0x20000000000000L;
    }

    public static long toRowHash(long result, boolean var1) {
        return var1 ? result | 0x10800000000000L : result | 0x10000000000000L;
    }

    public static long toRefHash(long row, boolean relativeRow, long col, boolean relativeCol) {
        long hash = row | col << 32;
        if (relativeRow) {
            hash |= 0x800000000000L;
        }
        if (relativeCol) {
            hash |= 0x400000000000L;
        }
        return hash;
    }

    public static String decodeRef(long refHash) {
        StringBuilder sb = new StringBuilder();
        if (RefUtil.hasColRef(refHash)) {
            if (RefUtil._isAbsCol(refHash)) {
                sb.append('$');
            }
            sb.append(RefUtil.numToAbc(RefUtil.getColIndex(refHash)));
        }
        if (RefUtil.hasRowRef(refHash)) {
            if (RefUtil._isAbsRow(refHash)) {
                sb.append('$');
            }
            sb.append(RefUtil.getRowIndex(refHash) + 1L);
        }
        return sb.toString();
    }

    private static String numToAbc(long index) {
        StringBuilder sb = new StringBuilder();
        if (index < 0L) {
            return "(*" + index + ")";
        }
        ++index;
        while (--index >= 0L) {
            long j = index % 26L + 65L;
            sb.insert(0, (char)j);
            index /= 26L;
        }
        return sb.toString();
    }

    public static long encodeRef(String ref) {
        ref = ref.toUpperCase();
        int[] codePoints = ref.codePoints().toArray();
        int startIndex = 0;
        int endIndex = codePoints.length;
        boolean relativeCol = true;
        if (codePoints[0] == 36) {
            relativeCol = false;
            if (++startIndex >= endIndex) {
                return Long.MIN_VALUE;
            }
        }
        long colIndex = 0L;
        int codePoint = codePoints[startIndex];
        while (codePoint >= 65 && codePoint <= 90) {
            if ((colIndex = colIndex * 26L + (long)codePoint - 64L) > 16384L) {
                return Long.MIN_VALUE;
            }
            if (++startIndex >= endIndex) {
                long result = colIndex - 1L;
                result = result << 32 | 0x20000000000000L;
                if (relativeCol) {
                    result |= 0x400000000000L;
                }
                return result;
            }
            codePoint = codePoints[startIndex];
        }
        boolean relativeRow = true;
        if (--colIndex < 0L) {
            relativeRow = relativeCol;
            relativeCol = false;
        } else if (codePoints[startIndex] == 36) {
            relativeRow = false;
            if (++startIndex >= endIndex) {
                return Long.MIN_VALUE;
            }
        }
        long rowIndex = 0L;
        codePoint = codePoints[startIndex];
        while (codePoint >= 48 && codePoint <= 57) {
            if ((rowIndex = rowIndex * 10L + (long)codePoint - 48L) > 0x100000L) {
                return Long.MIN_VALUE;
            }
            if (++startIndex >= endIndex) {
                if (rowIndex < 1L) {
                    return Long.MIN_VALUE;
                }
                long result = rowIndex - 1L;
                if (colIndex >= 0L) {
                    result |= colIndex << 32;
                    if (relativeCol) {
                        result |= 0x400000000000L;
                    }
                } else {
                    result |= 0x10000000000000L;
                }
                if (relativeRow) {
                    result |= 0x800000000000L;
                }
                return result;
            }
            codePoint = codePoints[startIndex];
        }
        return Long.MIN_VALUE;
    }
}

