/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.formula.token;

import java.util.LinkedList;
import java.util.List;
import org.zkoss.poi.ss.formula.EvaluationName;
import org.zkoss.poi.ss.formula.FormulaParseException;
import org.zkoss.poi.ss.formula.FormulaParsingWorkbook;
import org.zkoss.poi.ss.formula.atp.AnalysisToolPak;
import org.zkoss.poi.ss.formula.function.FunctionMetadata;
import org.zkoss.poi.ss.formula.function.FunctionMetadataRegistry;
import org.zkoss.poi.ss.formula.ptg.AbstractFunctionPtg;
import org.zkoss.poi.ss.formula.ptg.AddPtg;
import org.zkoss.poi.ss.formula.ptg.AreaPtg;
import org.zkoss.poi.ss.formula.ptg.ArrayPtg;
import org.zkoss.poi.ss.formula.ptg.AttrPtg;
import org.zkoss.poi.ss.formula.ptg.BoolPtg;
import org.zkoss.poi.ss.formula.ptg.ConcatPtg;
import org.zkoss.poi.ss.formula.ptg.DeferredNamePtg;
import org.zkoss.poi.ss.formula.ptg.DividePtg;
import org.zkoss.poi.ss.formula.ptg.EqualPtg;
import org.zkoss.poi.ss.formula.ptg.ErrPtg;
import org.zkoss.poi.ss.formula.ptg.FuncPtg;
import org.zkoss.poi.ss.formula.ptg.FuncVarPtg;
import org.zkoss.poi.ss.formula.ptg.GreaterEqualPtg;
import org.zkoss.poi.ss.formula.ptg.GreaterThanPtg;
import org.zkoss.poi.ss.formula.ptg.IntersectionPtg;
import org.zkoss.poi.ss.formula.ptg.LessEqualPtg;
import org.zkoss.poi.ss.formula.ptg.LessThanPtg;
import org.zkoss.poi.ss.formula.ptg.MissingArgPtg;
import org.zkoss.poi.ss.formula.ptg.MultiplyPtg;
import org.zkoss.poi.ss.formula.ptg.NotEqualPtg;
import org.zkoss.poi.ss.formula.ptg.NumberPtg;
import org.zkoss.poi.ss.formula.ptg.ParenthesisPtg;
import org.zkoss.poi.ss.formula.ptg.PercentPtg;
import org.zkoss.poi.ss.formula.ptg.PowerPtg;
import org.zkoss.poi.ss.formula.ptg.Ptg;
import org.zkoss.poi.ss.formula.ptg.RangePtg;
import org.zkoss.poi.ss.formula.ptg.RefPtg;
import org.zkoss.poi.ss.formula.ptg.StringPtg;
import org.zkoss.poi.ss.formula.ptg.SubtractPtg;
import org.zkoss.poi.ss.formula.ptg.UnaryMinusPtg;
import org.zkoss.poi.ss.formula.ptg.UnaryPlusPtg;
import org.zkoss.poi.ss.formula.ptg.UnionPtg;
import org.zkoss.poi.ss.formula.token.AddNode;
import org.zkoss.poi.ss.formula.token.AndNode;
import org.zkoss.poi.ss.formula.token.AreaRefNode;
import org.zkoss.poi.ss.formula.token.ArrayColumnsNode;
import org.zkoss.poi.ss.formula.token.BoolNode;
import org.zkoss.poi.ss.formula.token.ColonNode;
import org.zkoss.poi.ss.formula.token.CommaNode;
import org.zkoss.poi.ss.formula.token.DefaultTokenNode;
import org.zkoss.poi.ss.formula.token.DivNode;
import org.zkoss.poi.ss.formula.token.DoubleNode;
import org.zkoss.poi.ss.formula.token.EmptyNode;
import org.zkoss.poi.ss.formula.token.EqualNode;
import org.zkoss.poi.ss.formula.token.ErrorNode;
import org.zkoss.poi.ss.formula.token.ErrorRefNode;
import org.zkoss.poi.ss.formula.token.ExpNode;
import org.zkoss.poi.ss.formula.token.FormulaTokenNode;
import org.zkoss.poi.ss.formula.token.FunctionNode;
import org.zkoss.poi.ss.formula.token.GreatNode;
import org.zkoss.poi.ss.formula.token.GreaterThanEqualNode;
import org.zkoss.poi.ss.formula.token.IntegerNode;
import org.zkoss.poi.ss.formula.token.LessNode;
import org.zkoss.poi.ss.formula.token.LessThanEqualNode;
import org.zkoss.poi.ss.formula.token.MinusNode;
import org.zkoss.poi.ss.formula.token.MultiNode;
import org.zkoss.poi.ss.formula.token.NameNode;
import org.zkoss.poi.ss.formula.token.NameRefNode;
import org.zkoss.poi.ss.formula.token.NotEqualNode;
import org.zkoss.poi.ss.formula.token.NumberNode;
import org.zkoss.poi.ss.formula.token.PercentNode;
import org.zkoss.poi.ss.formula.token.PlusNode;
import org.zkoss.poi.ss.formula.token.RefNode;
import org.zkoss.poi.ss.formula.token.SpaceNode;
import org.zkoss.poi.ss.formula.token.StringNode;
import org.zkoss.poi.ss.formula.token.SubtractNode;
import org.zkoss.poi.ss.formula.token.TableRefNode;
import org.zkoss.poi.ss.formula.token.TokenNodeVisitor;
import org.zkoss.poi.ss.formula.token.UnionNode;
import org.zkoss.poi.ss.usermodel.ErrorConstants;
import org.zkoss.poi.ss.util.RefUtil;

public class TokenToPtgVisitor
implements TokenNodeVisitor<List<Ptg>> {
    private final LinkedList<Ptg> _stack = new LinkedList();
    private final FormulaParsingWorkbook _book;
    private final int _sheetIndex;

    public TokenToPtgVisitor(FormulaParsingWorkbook book, int sheetIndex) {
        this._book = book;
        this._sheetIndex = sheetIndex;
    }

    @Override
    public List<Ptg> visitAdd(AddNode node) {
        node.visitChildren(this);
        this._stack.add(AddPtg.instance);
        return this._stack;
    }

    @Override
    public List<Ptg> visitAnd(AndNode node) {
        node.visitChildren(this);
        this._stack.add(ConcatPtg.instance);
        return this._stack;
    }

    @Override
    public List<Ptg> visitAreaRef(AreaRefNode node) {
        long tl = node.getTopLeft();
        long br = node.getBottomRight();
        this._stack.add(new AreaPtg(this.getRowIndex(tl), this.getRowIndex(br), this.getColIndex(tl), this.getColIndex(br), this.isRowRelative(tl), this.isRowRelative(br), this.isColRelative(tl), this.isColRelative(br)));
        return this._stack;
    }

    @Override
    public List<Ptg> visitArrayColumns(ArrayColumnsNode node) {
        int rowCount = node.getRowCount();
        int colCount = node.getColCount();
        FormulaTokenNode[][] children = node.getChildren();
        Object[][] newChildren = new Object[rowCount][colCount];
        for (int r = 0; r < rowCount; ++r) {
            for (int c = 0; c < colCount; ++c) {
                FormulaTokenNode child = children[r][c];
                if (child == null) {
                    throw new FormulaParseException("Array item cannot be null");
                }
                if (child instanceof NumberNode) {
                    newChildren[r][c] = ((Number)((NumberNode)child).getValue()).doubleValue();
                    continue;
                }
                if (child instanceof DefaultTokenNode) {
                    newChildren[r][c] = ((DefaultTokenNode)child).getValue();
                    continue;
                }
                if (child instanceof ErrorNode) {
                    newChildren[r][c] = ErrorConstants.getText(((ErrorNode)child).getErrorCode());
                    continue;
                }
                throw new IllegalArgumentException("Unexpected constant class (" + child.getClass().getName() + ")");
            }
        }
        this._stack.add(new ArrayPtg(newChildren));
        return this._stack;
    }

    @Override
    public List<Ptg> visitBoolean(BoolNode node) {
        this._stack.add(BoolPtg.valueOf(node.getValue()));
        return this._stack;
    }

    @Override
    public List<Ptg> visitColon(ColonNode node) {
        node.visitChildren(this);
        this._stack.add(RangePtg.instance);
        return this._stack;
    }

    @Override
    public List<Ptg> visitComma(CommaNode node) {
        node.visitChildren(this);
        this._stack.add(UnionPtg.instance);
        return this._stack;
    }

    @Override
    public List<Ptg> visitDiv(DivNode node) {
        node.visitChildren(this);
        this._stack.add(DividePtg.instance);
        return this._stack;
    }

    @Override
    public List<Ptg> visitEmpty(EmptyNode node) {
        this._stack.add(MissingArgPtg.instance);
        return this._stack;
    }

    @Override
    public List<Ptg> visitEqual(EqualNode node) {
        node.visitChildren(this);
        this._stack.add(EqualPtg.instance);
        return this._stack;
    }

    @Override
    public List<Ptg> visitError(ErrorNode node) {
        this._stack.add(this._toErrPtg(node));
        return this._stack;
    }

    @Override
    public List<Ptg> visitErrorRef(ErrorRefNode node) {
        return this._stack;
    }

    @Override
    public List<Ptg> visitExp(ExpNode node) {
        node.visitChildren(this);
        this._stack.add(PowerPtg.instance);
        return this._stack;
    }

    @Override
    public List<Ptg> visitFunction(FunctionNode node) {
        String name = ((FormulaTokenNode)node.getValue()).toString();
        Ptg namePtg = this.createNamePtg(name);
        FunctionMetadata fm = FunctionMetadataRegistry.getFunctionByName(name.toUpperCase());
        int numArgs = node.getChildrenLength();
        if (fm == null) {
            if (namePtg == null) {
                throw new IllegalStateException("NamePtg must be supplied for external functions");
            }
            this._stack.add(namePtg);
            node.visitChildren(this);
            this._stack.add(FuncVarPtg.create(name, numArgs + 1));
            return this._stack;
        }
        if (namePtg != null) {
            throw new IllegalStateException("NamePtg no applicable to internal functions");
        }
        boolean isVarArgs = !fm.hasFixedArgsLength();
        int funcIdx = fm.getIndex();
        if (funcIdx == 4 && numArgs == 1) {
            node.visitChildren(this);
            this._stack.add(AttrPtg.getSumSingle());
            return this._stack;
        }
        this.validateNumArgs(numArgs, fm);
        List<List<Ptg>> ptgs = node.visitChildren(this);
        if (funcIdx == 228 && ptgs.size() != 0) {
            for (Ptg ptg : ptgs.get(0)) {
                if (!(ptg instanceof MultiplyPtg)) continue;
                ((MultiplyPtg)ptg).setOperator(true);
            }
        }
        if (isVarArgs) {
            this._stack.add(FuncVarPtg.create(name, numArgs));
        } else {
            this._stack.add(FuncPtg.create(funcIdx));
        }
        return this._stack;
    }

    private Ptg createNamePtg(String name) {
        Ptg nameToken = null;
        if (!AbstractFunctionPtg.isBuiltInFunctionName(name)) {
            EvaluationName hName;
            if (AnalysisToolPak.isATPFunction(name.toUpperCase())) {
                name = name.toUpperCase();
            }
            if ((hName = this._book.getName(name, this._sheetIndex)) == null) {
                nameToken = this._book.getNameXPtg(name);
                if (nameToken == null) {
                    nameToken = this.createPtgForNonExistedName(name);
                }
            } else {
                nameToken = hName.createPtg();
            }
        }
        return nameToken;
    }

    private Ptg createPtgForNonExistedName(String nonExistedName) {
        if (this._book.isAllowedDeferredNamePtg()) {
            return new DeferredNamePtg(nonExistedName);
        }
        return this._book.getName(nonExistedName, null).createPtg();
    }

    private void validateNumArgs(int numArgs, FunctionMetadata fm) {
        if (numArgs < fm.getMinParams()) {
            String msg = "Too few arguments to function '" + fm.getName() + "'. ";
            msg = fm.hasFixedArgsLength() ? msg + "Expected " + fm.getMinParams() : msg + "At least " + fm.getMinParams() + " were expected";
            msg = msg + " but got " + numArgs + ".";
            throw new FormulaParseException(msg);
        }
        int maxArgs = fm.hasUnlimitedVarags() ? (this._book != null ? this._book.getSpreadsheetVersion().getMaxFunctionArgs() : fm.getMaxParams()) : fm.getMaxParams();
        if (numArgs > maxArgs) {
            String msg = "Too many arguments to function '" + fm.getName() + "'. ";
            msg = fm.hasFixedArgsLength() ? msg + "Expected " + maxArgs : msg + "At most " + maxArgs + " were expected";
            msg = msg + " but got " + numArgs + ".";
            throw new FormulaParseException(msg);
        }
    }

    @Override
    public List<Ptg> visitGreat(GreatNode node) {
        node.visitChildren(this);
        this._stack.add(GreaterThanPtg.instance);
        return this._stack;
    }

    @Override
    public List<Ptg> visitGreaterThanEqual(GreaterThanEqualNode node) {
        node.visitChildren(this);
        this._stack.add(GreaterEqualPtg.instance);
        return this._stack;
    }

    @Override
    public List<Ptg> visitLess(LessNode node) {
        node.visitChildren(this);
        this._stack.add(LessThanPtg.instance);
        return this._stack;
    }

    @Override
    public List<Ptg> visitLessThanEqual(LessThanEqualNode node) {
        node.visitChildren(this);
        this._stack.add(LessEqualPtg.instance);
        return this._stack;
    }

    @Override
    public List<Ptg> visitMinus(MinusNode node) {
        node.visitChildren(this);
        this._stack.add(UnaryMinusPtg.instance);
        return this._stack;
    }

    @Override
    public List<Ptg> visitMulti(MultiNode node) {
        node.visitChildren(this);
        this._stack.add(new MultiplyPtg());
        return this._stack;
    }

    @Override
    public List<Ptg> visitName(NameNode node) {
        this._stack.add(this.createNamePtg(node.getValue()));
        return this._stack;
    }

    @Override
    public List<Ptg> visitNameRef(NameRefNode node) {
        this._stack.add(this.createNamePtg(node.getValue()));
        return this._stack;
    }

    @Override
    public List<Ptg> visitNotEqual(NotEqualNode node) {
        node.visitChildren(this);
        this._stack.add(NotEqualPtg.instance);
        return this._stack;
    }

    @Override
    public <T extends Number> List<Ptg> visitNumber(NumberNode<T> node) {
        NumberPtg ptg = null;
        if (node instanceof IntegerNode) {
            ptg = new NumberPtg(((IntegerNode)node).getValue().intValue());
        } else if (node instanceof DoubleNode) {
            ptg = new NumberPtg(((DoubleNode)node).getValue());
        }
        this._stack.add(ptg);
        return this._stack;
    }

    @Override
    public List<Ptg> visitPercent(PercentNode node) {
        node.visitChildren(this);
        this._stack.add(PercentPtg.instance);
        return this._stack;
    }

    @Override
    public List<Ptg> visitPlus(PlusNode node) {
        node.visitChildren(this);
        this._stack.add(UnaryPlusPtg.instance);
        return this._stack;
    }

    @Override
    public List<Ptg> visitRef(RefNode node) {
        long hash = node.getHash();
        this._stack.add(new RefPtg(this.getRowIndex(hash), this.getColIndex(hash), this.isRowRelative(hash), this.isColRelative(hash)));
        return this._stack;
    }

    @Override
    public List<Ptg> visitSpace(SpaceNode node) {
        node.visitChildren(this);
        this._stack.add(IntersectionPtg.instance);
        return this._stack;
    }

    @Override
    public List<Ptg> visitString(StringNode node) {
        this._stack.add(new StringPtg((String)node.getValue()));
        return this._stack;
    }

    @Override
    public List<Ptg> visitSubtract(SubtractNode node) {
        node.visitChildren(this);
        this._stack.add(SubtractPtg.instance);
        return this._stack;
    }

    @Override
    public List<Ptg> visitTableRef(TableRefNode node) {
        String name = node.getName();
        if (name != null && this._book.getTableName(name) != null) {
            Object[] specifier = new Object[]{node.getItem()};
            this._stack.add(this._book.createTablePtg(name, specifier, this._sheetIndex, 0, 0));
            return this._stack;
        }
        throw new FormulaParseException("Invalid table name");
    }

    @Override
    public List<Ptg> visitUnion(UnionNode node) {
        node.visitChildren(this);
        this._stack.add(ParenthesisPtg.instance);
        return this._stack;
    }

    private ErrPtg _toErrPtg(ErrorNode node) {
        return ErrPtg.valueOf(node.getErrorCode());
    }

    private int getColIndex(long refHash) {
        return (int)RefUtil.getColIndex(refHash) + 49152;
    }

    private int getRowIndex(long refHash) {
        return (int)RefUtil.getRowIndex(refHash);
    }

    private boolean isColRelative(long refHash) {
        return !RefUtil.isAbsCol(refHash);
    }

    private boolean isRowRelative(long refHash) {
        return !RefUtil.isAbsRow(refHash);
    }
}

