/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.formula.token;

import java.util.Collections;
import java.util.List;
import org.zkoss.poi.ss.formula.FormulaParseException;
import org.zkoss.poi.ss.formula.FormulaTokenParser;
import org.zkoss.poi.ss.formula.token.ExternalRefNode;
import org.zkoss.poi.ss.formula.token.FormulaTokenNode;
import org.zkoss.poi.ss.formula.token.NodeId;
import org.zkoss.poi.ss.formula.token.TokenNodeVisitor;

public class TableRefNode
implements FormulaTokenNode {
    private int flag = 0;
    private final String name;
    private String column;
    private String item;
    private final ExternalRefNode externalRef;

    public TableRefNode(String name, ExternalRefNode externalRef) {
        this.name = name;
        this.externalRef = externalRef;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public void setItem(String item) {
        this.item = item;
    }

    public String getName() {
        return this.name;
    }

    public String getColumn() {
        return this.column;
    }

    public String getItem() {
        return this.item;
    }

    @Override
    public NodeId getNodeId() {
        return NodeId.TableRefNode;
    }

    @Override
    public int getType() {
        return 32;
    }

    @Override
    public boolean hasOperands() {
        return true;
    }

    @Override
    public boolean isOp() {
        return false;
    }

    @Override
    public boolean add(FormulaTokenNode child) {
        throw new FormulaParseException("Table reference should not have child.");
    }

    @Override
    public FormulaTokenNode normalize(FormulaTokenParser parser) {
        return this;
    }

    @Override
    public <R> R accept(TokenNodeVisitor<R> visitor) {
        return visitor.visitTableRef(this);
    }

    @Override
    public <R> List<R> visitChildren(TokenNodeVisitor<R> visitor) {
        return Collections.emptyList();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.externalRef != null) {
            sb.append(this.externalRef);
            sb.append('!');
        }
        sb.append(this.name);
        sb.append('[');
        boolean hasItem = false;
        if (this.item != null && this.item.length() != 0) {
            sb.append(this.item);
            hasItem = true;
        }
        if (this.column != null && this.column.length() != 0) {
            if (hasItem) {
                sb.append(',');
            }
            sb.append(this.column);
        }
        sb.append(']');
        return sb.toString();
    }

    public boolean isValid(int flag) {
        this.flag = this.flag & 0xFF | flag & 0xFF;
        switch (this.flag) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 12: 
            case 16: {
                return true;
            }
        }
        return false;
    }
}

