/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.formula.token;

import java.util.Collections;
import java.util.List;
import org.zkoss.poi.ss.formula.FormulaParseException;
import org.zkoss.poi.ss.formula.FormulaTokenParser;
import org.zkoss.poi.ss.formula.token.DefaultTokenNode;
import org.zkoss.poi.ss.formula.token.FormulaTokenNode;
import org.zkoss.poi.ss.formula.token.NodeId;
import org.zkoss.poi.ss.formula.token.TokenNodeVisitor;

public class StringNode
extends DefaultTokenNode<String> {
    public StringNode(String value) {
        super(value);
    }

    @Override
    public NodeId getNodeId() {
        return NodeId.StringNode;
    }

    @Override
    public int getType() {
        return 64;
    }

    @Override
    public boolean hasOperands() {
        return true;
    }

    @Override
    public boolean add(FormulaTokenNode child) {
        throw new FormulaParseException("String should not have child.");
    }

    @Override
    public FormulaTokenNode normalize(FormulaTokenParser parser) {
        return this;
    }

    @Override
    public <R> R accept(TokenNodeVisitor<R> visitor) {
        return visitor.visitString(this);
    }

    @Override
    public <R> List<R> visitChildren(TokenNodeVisitor<R> visitor) {
        return Collections.emptyList();
    }

    public String toString() {
        return '\"' + ((String)this.value).replaceAll("\"", "\"\"") + '\"';
    }
}

