/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.formula.token;

import org.zkoss.poi.ss.formula.FormulaParseException;
import org.zkoss.poi.ss.formula.FormulaTokenParser;
import org.zkoss.poi.ss.formula.token.FormulaTokenNode;
import org.zkoss.poi.ss.formula.token.MinusNode;
import org.zkoss.poi.ss.formula.token.NodeId;
import org.zkoss.poi.ss.formula.token.PercentNode;
import org.zkoss.poi.ss.formula.token.PlusNode;
import org.zkoss.poi.ss.formula.token.UnionNode;

public abstract class SingleChildNode
implements FormulaTokenNode {
    protected FormulaTokenNode child;

    public static SingleChildNode newInstance(NodeId nodeId) {
        switch (nodeId) {
            case AddNode: 
            case PlusNode: {
                return new PlusNode();
            }
            case SubtractNode: 
            case MinusNode: {
                return new MinusNode();
            }
            case MultiNode: 
            case PercentNode: {
                return new PercentNode();
            }
            case DivNode: 
            case UnionNode: {
                return new UnionNode();
            }
        }
        throw new FormulaParseException("Invalid formula token for unary operator");
    }

    public FormulaTokenNode getChild() {
        return this.child;
    }

    public void setChild(FormulaTokenNode child) {
        this.child = child;
    }

    @Override
    public int getType() {
        return 64;
    }

    @Override
    public boolean hasOperands() {
        return this.child != null;
    }

    @Override
    public boolean isOp() {
        return false;
    }

    @Override
    public boolean add(FormulaTokenNode child) {
        this.child = child;
        return true;
    }

    @Override
    public FormulaTokenNode normalize(FormulaTokenParser parser) {
        this.child = this.child.normalize(parser);
        return this;
    }
}

