/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.formula.token;

import java.util.Collections;
import java.util.List;
import org.zkoss.poi.ss.formula.FormulaParseException;
import org.zkoss.poi.ss.formula.FormulaTokenParser;
import org.zkoss.poi.ss.formula.token.DefaultTokenNode;
import org.zkoss.poi.ss.formula.token.FormulaTokenNode;
import org.zkoss.poi.ss.formula.token.TokenNodeVisitor;

public abstract class NumberNode<T extends Number>
extends DefaultTokenNode<Number> {
    NumberNode(T value) {
        super(value);
    }

    public abstract boolean toggleNegative();

    @Override
    public int getType() {
        return 64;
    }

    @Override
    public boolean hasOperands() {
        return true;
    }

    @Override
    public boolean add(FormulaTokenNode child) {
        throw new FormulaParseException("Unsupported: Number should not have child");
    }

    @Override
    public FormulaTokenNode normalize(FormulaTokenParser parser) {
        return this;
    }

    @Override
    public <R> R accept(TokenNodeVisitor<R> visitor) {
        return visitor.visitNumber(this);
    }

    @Override
    public <R> List<R> visitChildren(TokenNodeVisitor<R> visitor) {
        return Collections.emptyList();
    }

    public String toString() {
        return ((Number)this.value).toString();
    }
}

