/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.formula.token;

import java.util.Collections;
import java.util.List;
import org.zkoss.poi.ss.formula.FormulaParseException;
import org.zkoss.poi.ss.formula.FormulaTokenParser;
import org.zkoss.poi.ss.formula.token.BoolNode;
import org.zkoss.poi.ss.formula.token.ExternalRefNode;
import org.zkoss.poi.ss.formula.token.FormulaTokenNode;
import org.zkoss.poi.ss.formula.token.IntegerNode;
import org.zkoss.poi.ss.formula.token.NameRefNode;
import org.zkoss.poi.ss.formula.token.NodeId;
import org.zkoss.poi.ss.formula.token.RefNode;
import org.zkoss.poi.ss.formula.token.TokenNodeVisitor;
import org.zkoss.poi.ss.util.NumberUtil;
import org.zkoss.poi.ss.util.RefUtil;

public class NameNode
implements FormulaTokenNode {
    private final int startIndex;
    private final String value;
    private final boolean stringOnly;
    private final boolean singleQuote;

    public NameNode(int startIndex, String value) {
        this(startIndex, value, false, false);
    }

    public NameNode(int startIndex, String value, boolean stringOnly, boolean singleQuote) {
        this.startIndex = startIndex;
        this.value = value;
        this.stringOnly = stringOnly;
        this.singleQuote = singleQuote;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public String getValue() {
        return this.value;
    }

    public long toRefHash() {
        return this.stringOnly ? Long.MIN_VALUE : RefUtil.encodeRef(this.value);
    }

    public boolean isSingleQuote() {
        return this.singleQuote;
    }

    public boolean isSpecial() {
        return !this.stringOnly || this.singleQuote;
    }

    @Override
    public NodeId getNodeId() {
        return NodeId.NameNode;
    }

    @Override
    public int getType() {
        return 32;
    }

    @Override
    public boolean hasOperands() {
        return true;
    }

    @Override
    public boolean isOp() {
        return false;
    }

    @Override
    public boolean add(FormulaTokenNode child) {
        throw new FormulaParseException("Simple operand should not have child");
    }

    @Override
    public FormulaTokenNode normalize(FormulaTokenParser parser) {
        return this.normalize(parser, null);
    }

    public FormulaTokenNode normalize(FormulaTokenParser parser, ExternalRefNode externalRef) {
        return this.stringOnly ? this._normalizeString(externalRef) : this._normalizeName(parser, externalRef);
    }

    private FormulaTokenNode _normalizeName(FormulaTokenParser parser, ExternalRefNode externalRef) {
        if (!parser.isA1Notation()) {
            throw new FormulaParseException("Not implement yet!");
        }
        long hash = RefUtil.encodeRef(this.value);
        if (hash != Long.MIN_VALUE && (hash & 0x30000000000000L) == 0L) {
            return new RefNode(hash, externalRef);
        }
        if (this.value.toUpperCase().equals("TRUE")) {
            return new BoolNode(true);
        }
        if (this.value.toUpperCase().equals("FALSE")) {
            return new BoolNode(false);
        }
        if (externalRef == null && this._validateName(parser)) {
            return null;
        }
        return new NameRefNode(this.value, externalRef, this.singleQuote);
    }

    private FormulaTokenNode _normalizeString(ExternalRefNode externalRef) {
        if (this._isDigit(this.value.codePointAt(0))) {
            throw new FormulaParseException("Invalid name: " + this.value);
        }
        boolean hasAnySymbol = this.value.codePoints().anyMatch(this::_isSymbol);
        if (hasAnySymbol) {
            throw new FormulaParseException("Invalid name: " + this.value);
        }
        return new NameRefNode(this.value, externalRef, this.singleQuote);
    }

    private boolean _validateName(FormulaTokenParser parser) {
        char[] chars = parser.getChars();
        if (this._isDigit(chars[this.startIndex])) {
            throw new FormulaParseException("Invalid name: " + this.value);
        }
        for (int i = this.value.length() - 1; i > this.startIndex; --i) {
            if (!this._isSymbol(chars[i])) continue;
            throw new FormulaParseException("Invalid name: " + this.value);
        }
        return false;
    }

    private boolean _isDigit(int character) {
        if (character >= 48 && character <= 57) {
            return true;
        }
        return this._isSymbol(character);
    }

    private boolean _isSymbol(int character) {
        switch (character) {
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 123: 
            case 124: 
            case 125: 
            case 126: {
                return true;
            }
        }
        return false;
    }

    @Override
    public <R> R accept(TokenNodeVisitor<R> visitor) {
        return visitor.visitName(this);
    }

    @Override
    public <R> List<R> visitChildren(TokenNodeVisitor<R> visitor) {
        return Collections.emptyList();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.singleQuote) {
            sb.append('\'');
            sb.append(this.value.replaceAll("'", "''"));
            sb.append('\'');
        } else {
            sb.append(this.value);
        }
        return sb.toString();
    }

    public IntegerNode toIntegerNode() {
        Integer i = null;
        if ((this.startIndex == 0 || !this.singleQuote) && this.stringOnly && this.value != null) {
            i = NumberUtil.tryParseInt(this.value);
        }
        return i != null ? new IntegerNode(i) : null;
    }
}

