/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.formula.token;

import java.util.ArrayList;
import java.util.List;
import org.zkoss.poi.ss.formula.FormulaParseException;
import org.zkoss.poi.ss.formula.FormulaTokenParser;
import org.zkoss.poi.ss.formula.function.FunctionInfo;
import org.zkoss.poi.ss.formula.function.FunctionMetaInfo;
import org.zkoss.poi.ss.formula.token.ArrayColumnsNode;
import org.zkoss.poi.ss.formula.token.DefaultTokenNode;
import org.zkoss.poi.ss.formula.token.ErrorNode;
import org.zkoss.poi.ss.formula.token.FormulaTokenNode;
import org.zkoss.poi.ss.formula.token.IntegerNode;
import org.zkoss.poi.ss.formula.token.NameNode;
import org.zkoss.poi.ss.formula.token.NodeId;
import org.zkoss.poi.ss.formula.token.OpNode;
import org.zkoss.poi.ss.formula.token.TokenNodeVisitor;

public class FunctionNode
extends DefaultTokenNode<FormulaTokenNode> {
    private FormulaTokenNode[] children;

    public FunctionNode(FormulaTokenNode value) {
        super(value);
    }

    public int getChildrenLength() {
        return this.children != null ? this.children.length : 0;
    }

    @Override
    public NodeId getNodeId() {
        return NodeId.FunctionNode;
    }

    @Override
    public int getType() {
        switch (((NameNode)this.value).getValue().toUpperCase()) {
            case "IF": 
            case "LOOKUP": 
            case "CHOOSE": 
            case "INDEX": {
                return 32;
            }
        }
        return 64;
    }

    @Override
    public boolean hasOperands() {
        return this.children != null;
    }

    @Override
    public boolean add(FormulaTokenNode child) {
        this.children = child == null ? new FormulaTokenNode[0] : (child.getNodeId() == NodeId.CommaNode ? ArrayColumnsNode.expands((OpNode)child) : new FormulaTokenNode[]{child});
        return true;
    }

    @Override
    public FormulaTokenNode normalize(FormulaTokenParser parser) {
        FunctionNode node = this._normalize(parser);
        FormulaTokenNode[] children = node.children;
        for (int i = 0; i < children.length; ++i) {
            FormulaTokenNode child = children[i].normalize(parser);
            if (child == null) {
                return null;
            }
            children[i] = child;
        }
        return node;
    }

    private FunctionNode _normalize(FormulaTokenParser parser) {
        switch (((FormulaTokenNode)this.value).getNodeId()) {
            case NameNode: {
                String funcName = ((NameNode)this.value).getValue();
                FunctionInfo funcInfo = FunctionMetaInfo.getInfo(funcName);
                if (funcInfo == null) {
                    return this;
                }
                int childrenSize = this.children.length;
                if (funcInfo.hasOptional()) {
                    if (funcInfo.requiredParamSize > childrenSize) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("Function ");
                        sb.append(funcName);
                        sb.append(" requires at least ");
                        if (funcInfo.requiredParamSize == 1) {
                            sb.append("one parameter");
                        } else {
                            sb.append(funcInfo.requiredParamSize);
                            sb.append(" parameters");
                        }
                        throw new FormulaParseException(sb.toString());
                    }
                    if (funcInfo.paramSize < childrenSize) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("Too many parameters for function ");
                        sb.append(funcName);
                        sb.append(": at most ");
                        if (funcInfo.paramSize == 1) {
                            sb.append("one parameter is allowed");
                        } else {
                            sb.append(funcInfo.paramSize);
                            sb.append(" parameters are allowed");
                        }
                        throw new FormulaParseException(sb.toString());
                    }
                } else if (funcInfo.paramSize != childrenSize) {
                    int sid = funcInfo.sid;
                    if (childrenSize != 1 || sid != 27 && sid != 213 && sid != 212) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("Invalid parameters for function ");
                        sb.append(funcName);
                        sb.append(", expected ");
                        sb.append(funcInfo.paramSize);
                        sb.append(" parameters but was ");
                        sb.append(childrenSize);
                        throw new FormulaParseException(sb.toString());
                    }
                    this.children = new FormulaTokenNode[]{this.children[0], new IntegerNode(0)};
                }
                return this;
            }
            case ErrorNode: {
                if (this.value == ErrorNode.REF_ERROR) {
                    return this;
                }
                throw new FormulaParseException("Invalid function name(" + ((FormulaTokenNode)this.value).toString() + ')');
            }
        }
        FormulaTokenNode node = ((FormulaTokenNode)this.value).normalize(parser);
        if (node.getType() != 32) {
            throw new FormulaParseException("Invalid function name(" + ((FormulaTokenNode)this.value).toString() + ')');
        }
        FunctionNode functionNode = new FunctionNode(node);
        functionNode.children = this.children;
        return functionNode;
    }

    @Override
    public <R> R accept(TokenNodeVisitor<R> visitor) {
        return visitor.visitFunction(this);
    }

    @Override
    public <R> List<R> visitChildren(TokenNodeVisitor<R> visitor) {
        ArrayList<R> result = new ArrayList<R>(this.children.length);
        for (FormulaTokenNode child : this.children) {
            result.add(child.accept(visitor));
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(((FormulaTokenNode)this.value).toString().toUpperCase());
        sb.append('(');
        if (this.children != null) {
            int i = 0;
            while (i < this.children.length) {
                sb.append(this.children[i]);
                if (++i == this.children.length) continue;
                sb.append(',');
            }
        }
        sb.append(')');
        return sb.toString();
    }
}

