/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.formula.token;

import org.zkoss.poi.ss.formula.FormulaParseException;
import org.zkoss.poi.ss.formula.FormulaTokenParser;
import org.zkoss.poi.ss.formula.token.FormulaTokenNode;
import org.zkoss.poi.ss.formula.token.NodeId;
import org.zkoss.poi.ss.formula.token.OpNode;
import org.zkoss.poi.ss.formula.token.SingleChildNode;
import org.zkoss.poi.ss.formula.token.TokenNodeVisitor;

public class CommaNode
extends OpNode {
    @Override
    public int getFlag() {
        return 7;
    }

    @Override
    public String getOp() {
        return ",";
    }

    @Override
    public NodeId getNodeId() {
        return NodeId.CommaNode;
    }

    @Override
    public FormulaTokenNode normalize(FormulaTokenParser parser) {
        OpNode rightOpNode;
        if (this.left.getNodeId() == NodeId.PlusNode || this.left.getNodeId() == NodeId.MinusNode) {
            SingleChildNode singleChildNode = (SingleChildNode)this.left;
            this.left = singleChildNode.getChild();
            singleChildNode.setChild(this);
            return singleChildNode.normalize(parser);
        }
        this.left = this.left.normalize(parser);
        if (this.left.getType() != 32) {
            throw new FormulaParseException("Invalid reference for list");
        }
        if (this.right.getNodeId() == NodeId.CommaNode) {
            do {
                OpNode leftOpNode;
                if ((rightOpNode = (OpNode)this.right).getLeft().isOp() && rightOpNode.getLeft().getNodeId() != NodeId.CommaNode && (leftOpNode = (OpNode)rightOpNode.getLeft()).getFlag() > 2) {
                    this.right = leftOpNode.getLeft();
                    leftOpNode.setLeftOp(this);
                    rightOpNode.setLeftOp(leftOpNode.getRight());
                    leftOpNode.setRightOp(rightOpNode);
                    return leftOpNode.normalize(parser);
                }
                this.right = rightOpNode.getRight();
                rightOpNode.setRightOp(rightOpNode.getLeft().normalize(parser));
                if (rightOpNode.getRight() == null) {
                    return null;
                }
                if (rightOpNode.getRight().getType() != 32) {
                    throw new FormulaParseException("Invalid reference for list");
                }
                rightOpNode.setLeftOp(this.left);
                this.left = rightOpNode;
            } while (this.right.getNodeId() == NodeId.CommaNode);
        }
        if (this.right.isOp() && (rightOpNode = (OpNode)this.right).getFlag() > 2) {
            this.right = rightOpNode.getLeft();
            rightOpNode.setLeftOp(this);
            return rightOpNode.normalize(parser);
        }
        this.right = this.right.normalize(parser);
        if (this.right == null) {
            return null;
        }
        if (this.right.getType() != 32) {
            throw new FormulaParseException("Invalid reference for list");
        }
        return this;
    }

    @Override
    public <R> R accept(TokenNodeVisitor<R> visitor) {
        return visitor.visitComma(this);
    }
}

