/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.formula.token;

import java.util.ArrayList;
import java.util.List;
import org.zkoss.poi.ss.formula.FormulaParseException;
import org.zkoss.poi.ss.formula.FormulaTokenParser;
import org.zkoss.poi.ss.formula.token.ColonOpNode;
import org.zkoss.poi.ss.formula.token.ExternalRefNode;
import org.zkoss.poi.ss.formula.token.FormulaTokenNode;
import org.zkoss.poi.ss.formula.token.IntegerNode;
import org.zkoss.poi.ss.formula.token.NameNode;
import org.zkoss.poi.ss.formula.token.NodeId;
import org.zkoss.poi.ss.formula.token.OpNode;
import org.zkoss.poi.ss.formula.token.RefNode;
import org.zkoss.poi.ss.formula.token.TableRefNode;
import org.zkoss.poi.ss.formula.token.TokenNodeVisitor;
import org.zkoss.poi.ss.util.RefUtil;

public class BracketNode
implements FormulaTokenNode {
    private FormulaTokenNode left;
    private FormulaTokenNode child;
    private FormulaTokenNode right;

    public BracketNode(FormulaTokenNode left) {
        this.left = left;
    }

    public FormulaTokenNode getLeft() {
        return this.left;
    }

    public FormulaTokenNode getChild() {
        return this.child;
    }

    public FormulaTokenNode getRight() {
        return this.right;
    }

    public void setRight(FormulaTokenNode right) {
        this.right = right;
    }

    @Override
    public NodeId getNodeId() {
        return NodeId.BracketNode;
    }

    @Override
    public int getType() {
        return 32;
    }

    @Override
    public boolean hasOperands() {
        return this.child != null;
    }

    @Override
    public boolean isOp() {
        return false;
    }

    @Override
    public boolean add(FormulaTokenNode child) {
        this.child = child;
        return true;
    }

    @Override
    public FormulaTokenNode normalize(FormulaTokenParser parser) {
        return this.normalize(parser, null);
    }

    public FormulaTokenNode normalize(FormulaTokenParser parser, ExternalRefNode externalRef) {
        TableRefNode tableRef;
        long hash;
        if (!parser.isA1Notation() && (hash = this.toRefHash(parser)) != Long.MIN_VALUE) {
            return new RefNode(hash, externalRef);
        }
        if (this.right != null) {
            this._toError(this.right);
            return null;
        }
        if (this.left != null) {
            FormulaTokenNode childNode;
            if (this.left.getNodeId() == NodeId.ExclamationNode) {
                OpNode opNode = (OpNode)this.left;
                externalRef = OpNode.toExternalRef(opNode.getLeft());
                if (externalRef == null) {
                    if (opNode.getLeft().getNodeId() == NodeId.TableRefNode) {
                        ColonOpNode colonOp = new ColonOpNode();
                        OpNode leftOp = (OpNode)opNode.getLeft();
                        if (!((OpNode)colonOp).setLeftOp(leftOp.getLeft())) {
                            return null;
                        }
                        if (!opNode.setLeftOp(leftOp.getRight())) {
                            return null;
                        }
                        if (!((OpNode)colonOp).setRightOp(this)) {
                            return null;
                        }
                        return ((OpNode)colonOp).normalize(parser);
                    }
                    this._toError(this.left);
                    return null;
                }
                childNode = opNode.getRight();
            } else {
                childNode = this.left;
            }
            String stringValue = childNode.getNodeId() == NodeId.NameNode ? ((NameNode)childNode).getValue() : childNode.toString();
            tableRef = new TableRefNode(stringValue, externalRef);
        } else {
            tableRef = new TableRefNode("", externalRef);
        }
        switch (this.child.getNodeId()) {
            case BracketNode: {
                if (!this._isValid((BracketNode)this.child, parser, tableRef, false)) {
                    return null;
                }
                tableRef.setColumn(this.child.toString());
                break;
            }
            case NameNode: {
                NameNode nameNode = (NameNode)this.child;
                String nameNodeValue = nameNode.getValue();
                if (nameNodeValue.charAt(0) == '#') {
                    if (!tableRef.isValid(parser.isValidStructureRef(nameNodeValue))) {
                        this._toInvalidError();
                    }
                } else if (nameNodeValue.charAt(0) == '@' && !tableRef.isValid(16)) {
                    this._toInvalidError();
                }
                tableRef.setItem(nameNodeValue);
                break;
            }
            case CommaNode: {
                OpNode opNode = (OpNode)this.child;
                if (!this.isValidTableColumn(opNode.getLeft(), parser, tableRef)) {
                    return null;
                }
                if (!this.isValidTableColumn(opNode.getRight(), parser, tableRef)) {
                    return null;
                }
                tableRef.setItem(opNode.getLeft().toString());
                tableRef.setColumn(opNode.getRight().toString());
                break;
            }
            case ColonNode: {
                OpNode opNode = (OpNode)this.child;
                FormulaTokenNode opNodeLeft = opNode.getLeft();
                if (opNodeLeft.getNodeId() != NodeId.BracketNode) {
                    this._toError(opNodeLeft);
                    return null;
                }
                if (!this._isValid((BracketNode)opNodeLeft, parser, tableRef, true)) {
                    return null;
                }
                if (!this.isValidTableColumnX(opNode.getRight(), parser, tableRef, true)) {
                    return null;
                }
                tableRef.setItem(opNodeLeft.toString());
                tableRef.setColumn(opNode.getRight().toString());
            }
        }
        return tableRef;
    }

    @Override
    public <R> R accept(TokenNodeVisitor<R> visitor) {
        throw new FormulaParseException("Shouldn't run into this");
    }

    @Override
    public <R> List<R> visitChildren(TokenNodeVisitor<R> visitor) {
        ArrayList<R> result = new ArrayList<R>();
        if (this.left != null) {
            result.add(this.left.accept(visitor));
        }
        if (this.child != null) {
            result.add(this.child.accept(visitor));
        }
        if (this.right != null) {
            result.add(this.right.accept(visitor));
        }
        return result;
    }

    public String toString() {
        return (this.left != null ? this.left.toString() : "") + '[' + (this.child != null ? this.child.toString() : "") + ']' + (this.right != null ? this.right.toString() : "");
    }

    public long toRefHash(FormulaTokenParser parser) {
        NodeId thisChildId = this.child.getNodeId();
        int maxRows = 0x100000;
        int maxCols = 16384;
        char[] chars = parser.getChars();
        int parserColIndex = parser.getColIndex();
        int parserRowIndex = parser.getRowIndex();
        if (this.left == null || thisChildId != NodeId.EmptyNode && thisChildId != NodeId.IntegerNode && thisChildId != NodeId.NameNode) {
            return Long.MIN_VALUE;
        }
        if (this.left.getNodeId() == NodeId.NameNode) {
            NameNode nameNode = (NameNode)this.left;
            if (nameNode.isSpecial()) {
                return Long.MIN_VALUE;
            }
            String nameNodeValue = nameNode.getValue();
            int nameNodeStartIndex = nameNode.getStartIndex();
            if (nameNodeValue.length() > 1) {
                if (this.right != null) {
                    return Long.MIN_VALUE;
                }
                if ((chars[nameNodeStartIndex] | 0x20) != 114) {
                    return Long.MIN_VALUE;
                }
                if (nameNodeValue.length() == 2) {
                    int intValue;
                    if (chars[nameNodeStartIndex + 1] + 32 != 99) {
                        return Long.MIN_VALUE;
                    }
                    if (thisChildId == NodeId.EmptyNode) {
                        throw new FormulaParseException("Not implemented yet");
                    }
                    if (thisChildId == NodeId.IntegerNode) {
                        intValue = ((IntegerNode)this.child).getValue();
                    } else {
                        IntegerNode integerNode = ((NameNode)this.child).toIntegerNode();
                        if (integerNode == null) {
                            return Long.MIN_VALUE;
                        }
                        intValue = integerNode.getValue();
                    }
                    if (intValue <= maxCols && intValue >= -maxCols) {
                        if ((intValue += parserColIndex) < 0) {
                            intValue += maxCols + 1;
                        } else if (intValue > maxCols) {
                            intValue -= maxCols + 1;
                        }
                        return RefUtil.toRefHash(parserRowIndex, true, intValue, true);
                    }
                    return Long.MIN_VALUE;
                }
                if (nameNodeValue.length() > 9) {
                    return Long.MIN_VALUE;
                }
                int intValue = nameNodeStartIndex + nameNodeValue.length() - 1;
                if ((chars[intValue] | 0x20) != 99) {
                    return Long.MIN_VALUE;
                }
                int numberValue = 0;
                for (int index = nameNodeStartIndex + 1; index < intValue; ++index) {
                    char c = chars[index];
                    if (c < '0' || c > '9') {
                        return Long.MIN_VALUE;
                    }
                    numberValue = numberValue * 10 + (c - 48);
                }
                if (--numberValue >= 0 && numberValue <= maxRows) {
                    int colIndex;
                    if (thisChildId == NodeId.EmptyNode) {
                        return RefUtil.toRefHash(numberValue, false, parserColIndex, true);
                    }
                    if (thisChildId == NodeId.IntegerNode) {
                        colIndex = ((IntegerNode)this.child).getValue();
                    } else {
                        IntegerNode integerNode = ((NameNode)this.child).toIntegerNode();
                        if (integerNode == null) {
                            return Long.MIN_VALUE;
                        }
                        colIndex = integerNode.getValue();
                    }
                    if (colIndex <= maxCols && colIndex >= -maxCols) {
                        if ((colIndex += parserColIndex) < 0) {
                            colIndex += maxCols + 1;
                        } else if (colIndex > maxCols) {
                            colIndex -= maxCols + 1;
                        }
                        return RefUtil.toRefHash(numberValue, false, colIndex, true);
                    }
                    return Long.MIN_VALUE;
                }
                return Long.MIN_VALUE;
            }
            if ((chars[nameNodeStartIndex] | 0x20) == 114) {
                int intValue;
                if (thisChildId == NodeId.EmptyNode) {
                    intValue = parserRowIndex;
                } else {
                    if (thisChildId == NodeId.IntegerNode) {
                        intValue = ((IntegerNode)this.child).getValue();
                    } else {
                        IntegerNode integerNode = ((NameNode)this.child).toIntegerNode();
                        if (integerNode == null) {
                            return Long.MIN_VALUE;
                        }
                        intValue = integerNode.getValue();
                    }
                    if (intValue > maxRows || intValue < -maxRows) {
                        return Long.MIN_VALUE;
                    }
                    if ((intValue += parserRowIndex) < 0) {
                        intValue += maxRows + 1;
                    } else if (intValue > maxRows) {
                        intValue -= maxRows + 1;
                    }
                }
                if (this.right == null) {
                    return RefUtil.toRowHash(intValue, true);
                }
                if (this.right.getNodeId() != NodeId.NameNode) {
                    return Long.MIN_VALUE;
                }
                nameNode = (NameNode)this.right;
                nameNodeValue = nameNode.getValue();
                nameNodeStartIndex = nameNode.getStartIndex();
                if ((chars[nameNodeStartIndex] | 0x20) != 99) {
                    return Long.MIN_VALUE;
                }
                if (nameNodeValue.length() == 1) {
                    return RefUtil.toRefHash(intValue, true, parserColIndex, true);
                }
                if (nameNodeValue.length() > 6) {
                    return Long.MIN_VALUE;
                }
                int numberValue = 0;
                int index = nameNodeStartIndex + nameNodeValue.length();
                for (int colIndex = nameNodeStartIndex + 1; colIndex < index; ++colIndex) {
                    char c = chars[colIndex];
                    if (c < '0' || c > '9') {
                        return Long.MIN_VALUE;
                    }
                    numberValue = numberValue * 10 + (c - 48);
                }
                if (--numberValue >= 0 && numberValue <= maxCols) {
                    return RefUtil.toRefHash(intValue, true, numberValue, false);
                }
                return Long.MIN_VALUE;
            }
            if ((chars[nameNodeStartIndex] | 0x20) == 99) {
                if (this.right != null) {
                    return Long.MIN_VALUE;
                }
                if (thisChildId == NodeId.EmptyNode) {
                    return RefUtil.toColHash(parserColIndex, true);
                }
                IntegerNode integerNode = ((NameNode)this.child).toIntegerNode();
                if (integerNode == null) {
                    return Long.MIN_VALUE;
                }
                int intValue = integerNode.getValue();
                if (intValue <= maxCols && intValue >= -maxCols) {
                    if ((intValue += parserColIndex) < 0) {
                        intValue += maxCols + 1;
                    } else if (intValue > maxCols) {
                        intValue -= maxCols;
                    }
                    return RefUtil.toColHash(intValue, true);
                }
                return Long.MIN_VALUE;
            }
        }
        if (this.left.getNodeId() == NodeId.BracketNode && this.right == null) {
            int index;
            IntegerNode integerNode;
            int numberValue;
            BracketNode bracketNode = (BracketNode)this.left;
            FormulaTokenNode bracketLeftNode = bracketNode.getLeft();
            FormulaTokenNode bracketChildNode = bracketNode.getChild();
            FormulaTokenNode bracketRightNode = bracketNode.getRight();
            if (bracketLeftNode == null || bracketRightNode == null) {
                return Long.MIN_VALUE;
            }
            if (bracketLeftNode.getNodeId() != NodeId.NameNode || bracketRightNode.getNodeId() != NodeId.NameNode) {
                return Long.MIN_VALUE;
            }
            NodeId bracketChildNodeId = bracketChildNode.getNodeId();
            if (bracketChildNodeId != NodeId.EmptyNode && bracketChildNodeId != NodeId.IntegerNode && bracketChildNodeId != NodeId.NameNode) {
                return Long.MIN_VALUE;
            }
            NameNode nameNode = (NameNode)bracketLeftNode;
            if (nameNode.getValue().length() != 1 || nameNode.isSpecial() || (chars[nameNode.getStartIndex()] | 0x20) != 114) {
                return Long.MIN_VALUE;
            }
            nameNode = (NameNode)bracketRightNode;
            if (nameNode.getValue().length() != 1 || nameNode.isSpecial() || (chars[nameNode.getStartIndex()] | 0x20) != 99) {
                return Long.MIN_VALUE;
            }
            if (bracketChildNode.getNodeId() == NodeId.EmptyNode) {
                numberValue = parserRowIndex;
            } else {
                if (bracketChildNodeId == NodeId.IntegerNode) {
                    numberValue = ((IntegerNode)bracketChildNode).getValue();
                } else {
                    integerNode = ((NameNode)bracketChildNode).toIntegerNode();
                    if (integerNode == null) {
                        return Long.MIN_VALUE;
                    }
                    numberValue = integerNode.getValue();
                }
                if (numberValue > maxRows || numberValue < -maxRows) {
                    return Long.MIN_VALUE;
                }
                if ((numberValue += parserRowIndex) < 0) {
                    numberValue += maxRows + 1;
                } else if (numberValue > maxRows) {
                    numberValue -= maxRows + 1;
                }
            }
            if (thisChildId == NodeId.EmptyNode) {
                return RefUtil.toRefHash(numberValue, true, parserColIndex, true);
            }
            if (thisChildId == NodeId.IntegerNode) {
                index = ((IntegerNode)this.child).getValue();
            } else {
                integerNode = ((NameNode)this.child).toIntegerNode();
                if (integerNode == null) {
                    return Long.MIN_VALUE;
                }
                index = integerNode.getValue();
            }
            if (index <= maxCols && index >= maxCols) {
                if ((index += parserColIndex) < 0) {
                    index += maxCols + 1;
                } else if (index > maxCols) {
                    index -= maxCols + 1;
                }
                return RefUtil.toRefHash(numberValue, true, index, true);
            }
        }
        return Long.MIN_VALUE;
    }

    private void _toError(FormulaTokenNode node) throws RuntimeException {
        throw new FormulaParseException("Unknown token: " + node.toString());
    }

    private void _toInvalidError() {
        throw new FormulaParseException("Invalid table references. Specified rows to make up the contiguous range can only be one of following items: Headers, Data, Totals, Data and Headers, Data and Totals, CurrentRow");
    }

    boolean isValidTableColumn(FormulaTokenNode node, FormulaTokenParser parser, TableRefNode tableRef) {
        switch (node.getNodeId()) {
            case BracketNode: {
                if (this.isValidTableColumnX(node, parser, tableRef, false)) break;
                return false;
            }
            case CommaNode: {
                OpNode opNode = (OpNode)node;
                if (!this.isValidTableColumn(opNode.getLeft(), parser, tableRef)) {
                    return false;
                }
                if (this.isValidTableColumn(opNode.getRight(), parser, tableRef)) break;
                return false;
            }
            case ColonNode: {
                OpNode opNode = (OpNode)node;
                if (!this.isValidTableColumnX(opNode.getLeft(), parser, tableRef, true)) {
                    return false;
                }
                if (this.isValidTableColumnX(opNode.getRight(), parser, tableRef, true)) break;
                return false;
            }
            default: {
                this._toError(node);
                return false;
            }
        }
        return true;
    }

    boolean isValidTableColumnX(FormulaTokenNode node, FormulaTokenParser parser, TableRefNode tableRef, boolean flag) {
        if (node.getNodeId() != NodeId.BracketNode) {
            this._toError(node);
            return false;
        }
        BracketNode bracketNode = (BracketNode)node;
        if (bracketNode.getLeft() != null || bracketNode.getRight() != null) {
            this._toError(bracketNode);
            return false;
        }
        FormulaTokenNode bracketNodeChild = bracketNode.getChild();
        if (bracketNodeChild.getNodeId() != NodeId.NameNode) {
            this._toError(bracketNodeChild);
            return false;
        }
        NameNode nameNode = (NameNode)bracketNodeChild;
        String nameNodeValue = nameNode.getValue();
        if (nameNodeValue.charAt(0) == '#') {
            if (flag) {
                this._toError(nameNode);
                return false;
            }
            if (!tableRef.isValid(parser.isValidStructureRef(nameNodeValue))) {
                this._toInvalidError();
                return false;
            }
        }
        return true;
    }

    private boolean _isValid(BracketNode node, FormulaTokenParser parser, TableRefNode refNode, boolean flag) {
        block20: {
            FormulaTokenNode nodeChild;
            block19: {
                FormulaTokenNode nodeLeft = node.getLeft();
                nodeChild = node.getChild();
                FormulaTokenNode nodeRight = node.getRight();
                if (nodeRight != null) {
                    this._toError(node.right);
                    return false;
                }
                if (nodeLeft == null) break block19;
                if (nodeLeft.getNodeId() != NodeId.NameNode) {
                    this._toError(nodeLeft);
                    return false;
                }
                NameNode nameNode = (NameNode)nodeLeft;
                String nameNodeValue = nameNode.getValue();
                if (nameNodeValue.length() != 1 || nameNodeValue.charAt(0) != '@') {
                    this._toError(nodeLeft);
                    return false;
                }
                if (!refNode.isValid(16)) {
                    this._toInvalidError();
                    return false;
                }
                switch (nodeChild.getNodeId()) {
                    case NameNode: {
                        nameNode = (NameNode)nodeChild;
                        if (nameNode.getValue().charAt(0) == '#') {
                            this._toError(nameNode);
                            return false;
                        }
                        break block20;
                    }
                    case EmptyNode: {
                        if (flag) {
                            this._toError(nodeChild);
                            return false;
                        }
                        if (!refNode.isValid(1)) {
                            this._toInvalidError();
                            return false;
                        }
                        break block20;
                    }
                    default: {
                        this._toError(nodeChild);
                        return false;
                    }
                }
            }
            switch (nodeChild.getNodeId()) {
                case NameNode: {
                    NameNode nameNode = (NameNode)nodeChild;
                    String nameNodeValue = nameNode.getValue();
                    if (nameNodeValue.charAt(0) == '#') {
                        if (flag) {
                            this._toError(nameNode);
                            return false;
                        }
                        if (!refNode.isValid(parser.isValidStructureRef(nameNodeValue))) {
                            this._toInvalidError();
                            return false;
                        }
                    }
                    refNode.setColumn(nameNodeValue);
                    break;
                }
                case EmptyNode: {
                    if (flag) {
                        this._toError(nodeChild);
                        return false;
                    }
                    if (refNode.isValid(1)) break;
                    this._toInvalidError();
                    return false;
                }
                default: {
                    this._toError(nodeChild);
                    return false;
                }
            }
        }
        return true;
    }
}

