/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.formula.token;

import java.util.Collections;
import java.util.List;
import org.zkoss.poi.ss.formula.FormulaParseException;
import org.zkoss.poi.ss.formula.FormulaTokenParser;
import org.zkoss.poi.ss.formula.token.FormulaTokenNode;
import org.zkoss.poi.ss.formula.token.NodeId;
import org.zkoss.poi.ss.formula.token.TokenNodeVisitor;

public class BoolNode
implements FormulaTokenNode {
    private final boolean value;

    public BoolNode(boolean value) {
        this.value = value;
    }

    public boolean getValue() {
        return this.value;
    }

    @Override
    public NodeId getNodeId() {
        return NodeId.BoolNode;
    }

    @Override
    public int getType() {
        return 64;
    }

    @Override
    public boolean hasOperands() {
        return true;
    }

    @Override
    public boolean isOp() {
        return false;
    }

    @Override
    public boolean add(FormulaTokenNode child) {
        throw new FormulaParseException("Simple bool should not have child");
    }

    @Override
    public FormulaTokenNode normalize(FormulaTokenParser parser) {
        return this;
    }

    @Override
    public <R> R accept(TokenNodeVisitor<R> visitor) {
        return visitor.visitBoolean(this);
    }

    @Override
    public <R> List<R> visitChildren(TokenNodeVisitor<R> visitor) {
        return Collections.emptyList();
    }

    public String toString() {
        return this.value ? "TRUE" : "FALSE";
    }
}

