/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.formula.token;

import java.util.LinkedList;
import java.util.List;
import org.zkoss.poi.ss.formula.FormulaParseException;
import org.zkoss.poi.ss.formula.FormulaTokenParser;
import org.zkoss.poi.ss.formula.token.FormulaTokenNode;
import org.zkoss.poi.ss.formula.token.NodeId;
import org.zkoss.poi.ss.formula.token.OpNode;
import org.zkoss.poi.ss.formula.token.TokenNodeVisitor;

public class ArrayColumnsNode
implements FormulaTokenNode {
    private FormulaTokenNode[][] children;

    public ArrayColumnsNode() {
    }

    public ArrayColumnsNode(FormulaTokenNode[][] children) {
        this.children = children;
    }

    public int getRowCount() {
        return this.hasOperands() ? this.children.length : 0;
    }

    public int getColCount() {
        return this.hasOperands() && this.children.length != 0 ? this.children[0].length : 0;
    }

    public FormulaTokenNode[][] getChildren() {
        return this.children;
    }

    @Override
    public NodeId getNodeId() {
        return NodeId.ArrayColumnsNode;
    }

    @Override
    public int getType() {
        return 96;
    }

    @Override
    public boolean hasOperands() {
        return this.children != null;
    }

    @Override
    public boolean isOp() {
        return false;
    }

    @Override
    public boolean add(FormulaTokenNode child) {
        if (child == null) {
            throw new FormulaParseException("Array cannot be empty");
        }
        this.children = child.getNodeId() == NodeId.CommaNode ? new FormulaTokenNode[][]{ArrayColumnsNode.expands((OpNode)child)} : new FormulaTokenNode[][]{{child}};
        return true;
    }

    @Override
    public FormulaTokenNode normalize(FormulaTokenParser parser) {
        for (FormulaTokenNode[] rows : this.children) {
            for (int i = 0; i < rows.length; ++i) {
                FormulaTokenNode child = rows[i].normalize(parser);
                if (child == null) {
                    return null;
                }
                rows[i] = child;
            }
        }
        return this;
    }

    @Override
    public <R> R accept(TokenNodeVisitor<R> visitor) {
        return visitor.visitArrayColumns(this);
    }

    @Override
    public <R> List<R> visitChildren(TokenNodeVisitor<R> visitor) {
        LinkedList<R> result = new LinkedList<R>();
        FormulaTokenNode[][] formulaTokenNodeArray = this.children;
        int n = formulaTokenNodeArray.length;
        for (int i = 0; i < n; ++i) {
            FormulaTokenNode[] rows;
            for (FormulaTokenNode node : rows = formulaTokenNodeArray[i]) {
                result.add(node.accept(visitor));
            }
        }
        return result;
    }

    static FormulaTokenNode[] expands(OpNode parent) {
        LinkedList<FormulaTokenNode> list = new LinkedList<FormulaTokenNode>();
        while (true) {
            list.add(parent.getLeft());
            FormulaTokenNode child = parent.getRight();
            if (child.getNodeId() != NodeId.CommaNode) {
                list.add(child);
                return list.toArray(new FormulaTokenNode[0]);
            }
            parent = (OpNode)child;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.children != null && this.children.length != 0) {
            sb.append('{');
            int i = 0;
            while (i < this.children.length) {
                FormulaTokenNode[] rows = this.children[i];
                int j = 0;
                while (j < rows.length) {
                    sb.append(rows[j]);
                    if (++j == rows.length) continue;
                    sb.append(',');
                }
                if (++i == this.children.length) continue;
                sb.append(';');
            }
            sb.append('}');
        } else {
            sb.append("{}");
        }
        return sb.toString();
    }
}

