/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.formula.token;

import java.util.Collections;
import java.util.List;
import org.zkoss.poi.ss.formula.FormulaParseException;
import org.zkoss.poi.ss.formula.FormulaTokenParser;
import org.zkoss.poi.ss.formula.token.ExternalRefNode;
import org.zkoss.poi.ss.formula.token.FormulaTokenNode;
import org.zkoss.poi.ss.formula.token.NodeId;
import org.zkoss.poi.ss.formula.token.TokenNodeVisitor;
import org.zkoss.poi.ss.util.RefUtil;

public class AreaRefNode
implements FormulaTokenNode {
    private final long topLeft;
    private final long bottomRight;
    private ExternalRefNode externalRef;

    public AreaRefNode(long topLeft, long bottomRight) {
        this.topLeft = topLeft;
        this.bottomRight = bottomRight;
    }

    public void setExternalRef(ExternalRefNode externalRef) {
        this.externalRef = externalRef;
    }

    public long getTopLeft() {
        return this.topLeft;
    }

    public long getBottomRight() {
        return this.bottomRight;
    }

    @Override
    public NodeId getNodeId() {
        return NodeId.AreaRefNode;
    }

    @Override
    public int getType() {
        return 32;
    }

    @Override
    public boolean hasOperands() {
        return true;
    }

    @Override
    public boolean isOp() {
        return false;
    }

    @Override
    public boolean add(FormulaTokenNode child) {
        throw new FormulaParseException("Simple operand should not have child.");
    }

    @Override
    public FormulaTokenNode normalize(FormulaTokenParser parser) {
        return this;
    }

    @Override
    public <R> R accept(TokenNodeVisitor<R> visitor) {
        return visitor.visitAreaRef(this);
    }

    @Override
    public <R> List<R> visitChildren(TokenNodeVisitor<R> visitor) {
        return Collections.emptyList();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.externalRef != null) {
            sb.append(this.externalRef);
            sb.append('!');
        }
        sb.append(RefUtil.decodeRef(this.topLeft));
        sb.append(':');
        sb.append(RefUtil.decodeRef(this.bottomRight));
        return sb.toString();
    }
}

