/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.formula.ptg;

import org.zkoss.poi.ss.SpreadsheetVersion;
import org.zkoss.poi.ss.formula.ptg.RefPtgBase;
import org.zkoss.poi.ss.util.CellReference;
import org.zkoss.poi.util.LittleEndianInput;
import org.zkoss.poi.util.LittleEndianOutput;

abstract class Ref2DPtgBase
extends RefPtgBase {
    private static final int SIZE = 5;
    private static final int SIZE_2007 = 7;

    protected Ref2DPtgBase(int row, int column, boolean isRowRelative, boolean isColumnRelative) {
        this.setRow(row);
        this.setColumn(column);
        this.setRowRelative(isRowRelative);
        this.setColRelative(isColumnRelative);
    }

    protected Ref2DPtgBase(LittleEndianInput in, SpreadsheetVersion version) {
        this.readCoordinates(in, version);
    }

    protected Ref2DPtgBase(CellReference cr) {
        super(cr);
    }

    @Override
    public void write(LittleEndianOutput out) {
        this.write(out, SpreadsheetVersion.EXCEL97);
    }

    @Override
    public void write(LittleEndianOutput out, SpreadsheetVersion version) {
        out.writeByte(this.getSid() + this.getPtgClass());
        this.writeCoordinates(out, version);
    }

    @Override
    public final String toFormulaString() {
        return this.formatReferenceAsString();
    }

    protected abstract byte getSid();

    @Override
    public final int getSize() {
        return 5;
    }

    @Override
    public final int getSize(SpreadsheetVersion version) {
        return version == SpreadsheetVersion.EXCEL2007 ? 7 : 5;
    }

    @Override
    public final String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append(" [");
        sb.append(this.formatReferenceAsString());
        sb.append("]");
        return sb.toString();
    }
}

