/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.formula.ptg;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.zkoss.poi.ss.SpreadsheetVersion;
import org.zkoss.poi.ss.formula.ptg.AddPtg;
import org.zkoss.poi.ss.formula.ptg.Area3DPtg;
import org.zkoss.poi.ss.formula.ptg.AreaErrPtg;
import org.zkoss.poi.ss.formula.ptg.AreaNPtg;
import org.zkoss.poi.ss.formula.ptg.AreaPtg;
import org.zkoss.poi.ss.formula.ptg.ArrayPtg;
import org.zkoss.poi.ss.formula.ptg.AttrPtg;
import org.zkoss.poi.ss.formula.ptg.BoolPtg;
import org.zkoss.poi.ss.formula.ptg.ConcatPtg;
import org.zkoss.poi.ss.formula.ptg.DeletedArea3DPtg;
import org.zkoss.poi.ss.formula.ptg.DeletedRef3DPtg;
import org.zkoss.poi.ss.formula.ptg.DividePtg;
import org.zkoss.poi.ss.formula.ptg.EqualPtg;
import org.zkoss.poi.ss.formula.ptg.ErrPtg;
import org.zkoss.poi.ss.formula.ptg.ExpPtg;
import org.zkoss.poi.ss.formula.ptg.FuncPtg;
import org.zkoss.poi.ss.formula.ptg.FuncVarPtg;
import org.zkoss.poi.ss.formula.ptg.GreaterEqualPtg;
import org.zkoss.poi.ss.formula.ptg.GreaterThanPtg;
import org.zkoss.poi.ss.formula.ptg.IntPtg;
import org.zkoss.poi.ss.formula.ptg.IntersectionPtg;
import org.zkoss.poi.ss.formula.ptg.LessEqualPtg;
import org.zkoss.poi.ss.formula.ptg.LessThanPtg;
import org.zkoss.poi.ss.formula.ptg.MemAreaPtg;
import org.zkoss.poi.ss.formula.ptg.MemErrPtg;
import org.zkoss.poi.ss.formula.ptg.MemFuncPtg;
import org.zkoss.poi.ss.formula.ptg.MissingArgPtg;
import org.zkoss.poi.ss.formula.ptg.MultiplyPtg;
import org.zkoss.poi.ss.formula.ptg.NamePtg;
import org.zkoss.poi.ss.formula.ptg.NameXPtg;
import org.zkoss.poi.ss.formula.ptg.NotEqualPtg;
import org.zkoss.poi.ss.formula.ptg.NumberPtg;
import org.zkoss.poi.ss.formula.ptg.Parenthesis2Ptg;
import org.zkoss.poi.ss.formula.ptg.ParenthesisPtg;
import org.zkoss.poi.ss.formula.ptg.PercentPtg;
import org.zkoss.poi.ss.formula.ptg.PowerPtg;
import org.zkoss.poi.ss.formula.ptg.RangePtg;
import org.zkoss.poi.ss.formula.ptg.Ref3DPtg;
import org.zkoss.poi.ss.formula.ptg.RefErrorPtg;
import org.zkoss.poi.ss.formula.ptg.RefNPtg;
import org.zkoss.poi.ss.formula.ptg.RefPtg;
import org.zkoss.poi.ss.formula.ptg.StringPtg;
import org.zkoss.poi.ss.formula.ptg.SubtractPtg;
import org.zkoss.poi.ss.formula.ptg.TablePtg;
import org.zkoss.poi.ss.formula.ptg.TblPtg;
import org.zkoss.poi.ss.formula.ptg.UnaryMinusPtg;
import org.zkoss.poi.ss.formula.ptg.UnaryPlusPtg;
import org.zkoss.poi.ss.formula.ptg.UnionPtg;
import org.zkoss.poi.ss.formula.ptg.UnknownPtg;
import org.zkoss.poi.util.LittleEndianByteArrayOutputStream;
import org.zkoss.poi.util.LittleEndianInput;
import org.zkoss.poi.util.LittleEndianOutput;

public abstract class Ptg
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -5877373845194532264L;
    public static final Ptg[] EMPTY_PTG_ARRAY = new Ptg[0];
    public static final byte CLASS_REF = 0;
    public static final byte CLASS_VALUE = 32;
    public static final byte CLASS_ARRAY = 64;
    private byte ptgClass = 0;

    public static Ptg[] readTokens(int size, LittleEndianInput in) {
        return Ptg.readTokens(size, in, SpreadsheetVersion.EXCEL97);
    }

    public static Ptg[] readTokens(int size, LittleEndianInput in, SpreadsheetVersion version) {
        int pos;
        Ptg ptg;
        ArrayList<Ptg> temp = new ArrayList<Ptg>(4 + size / 2);
        boolean hasArrayPtgs = false;
        for (pos = 0; pos < size; pos += ptg.getSize(version)) {
            ptg = Ptg.createPtg(in, version);
            if (ptg instanceof ArrayPtg.Initial) {
                hasArrayPtgs = true;
            }
            temp.add(ptg);
        }
        if (pos != size) {
            throw new RuntimeException("Ptg array size mismatch");
        }
        if (hasArrayPtgs) {
            Ptg[] result = Ptg.toPtgArray(temp);
            for (int i = 0; i < result.length; ++i) {
                if (!(result[i] instanceof ArrayPtg.Initial)) continue;
                result[i] = ((ArrayPtg.Initial)result[i]).finishReading(in);
            }
            return result;
        }
        return Ptg.toPtgArray(temp);
    }

    public static Ptg createPtg(LittleEndianInput in) {
        return Ptg.createPtg(in, SpreadsheetVersion.EXCEL97);
    }

    public static Ptg createPtg(LittleEndianInput in, SpreadsheetVersion version) {
        byte id = in.readByte();
        if (id < 32) {
            return Ptg.createBasePtg(id, in, version);
        }
        Ptg retval = Ptg.createClassifiedPtg(id, in, version);
        if (id >= 96) {
            retval.setClass((byte)64);
        } else if (id >= 64) {
            retval.setClass((byte)32);
        } else {
            retval.setClass((byte)0);
        }
        return retval;
    }

    private static Ptg createClassifiedPtg(byte id, LittleEndianInput in, SpreadsheetVersion version) {
        int baseId = id & 0x1F | 0x20;
        switch (baseId) {
            case 32: {
                return new ArrayPtg.Initial(in);
            }
            case 33: {
                return FuncPtg.create(in);
            }
            case 34: {
                return FuncVarPtg.create(in);
            }
            case 35: {
                return new NamePtg(in);
            }
            case 36: {
                return new RefPtg(in, version);
            }
            case 37: {
                return new AreaPtg(in, version);
            }
            case 38: {
                return new MemAreaPtg(in);
            }
            case 39: {
                return new MemErrPtg(in);
            }
            case 41: {
                return new MemFuncPtg(in);
            }
            case 42: {
                return new RefErrorPtg(in);
            }
            case 43: {
                return new AreaErrPtg(in);
            }
            case 44: {
                return new RefNPtg(in, version);
            }
            case 45: {
                return new AreaNPtg(in, version);
            }
            case 57: {
                return new NameXPtg(in);
            }
            case 58: {
                return new Ref3DPtg(in, version);
            }
            case 59: {
                return new Area3DPtg(in, version);
            }
            case 60: {
                return new DeletedRef3DPtg(in);
            }
            case 61: {
                return new DeletedArea3DPtg(in);
            }
            case 62: {
                return new TablePtg(in);
            }
        }
        throw new UnsupportedOperationException(" Unknown Ptg in Formula: 0x" + Integer.toHexString(id) + " (" + id + ")");
    }

    private static Ptg createBasePtg(byte id, LittleEndianInput in, SpreadsheetVersion version) {
        switch (id) {
            case 0: {
                return new UnknownPtg(id);
            }
            case 1: {
                return new ExpPtg(in);
            }
            case 2: {
                return new TblPtg(in);
            }
            case 3: {
                return AddPtg.instance;
            }
            case 4: {
                return SubtractPtg.instance;
            }
            case 5: {
                return new MultiplyPtg(in, version);
            }
            case 6: {
                return DividePtg.instance;
            }
            case 7: {
                return PowerPtg.instance;
            }
            case 8: {
                return ConcatPtg.instance;
            }
            case 9: {
                return LessThanPtg.instance;
            }
            case 10: {
                return LessEqualPtg.instance;
            }
            case 11: {
                return EqualPtg.instance;
            }
            case 12: {
                return GreaterEqualPtg.instance;
            }
            case 13: {
                return GreaterThanPtg.instance;
            }
            case 14: {
                return NotEqualPtg.instance;
            }
            case 15: {
                return IntersectionPtg.instance;
            }
            case 16: {
                return UnionPtg.instance;
            }
            case 17: {
                return RangePtg.instance;
            }
            case 18: {
                return UnaryPlusPtg.instance;
            }
            case 19: {
                return UnaryMinusPtg.instance;
            }
            case 20: {
                return PercentPtg.instance;
            }
            case 21: {
                return ParenthesisPtg.instance;
            }
            case 22: {
                return MissingArgPtg.instance;
            }
            case 23: {
                return new StringPtg(in);
            }
            case 25: {
                return new AttrPtg(in);
            }
            case 26: {
                return new Parenthesis2Ptg(in);
            }
            case 28: {
                return ErrPtg.read(in);
            }
            case 29: {
                return BoolPtg.read(in);
            }
            case 30: {
                return new IntPtg(in);
            }
            case 31: {
                return new NumberPtg(in);
            }
        }
        throw new RuntimeException("Unexpected base token id (" + id + ")");
    }

    private static Ptg[] toPtgArray(List<Ptg> l) {
        if (l.isEmpty()) {
            return EMPTY_PTG_ARRAY;
        }
        Ptg[] result = new Ptg[l.size()];
        l.toArray(result);
        return result;
    }

    public static int getEncodedSize(Ptg[] ptgs) {
        return Ptg.getEncodedSize(ptgs, SpreadsheetVersion.EXCEL97);
    }

    public static int getEncodedSize(Ptg[] ptgs, SpreadsheetVersion version) {
        int result = 0;
        for (int i = 0; i < ptgs.length; ++i) {
            result += ptgs[i].getSize(version);
        }
        return result;
    }

    public static int getEncodedSizeWithoutArrayData(Ptg[] ptgs) {
        return Ptg.getEncodedSizeWithoutArrayData(ptgs, SpreadsheetVersion.EXCEL97);
    }

    public static int getEncodedSizeWithoutArrayData(Ptg[] ptgs, SpreadsheetVersion version) {
        int result = 0;
        for (int i = 0; i < ptgs.length; ++i) {
            Ptg ptg = ptgs[i];
            if (ptg instanceof ArrayPtg) {
                result += 8;
                continue;
            }
            result += ptg.getSize(version);
        }
        return result;
    }

    public static int serializePtgs(Ptg[] ptgs, byte[] array, int offset) {
        return Ptg.serializePtgs(ptgs, array, offset, SpreadsheetVersion.EXCEL97);
    }

    public static int serializePtgs(Ptg[] ptgs, byte[] array, int offset, SpreadsheetVersion version) {
        int nTokens = ptgs.length;
        LittleEndianByteArrayOutputStream out = new LittleEndianByteArrayOutputStream(array, offset);
        ArrayList<Ptg> arrayPtgs = null;
        for (int k = 0; k < nTokens; ++k) {
            Ptg ptg = ptgs[k];
            ptg.write(out, version);
            if (!(ptg instanceof ArrayPtg)) continue;
            if (arrayPtgs == null) {
                arrayPtgs = new ArrayList<Ptg>(5);
            }
            arrayPtgs.add(ptg);
        }
        if (arrayPtgs != null) {
            for (int i = 0; i < arrayPtgs.size(); ++i) {
                ArrayPtg p = (ArrayPtg)arrayPtgs.get(i);
                p.writeTokenValueBytes(out);
            }
        }
        return out.getWriteIndex() - offset;
    }

    public abstract int getSize();

    public abstract int getSize(SpreadsheetVersion var1);

    public abstract void write(LittleEndianOutput var1);

    public abstract void write(LittleEndianOutput var1, SpreadsheetVersion var2);

    public abstract String toFormulaString();

    public String toString() {
        return this.getClass().toString();
    }

    public final void setClass(byte thePtgClass) {
        if (this.isBaseToken()) {
            throw new RuntimeException("setClass should not be called on a base token");
        }
        this.ptgClass = thePtgClass;
    }

    public final byte getPtgClass() {
        return this.ptgClass;
    }

    public final char getRVAType() {
        if (this.isBaseToken()) {
            return '.';
        }
        switch (this.ptgClass) {
            case 0: {
                return 'R';
            }
            case 32: {
                return 'V';
            }
            case 64: {
                return 'A';
            }
        }
        throw new RuntimeException("Unknown operand class (" + this.ptgClass + ")");
    }

    public abstract byte getDefaultOperandClass();

    public abstract boolean isBaseToken();

    public static boolean doesFormulaReferToDeletedCell(Ptg[] ptgs) {
        for (int i = 0; i < ptgs.length; ++i) {
            if (!Ptg.isDeletedCellRef(ptgs[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean isDeletedCellRef(Ptg ptg) {
        if (ptg == ErrPtg.REF_INVALID) {
            return true;
        }
        if (ptg instanceof DeletedArea3DPtg) {
            return true;
        }
        if (ptg instanceof DeletedRef3DPtg) {
            return true;
        }
        if (ptg instanceof AreaErrPtg) {
            return true;
        }
        return ptg instanceof RefErrorPtg;
    }

    public Ptg clone() throws CloneNotSupportedException {
        return (Ptg)super.clone();
    }
}

