/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.formula.ptg;

import java.util.Locale;
import org.zkoss.poi.ss.SpreadsheetVersion;
import org.zkoss.poi.ss.formula.ptg.ScalarConstantPtg;
import org.zkoss.poi.ss.util.NumberToTextConverter;
import org.zkoss.poi.ss.util.ToExcelNumberConverter;
import org.zkoss.poi.util.LittleEndianInput;
import org.zkoss.poi.util.LittleEndianOutput;

public final class NumberPtg
extends ScalarConstantPtg {
    public static final int SIZE = 9;
    public static final byte sid = 31;
    private final double field_1_value;

    public NumberPtg(LittleEndianInput in) {
        this(in.readDouble());
    }

    public NumberPtg(String value) {
        this(ToExcelNumberConverter.toExcelNumber(Double.parseDouble(value), false));
    }

    public NumberPtg(double value) {
        this.field_1_value = value;
    }

    public double getValue() {
        return this.field_1_value;
    }

    @Override
    public void write(LittleEndianOutput out) {
        out.writeByte(31 + this.getPtgClass());
        out.writeDouble(this.getValue());
    }

    @Override
    public void write(LittleEndianOutput out, SpreadsheetVersion version) {
        this.write(out);
    }

    @Override
    public int getSize() {
        return 9;
    }

    @Override
    public int getSize(SpreadsheetVersion version) {
        return this.getSize();
    }

    @Override
    public String toFormulaString() {
        return NumberToTextConverter.toText(this.field_1_value);
    }

    public String toInternalFormulaString() {
        return NumberToTextConverter.toText(this.field_1_value, Locale.US);
    }
}

