/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.formula.ptg;

import org.zkoss.poi.ss.SpreadsheetVersion;
import org.zkoss.poi.ss.formula.FormulaRenderingWorkbook;
import org.zkoss.poi.ss.formula.WorkbookDependentFormula;
import org.zkoss.poi.ss.formula.ptg.OperandPtg;
import org.zkoss.poi.util.LittleEndianInput;
import org.zkoss.poi.util.LittleEndianOutput;

public class NamePtg
extends OperandPtg
implements WorkbookDependentFormula {
    public static final short sid = 35;
    private static final int SIZE = 5;
    private int field_1_label_index;
    private short field_2_zero;
    private String namename;

    public NamePtg(int nameIndex) {
        this.field_1_label_index = 1 + nameIndex;
    }

    public NamePtg(LittleEndianInput in) {
        this.field_1_label_index = in.readShort();
        this.field_2_zero = in.readShort();
    }

    public int getIndex() {
        return this.field_1_label_index - 1;
    }

    @Override
    public void write(LittleEndianOutput out) {
        out.writeByte(35 + this.getPtgClass());
        out.writeShort(this.field_1_label_index);
        out.writeShort(this.field_2_zero);
    }

    @Override
    public void write(LittleEndianOutput out, SpreadsheetVersion version) {
        this.write(out);
    }

    @Override
    public int getSize() {
        return 5;
    }

    @Override
    public int getSize(SpreadsheetVersion version) {
        return this.getSize();
    }

    @Override
    public String toFormulaString(FormulaRenderingWorkbook book) {
        String name;
        this.namename = name = book.getNameText(this);
        return name != null && name.startsWith("_xlfn.") ? name.substring(6) : name;
    }

    @Override
    public String toFormulaString() {
        throw new RuntimeException("3D references need a workbook to determine formula text");
    }

    @Override
    public byte getDefaultOperandClass() {
        return 0;
    }

    @Override
    public String toInternalFormulaString(FormulaRenderingWorkbook book) {
        return this.toFormulaString(book);
    }

    public String getNameName() {
        return this.namename;
    }
}

