/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.formula.ptg;

import org.zkoss.poi.ss.SpreadsheetVersion;
import org.zkoss.poi.ss.formula.ptg.ValueOperatorPtg;
import org.zkoss.poi.util.LittleEndianInput;
import org.zkoss.poi.util.LittleEndianOutput;

public final class MultiplyPtg
extends ValueOperatorPtg {
    public static final byte sid = 5;
    private boolean _operator = false;

    public MultiplyPtg() {
    }

    public MultiplyPtg(LittleEndianInput in, SpreadsheetVersion version) {
        if (version == SpreadsheetVersion.EXCEL2007) {
            this._operator = in.readByte() == 1;
        }
    }

    @Override
    protected byte getSid() {
        return 5;
    }

    @Override
    public int getSize(SpreadsheetVersion version) {
        int size = this.getSize();
        if (version == SpreadsheetVersion.EXCEL2007) {
            ++size;
        }
        return size;
    }

    @Override
    public void write(LittleEndianOutput out, SpreadsheetVersion version) {
        out.writeByte(this.getSid());
        if (version == SpreadsheetVersion.EXCEL2007) {
            out.writeByte(this._operator ? 1 : 0);
        }
    }

    @Override
    public int getNumberOfOperands() {
        return 2;
    }

    @Override
    public String toFormulaString(String[] operands) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(operands[0]);
        buffer.append("*");
        buffer.append(operands[1]);
        return buffer.toString();
    }

    public void setOperator(boolean b) {
        this._operator = b;
    }

    public boolean isOperator() {
        return this._operator;
    }
}

