/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.formula.ptg;

import org.zkoss.poi.ss.SpreadsheetVersion;
import org.zkoss.poi.ss.formula.ptg.ScalarConstantPtg;
import org.zkoss.poi.util.LittleEndianInput;
import org.zkoss.poi.util.LittleEndianOutput;

public final class IntPtg
extends ScalarConstantPtg {
    private static final int MIN_VALUE = 0;
    private static final int MAX_VALUE = 65535;
    public static final int SIZE = 3;
    public static final byte sid = 30;
    private final int field_1_value;

    public static boolean isInRange(int i) {
        return i >= 0 && i <= 65535;
    }

    public IntPtg(LittleEndianInput in) {
        this(in.readUShort());
    }

    public IntPtg(int value) {
        if (!IntPtg.isInRange(value)) {
            throw new IllegalArgumentException("value is out of range: " + value);
        }
        this.field_1_value = value;
    }

    public int getValue() {
        return this.field_1_value;
    }

    @Override
    public void write(LittleEndianOutput out) {
        out.writeByte(30 + this.getPtgClass());
        out.writeShort(this.getValue());
    }

    @Override
    public void write(LittleEndianOutput out, SpreadsheetVersion version) {
        this.write(out);
    }

    @Override
    public int getSize() {
        return 3;
    }

    @Override
    public int getSize(SpreadsheetVersion version) {
        return this.getSize();
    }

    @Override
    public String toFormulaString() {
        return String.valueOf(this.getValue());
    }
}

