/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.formula.ptg;

import org.zkoss.poi.ss.SpreadsheetVersion;
import org.zkoss.poi.ss.formula.ptg.AreaPtgBase;
import org.zkoss.poi.ss.util.AreaReference;
import org.zkoss.poi.util.LittleEndianInput;
import org.zkoss.poi.util.LittleEndianOutput;

public abstract class Area2DPtgBase
extends AreaPtgBase {
    private static final int SIZE = 9;
    private static final int SIZE_2007 = 13;

    protected Area2DPtgBase(int firstRow, int lastRow, int firstColumn, int lastColumn, boolean firstRowRelative, boolean lastRowRelative, boolean firstColRelative, boolean lastColRelative) {
        super(firstRow, lastRow, firstColumn, lastColumn, firstRowRelative, lastRowRelative, firstColRelative, lastColRelative);
    }

    protected Area2DPtgBase(AreaReference ar) {
        super(ar);
    }

    protected Area2DPtgBase(LittleEndianInput in, SpreadsheetVersion version) {
        this.readCoordinates(in, version);
    }

    protected abstract byte getSid();

    @Override
    public final void write(LittleEndianOutput out) {
        this.write(out, SpreadsheetVersion.EXCEL97);
    }

    @Override
    public void write(LittleEndianOutput out, SpreadsheetVersion version) {
        out.writeByte(this.getSid() + this.getPtgClass());
        this.writeCoordinates(out, version);
    }

    @Override
    public final int getSize() {
        return 9;
    }

    @Override
    public final int getSize(SpreadsheetVersion version) {
        return version == SpreadsheetVersion.EXCEL2007 ? 13 : 9;
    }

    @Override
    public final String toFormulaString() {
        return this.formatReferenceAsString();
    }

    @Override
    public final String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append(" [");
        sb.append(this.formatReferenceAsString());
        sb.append("]");
        return sb.toString();
    }
}

