/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.formula.functions;

import org.zkoss.poi.ss.formula.OperationEvaluationContext;
import org.zkoss.poi.ss.formula.eval.AreaEval;
import org.zkoss.poi.ss.formula.eval.CellValueEval;
import org.zkoss.poi.ss.formula.eval.ErrorEval;
import org.zkoss.poi.ss.formula.eval.EvaluationException;
import org.zkoss.poi.ss.formula.eval.NumberEval;
import org.zkoss.poi.ss.formula.eval.RefEval;
import org.zkoss.poi.ss.formula.eval.ValueEval;
import org.zkoss.poi.ss.formula.eval.ValuesEval;
import org.zkoss.poi.ss.formula.functions.CountUtils;
import org.zkoss.poi.ss.formula.functions.Countif;
import org.zkoss.poi.ss.formula.functions.FreeRefFunction;

public final class Sumifs
implements FreeRefFunction {
    public static final FreeRefFunction instance = new Sumifs();

    @Override
    public ValueEval evaluate(ValueEval[] args, OperationEvaluationContext ec) {
        if (args.length < 3 || args.length % 2 == 0) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            AreaEval sumRange = Sumifs.convertRangeArg(args[0]);
            AreaEval[] ae = new AreaEval[(args.length - 1) / 2];
            CountUtils.I_MatchPredicate[] mp = new CountUtils.I_MatchPredicate[ae.length];
            int i = 1;
            int k = 0;
            while (i < args.length) {
                ae[k] = Sumifs.convertRangeArg(args[i]);
                mp[k] = Countif.createCriteriaPredicate(args[i + 1], ec.getRowIndex(), ec.getColumnIndex());
                i += 2;
                ++k;
            }
            this.validateCriteriaRanges(ae, sumRange);
            double result = Sumifs.sumMatchingCells(ae, mp, sumRange);
            return new NumberEval(result);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
    }

    private void validateCriteriaRanges(AreaEval[] criteriaRanges, AreaEval sumRange) throws EvaluationException {
        for (AreaEval r : criteriaRanges) {
            if (r.getHeight() == sumRange.getHeight() && r.getWidth() == sumRange.getWidth()) continue;
            throw EvaluationException.invalidValue();
        }
    }

    private static double sumMatchingCells(AreaEval[] ranges, CountUtils.I_MatchPredicate[] predicates, AreaEval aeSum) {
        ValueEval sumEval = aeSum.getNonEmptyCellValues();
        int firstRow = aeSum.getFirstRow();
        int firstColumn = aeSum.getFirstColumn();
        double result = 0.0;
        if (sumEval instanceof ValuesEval) {
            ValueEval[] sumEvals = ((ValuesEval)sumEval).getValueEvals();
            for (int i = 0; i < sumEvals.length; ++i) {
                ValueEval eval = sumEvals[i];
                if (!(eval instanceof CellValueEval)) continue;
                CellValueEval v = (CellValueEval)eval;
                int r = v.getRowIndex() - firstRow;
                int c = v.getColumnIndex() - firstColumn;
                boolean matches = true;
                for (int j = 0; j < ranges.length; ++j) {
                    CountUtils.I_MatchPredicate mp = predicates[j];
                    AreaEval aeRange = ranges[j];
                    if (mp.matches(aeRange.getRelativeValue(r, c))) continue;
                    matches = false;
                    break;
                }
                if (!matches) continue;
                result += Sumifs.accumulate(v.getInnerValueEval());
            }
        }
        return result;
    }

    private static double accumulate(ValueEval addend) {
        if (addend instanceof NumberEval) {
            return ((NumberEval)addend).getNumberValue();
        }
        return 0.0;
    }

    private static AreaEval convertRangeArg(ValueEval eval) throws EvaluationException {
        if (eval instanceof AreaEval) {
            return (AreaEval)eval;
        }
        if (eval instanceof RefEval) {
            return ((RefEval)eval).offset(0, 0, 0, 0);
        }
        throw new EvaluationException(ErrorEval.VALUE_INVALID);
    }
}

