/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.formula.functions;

import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.zkoss.lang.Classes;
import org.zkoss.poi.ss.formula.eval.ErrorEval;
import org.zkoss.poi.ss.formula.eval.NotImplementedException;
import org.zkoss.poi.ss.formula.eval.ValueEval;
import org.zkoss.poi.ss.formula.functions.Function;

public class OverridableFunction
implements Function {
    private final String _functionName;
    private final Function _original;
    private Function _func;
    private static Class _funcClass;
    private static String _funcClassName;
    private static String _zssFuncClassName;
    private static String _hasFuncName;
    private static java.util.function.Function _lambdaMetafactoryFunc;

    public OverridableFunction(String name, Function original) {
        this._functionName = name;
        this._original = original;
        if (_funcClass != null) {
            try {
                this._func = (Function)_funcClass.getConstructor(String.class).newInstance(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public ValueEval evaluate(ValueEval[] args, int srcRowIndex, int srcColumnIndex) {
        if (this._func != null && this.hasFunction(this._func)) {
            return this._func.evaluate(args, srcRowIndex, srcColumnIndex);
        }
        try {
            return this._original.evaluate(args, srcRowIndex, srcColumnIndex);
        }
        catch (NotImplementedException x) {
            return ErrorEval.NAME_INVALID;
        }
    }

    private boolean hasFunction(Function fn) {
        try {
            return (Boolean)_lambdaMetafactoryFunc.apply(fn);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public String getFunctionName() {
        return this._functionName;
    }

    static {
        _funcClassName = "io.keikaiex.formula.ELEvalFunction";
        _zssFuncClassName = "org.zkoss.zssex.formula.ELEvalFunction";
        _hasFuncName = "hasFunction";
        try {
            _funcClass = Classes.existsByThread((String)_funcClassName) ? Class.forName(_funcClassName) : Class.forName(_zssFuncClassName);
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            CallSite site = LambdaMetafactory.metafactory(lookup, "apply", MethodType.methodType(java.util.function.Function.class), MethodType.methodType(Object.class, Object.class), lookup.findVirtual(_funcClass, _hasFuncName, MethodType.methodType(Boolean.TYPE)), MethodType.methodType(Boolean.TYPE, _funcClass));
            _lambdaMetafactoryFunc = site.getTarget().invokeExact();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

