/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.formula.functions;

import org.zkoss.poi.ss.formula.LazyAreaEval;
import org.zkoss.poi.ss.formula.TwoDEval;
import org.zkoss.poi.ss.formula.eval.ArrayEval;
import org.zkoss.poi.ss.formula.eval.BlankEval;
import org.zkoss.poi.ss.formula.eval.BoolEval;
import org.zkoss.poi.ss.formula.eval.CellValueEval;
import org.zkoss.poi.ss.formula.eval.ErrorEval;
import org.zkoss.poi.ss.formula.eval.EvaluationException;
import org.zkoss.poi.ss.formula.eval.NumberEval;
import org.zkoss.poi.ss.formula.eval.OperandResolver;
import org.zkoss.poi.ss.formula.eval.RefEval;
import org.zkoss.poi.ss.formula.eval.StringEval;
import org.zkoss.poi.ss.formula.eval.ValueEval;
import org.zkoss.poi.ss.formula.eval.ValuesEval;
import org.zkoss.poi.ss.formula.functions.Function;

public abstract class MultiOperandNumericFunction
implements Function {
    private final boolean _isReferenceBoolCounted;
    private final boolean _isBlankCounted;
    private final boolean _isFilterCounted;
    static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    private static final int DEFAULT_MAX_NUM_OPERANDS = 30;

    protected MultiOperandNumericFunction(boolean isReferenceBoolCounted, boolean isBlankCounted) {
        this(isReferenceBoolCounted, isBlankCounted, false);
    }

    protected MultiOperandNumericFunction(boolean isReferenceBoolCounted, boolean isBlankCounted, boolean isFilterCounted) {
        this._isReferenceBoolCounted = isReferenceBoolCounted;
        this._isBlankCounted = isBlankCounted;
        this._isFilterCounted = isFilterCounted;
    }

    @Override
    public final ValueEval evaluate(ValueEval[] args, int srcCellRow, int srcCellCol) {
        double d;
        try {
            double[] values = this.getNumberArray(args);
            d = this.evaluate(values);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return ErrorEval.NUM_ERROR;
        }
        return new NumberEval(d);
    }

    protected abstract double evaluate(double[] var1) throws EvaluationException;

    protected int getMaxNumOperands() {
        return 30;
    }

    protected final double[] getNumberArray(ValueEval[] operands) throws EvaluationException {
        if (operands.length > this.getMaxNumOperands()) {
            throw EvaluationException.invalidValue();
        }
        DoubleList retval = new DoubleList();
        int iSize = operands.length;
        for (int i = 0; i < iSize; ++i) {
            this.collectValues(operands[i], retval);
        }
        return retval.toArray();
    }

    public boolean isSubtotalCounted() {
        return true;
    }

    private void collectValues(ValueEval operand, DoubleList temp) throws EvaluationException {
        if (operand instanceof ValuesEval) {
            ValueEval[] ves;
            for (ValueEval ve : ves = ((ValuesEval)operand).getValueEvals()) {
                this.collectValues(ve, temp);
            }
            return;
        }
        if (operand instanceof TwoDEval) {
            TwoDEval ae = (TwoDEval)operand;
            int width = ae.getWidth();
            int height = ae.getHeight();
            boolean isFiltered = ae.isFiltered();
            if (this._isBlankCounted) {
                for (int rrIx = 0; rrIx < height; ++rrIx) {
                    for (int rcIx = 0; rcIx < width; ++rcIx) {
                        ValueEval ve = ae.getValue(rrIx, rcIx);
                        if (!this.isSubtotalCounted() && ae.isSubTotal(rrIx, rcIx) || (!this.isHiddenCounted() || isFiltered) && ae.isRowHidden(rrIx)) continue;
                        this.collectValue(ve, true, temp);
                    }
                }
            } else {
                ValueEval valueEval;
                int rowStart = 0;
                int colStart = 0;
                if (ae instanceof LazyAreaEval) {
                    rowStart = ((LazyAreaEval)ae).getFirstRow();
                    colStart = ((LazyAreaEval)ae).getFirstColumn();
                }
                if ((valueEval = ae.getNonEmptyCellValues()) instanceof ValuesEval) {
                    ValueEval[] valueEvals;
                    for (ValueEval eval : valueEvals = ((ValuesEval)valueEval).getValueEvals()) {
                        ValueEval[] valueEvals0;
                        if (eval instanceof CellValueEval) {
                            CellValueEval cve = (CellValueEval)eval;
                            int ri = cve.getRowIndex() - rowStart;
                            int ci = cve.getColumnIndex() - colStart;
                            if (!this.isSubtotalCounted() && ae.isSubTotal(ri, ci) || (!this.isHiddenCounted() || isFiltered) && !this._isFilterCounted && ae.isRowHidden(ri)) continue;
                            this.collectValue(cve.getInnerValueEval(), true, temp);
                            continue;
                        }
                        if (!(eval instanceof ValuesEval)) continue;
                        for (ValueEval eval0 : valueEvals0 = ((ValuesEval)eval).getValueEvals()) {
                            if (!(eval0 instanceof CellValueEval)) continue;
                            CellValueEval cve = (CellValueEval)eval0;
                            int ri = cve.getRowIndex() - rowStart;
                            int ci = cve.getColumnIndex() - colStart;
                            if (!this.isSubtotalCounted() && ae.isSubTotal(ri, ci) || (!this.isHiddenCounted() || isFiltered) && ae.isRowHidden(ri)) continue;
                            this.collectValue(cve.getInnerValueEval(), true, temp);
                        }
                    }
                } else {
                    this.collectValue(valueEval, true, temp);
                }
            }
            return;
        }
        if (operand instanceof RefEval) {
            RefEval re = (RefEval)operand;
            if ((!this.isHiddenCounted() || re.isFiltered()) && re.isRowHidden()) {
                return;
            }
            this.collectValue(re.getInnerValueEval(), true, temp);
            return;
        }
        this.collectValue(operand, false, temp);
    }

    private void collectValue(ValueEval ve, boolean isViaReference, DoubleList temp) throws EvaluationException {
        if (ve == null) {
            throw new IllegalArgumentException("ve must not be null");
        }
        if (ve instanceof NumberEval) {
            NumberEval ne = (NumberEval)ve;
            temp.add(ne.getNumberValue());
            return;
        }
        if (ve instanceof ErrorEval) {
            throw new EvaluationException((ErrorEval)ve);
        }
        if (ve instanceof StringEval) {
            if (isViaReference) {
                return;
            }
            String s = ((StringEval)ve).getStringValue();
            Double d = OperandResolver.parseDouble(s);
            if (d == null) {
                throw new EvaluationException(ErrorEval.VALUE_INVALID);
            }
            temp.add(d);
            return;
        }
        if (ve instanceof BoolEval) {
            if (!isViaReference || this._isReferenceBoolCounted) {
                BoolEval boolEval = (BoolEval)ve;
                temp.add(boolEval.getNumberValue());
            }
            return;
        }
        if (ve == BlankEval.instance) {
            if (this._isBlankCounted) {
                temp.add(0.0);
            }
            return;
        }
        if (ve instanceof ValuesEval) {
            ValueEval[] ves;
            for (ValueEval xve : ves = ((ValuesEval)ve).getValueEvals()) {
                this.collectValue(xve, isViaReference, temp);
            }
            return;
        }
        if (ve instanceof ArrayEval) {
            ArrayEval ae = (ArrayEval)ve;
            int rows = ae.getHeight();
            int cols = ae.getWidth();
            for (int r = 0; r < rows; ++r) {
                for (int c = 0; c < cols; ++c) {
                    if (!this.isHiddenCounted() && ae.isHidden(r, c)) continue;
                    this.collectValue(ae.getValue(r, c), isViaReference, temp);
                }
            }
            return;
        }
        throw new RuntimeException("Invalid ValueEval type passed for conversion: (" + ve.getClass() + ")");
    }

    public boolean isHiddenCounted() {
        return true;
    }

    private static class DoubleList {
        private double[] _array = new double[8];
        private int _count = 0;

        public double[] toArray() {
            if (this._count < 1) {
                return EMPTY_DOUBLE_ARRAY;
            }
            double[] result = new double[this._count];
            System.arraycopy(this._array, 0, result, 0, this._count);
            return result;
        }

        private void ensureCapacity(int reqSize) {
            if (reqSize > this._array.length) {
                int newSize = reqSize * 3 / 2;
                double[] newArr = new double[newSize];
                System.arraycopy(this._array, 0, newArr, 0, this._count);
                this._array = newArr;
            }
        }

        public void add(double value) {
            this.ensureCapacity(this._count + 1);
            this._array[this._count] = value;
            ++this._count;
        }
    }
}

