/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.formula.function;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.zkoss.poi.ss.formula.function.FunctionInfo;

public class FunctionMetaInfo {
    private static final Map<String, Integer> _map = new HashMap<String, Integer>(501);
    private static List<FunctionInfo> _infoCache = new ArrayList<FunctionInfo>(501);

    public static FunctionInfo getInfo(String funcName) {
        Integer sid = _map.get(funcName.toUpperCase());
        if (sid != null) {
            return FunctionMetaInfo._get(sid);
        }
        System.out.println("Unknown function info: [" + funcName + ']');
        return null;
    }

    private static FunctionInfo _get(int sid) {
        if (sid < _infoCache.size()) {
            if (_infoCache.get(sid) == null) {
                _infoCache.set(sid, FunctionMetaInfo._init(sid));
            }
            return _infoCache.get(sid);
        }
        return null;
    }

    private static FunctionInfo _init(int sid) {
        switch (sid) {
            case 0: {
                return new FunctionInfo("COUNT", 1, 255, 0);
            }
            case 1: {
                return new FunctionInfo("IF", 2, 3, 1);
            }
            case 2: {
                return new FunctionInfo("ISNA", 1, 1, 2);
            }
            case 3: {
                return new FunctionInfo("ISERROR", 1, 1, 3);
            }
            case 4: {
                return new FunctionInfo("SUM", 1, 255, 4);
            }
            case 5: {
                return new FunctionInfo("AVERAGE", 1, 255, 5);
            }
            case 6: {
                return new FunctionInfo("MIN", 1, 255, 6);
            }
            case 7: {
                return new FunctionInfo("MAX", 1, 255, 7);
            }
            case 8: {
                return new FunctionInfo("ROW", 0, 1, 8);
            }
            case 9: {
                return new FunctionInfo("COLUMN", 0, 1, 9);
            }
            case 10: {
                return new FunctionInfo("NA", 0, 0, 10);
            }
            case 11: {
                return new FunctionInfo("NPV", 2, 255, 11);
            }
            case 12: {
                return new FunctionInfo("STDEV", 1, 255, 12);
            }
            case 13: {
                return new FunctionInfo("DOLLAR", 1, 2, 13);
            }
            case 14: {
                return new FunctionInfo("FIXED", 1, 3, 14);
            }
            case 15: {
                return new FunctionInfo("SIN", 1, 1, 15);
            }
            case 16: {
                return new FunctionInfo("COS", 1, 1, 16);
            }
            case 17: {
                return new FunctionInfo("TAN", 1, 1, 17);
            }
            case 18: {
                return new FunctionInfo("ATAN", 1, 1, 18);
            }
            case 19: {
                return new FunctionInfo("PI", 0, 0, 19);
            }
            case 20: {
                return new FunctionInfo("SQRT", 1, 1, 20);
            }
            case 21: {
                return new FunctionInfo("EXP", 1, 1, 21);
            }
            case 22: {
                return new FunctionInfo("LN", 1, 1, 22);
            }
            case 23: {
                return new FunctionInfo("LOG10", 1, 1, 23);
            }
            case 24: {
                return new FunctionInfo("ABS", 1, 1, 24);
            }
            case 25: {
                return new FunctionInfo("INT", 1, 1, 25);
            }
            case 26: {
                return new FunctionInfo("SIGN", 1, 1, 26);
            }
            case 27: {
                return new FunctionInfo("ROUND", 2, 2, 27);
            }
            case 28: {
                return new FunctionInfo("LOOKUP", 2, 3, 28);
            }
            case 29: {
                return new FunctionInfo("INDEX", 2, 4, 29);
            }
            case 30: {
                return new FunctionInfo("REPT", 2, 2, 30);
            }
            case 31: {
                return new FunctionInfo("MID", 3, 3, 31);
            }
            case 32: {
                return new FunctionInfo("LEN", 1, 1, 32);
            }
            case 33: {
                return new FunctionInfo("VALUE", 1, 1, 33);
            }
            case 34: {
                return new FunctionInfo("TRUE", 0, 0, 34);
            }
            case 35: {
                return new FunctionInfo("FALSE", 0, 0, 35);
            }
            case 36: {
                return new FunctionInfo("AND", 1, 255, 36);
            }
            case 37: {
                return new FunctionInfo("OR", 1, 255, 37);
            }
            case 38: {
                return new FunctionInfo("NOT", 1, 1, 38);
            }
            case 39: {
                return new FunctionInfo("MOD", 2, 2, 39);
            }
            case 40: {
                return new FunctionInfo("DCOUNT", 3, 3, 40);
            }
            case 41: {
                return new FunctionInfo("DSUM", 3, 3, 41);
            }
            case 42: {
                return new FunctionInfo("DAVERAGE", 3, 3, 42);
            }
            case 43: {
                return new FunctionInfo("DMIN", 3, 3, 43);
            }
            case 44: {
                return new FunctionInfo("DMAX", 3, 3, 44);
            }
            case 45: {
                return new FunctionInfo("DSTDEV", 3, 3, 45);
            }
            case 46: {
                return new FunctionInfo("VAR", 1, 255, 46);
            }
            case 47: {
                return new FunctionInfo("DVAR", 3, 3, 47);
            }
            case 48: {
                return new FunctionInfo("TEXT", 2, 2, 48);
            }
            case 49: {
                return new FunctionInfo("LINEST", 1, 4, 49);
            }
            case 50: {
                return new FunctionInfo("TREND", 1, 4, 50);
            }
            case 51: {
                return new FunctionInfo("LOGEST", 1, 4, 51);
            }
            case 52: {
                return new FunctionInfo("GROWTH", 1, 4, 52);
            }
            case 53: {
                return new FunctionInfo("TYPE", 1, 1, 53);
            }
            case 54: {
                return new FunctionInfo("HALT", 0, 1, 54);
            }
            case 55: {
                return new FunctionInfo("RETURN", 0, 1, 55);
            }
            case 56: {
                return new FunctionInfo("PV", 3, 5, 56);
            }
            case 57: {
                return new FunctionInfo("FV", 3, 5, 57);
            }
            case 58: {
                return new FunctionInfo("NPER", 3, 5, 58);
            }
            case 59: {
                return new FunctionInfo("PMT", 3, 5, 59);
            }
            case 60: {
                return new FunctionInfo("RATE", 3, 6, 60);
            }
            case 61: {
                return new FunctionInfo("MIRR", 3, 3, 61);
            }
            case 62: {
                return new FunctionInfo("IRR", 1, 2, 62);
            }
            case 63: {
                return new FunctionInfo("RAND", 0, 0, 63);
            }
            case 64: {
                return new FunctionInfo("MATCH", 2, 3, 64);
            }
            case 65: {
                return new FunctionInfo("DATE", 3, 3, 65);
            }
            case 66: {
                return new FunctionInfo("TIME", 3, 3, 66);
            }
            case 67: {
                return new FunctionInfo("DAY", 1, 1, 67);
            }
            case 68: {
                return new FunctionInfo("MONTH", 1, 1, 68);
            }
            case 69: {
                return new FunctionInfo("YEAR", 1, 1, 69);
            }
            case 70: {
                return new FunctionInfo("WEEKDAY", 1, 2, 70);
            }
            case 71: {
                return new FunctionInfo("HOUR", 1, 1, 71);
            }
            case 72: {
                return new FunctionInfo("MINUTE", 1, 1, 72);
            }
            case 73: {
                return new FunctionInfo("SECOND", 1, 1, 73);
            }
            case 74: {
                return new FunctionInfo("NOW", 0, 0, 74);
            }
            case 75: {
                return new FunctionInfo("AREAS", 1, 1, 75);
            }
            case 76: {
                return new FunctionInfo("ROWS", 1, 1, 76);
            }
            case 77: {
                return new FunctionInfo("COLUMNS", 1, 1, 77);
            }
            case 78: {
                return new FunctionInfo("OFFSET", 3, 5, 78);
            }
            case 79: {
                return new FunctionInfo("ABSREF", 2, 2, 79);
            }
            case 80: {
                return new FunctionInfo("RELREF", 2, 2, 80);
            }
            case 81: {
                return new FunctionInfo("ARGUMENT", 0, 3, 81);
            }
            case 82: {
                return new FunctionInfo("SEARCH", 2, 3, 82);
            }
            case 83: {
                return new FunctionInfo("TRANSPOSE", 1, 1, 83);
            }
            case 84: {
                return new FunctionInfo("ERROR", 0, 2, 84);
            }
            case 85: {
                return new FunctionInfo("STEP", 0, 0, 85);
            }
            case 86: {
                return new FunctionInfo("TYPE", 1, 1, 86);
            }
            case 87: {
                return new FunctionInfo("ECHO", 0, 1, 87);
            }
            case 88: {
                return new FunctionInfo("UNICHAR", 1, 1, 88);
            }
            case 89: {
                return new FunctionInfo("UNICODE", 1, 1, 89);
            }
            case 90: {
                return new FunctionInfo("SHEET", 0, 1, 90);
            }
            case 91: {
                return new FunctionInfo("SHEETS", 0, 1, 91);
            }
            case 92: {
                return new FunctionInfo("SEC", 1, 1, 92);
            }
            case 93: {
                return new FunctionInfo("SECH", 1, 1, 93);
            }
            case 94: {
                return new FunctionInfo("RTD", 2, 255, 94);
            }
            case 95: {
                return new FunctionInfo("RRI", 3, 3, 95);
            }
            case 97: {
                return new FunctionInfo("ATAN2", 2, 2, 97);
            }
            case 98: {
                return new FunctionInfo("ASIN", 1, 1, 98);
            }
            case 99: {
                return new FunctionInfo("ACOS", 1, 1, 99);
            }
            case 100: {
                return new FunctionInfo("CHOOSE", 2, 255, 100);
            }
            case 101: {
                return new FunctionInfo("HLOOKUP", 3, 4, 101);
            }
            case 102: {
                return new FunctionInfo("VLOOKUP", 3, 4, 102);
            }
            case 103: {
                return new FunctionInfo("WEBSERVICE", 1, 1, 103);
            }
            case 105: {
                return new FunctionInfo("ISREF", 1, 1, 105);
            }
            case 106: {
                return new FunctionInfo("PHI", 1, 1, 106);
            }
            case 107: {
                return new FunctionInfo("PERMUTATIONA", 2, 2, 107);
            }
            case 108: {
                return new FunctionInfo("PDURATION", 3, 3, 108);
            }
            case 109: {
                return new FunctionInfo("LOG", 1, 2, 109);
            }
            case 111: {
                return new FunctionInfo("CHAR", 1, 1, 111);
            }
            case 112: {
                return new FunctionInfo("LOWER", 1, 1, 112);
            }
            case 113: {
                return new FunctionInfo("UPPER", 1, 1, 113);
            }
            case 114: {
                return new FunctionInfo("PROPER", 1, 1, 114);
            }
            case 115: {
                return new FunctionInfo("LEFT", 1, 2, 115);
            }
            case 116: {
                return new FunctionInfo("RIGHT", 1, 2, 116);
            }
            case 117: {
                return new FunctionInfo("EXACT", 2, 2, 117);
            }
            case 118: {
                return new FunctionInfo("TRIM", 1, 1, 118);
            }
            case 119: {
                return new FunctionInfo("REPLACE", 4, 4, 119);
            }
            case 120: {
                return new FunctionInfo("SUBSTITUTE", 3, 4, 120);
            }
            case 121: {
                return new FunctionInfo("CODE", 1, 1, 121);
            }
            case 122: {
                return new FunctionInfo("NUMBERVALUE", 1, 2, 122);
            }
            case 123: {
                return new FunctionInfo("MUNIT", 1, 1, 123);
            }
            case 124: {
                return new FunctionInfo("FIND", 2, 3, 124);
            }
            case 125: {
                return new FunctionInfo("CELL", 1, 2, 125);
            }
            case 126: {
                return new FunctionInfo("ISERR", 1, 1, 126);
            }
            case 127: {
                return new FunctionInfo("ISTEXT", 1, 1, 127);
            }
            case 128: {
                return new FunctionInfo("ISNUMBER", 1, 1, 128);
            }
            case 129: {
                return new FunctionInfo("ISBLANK", 1, 1, 129);
            }
            case 130: {
                return new FunctionInfo("T", 1, 1, 130);
            }
            case 131: {
                return new FunctionInfo("N", 1, 1, 131);
            }
            case 132: {
                return new FunctionInfo("IMTAN", 1, 1, 132);
            }
            case 133: {
                return new FunctionInfo("IMSINH", 1, 1, 133);
            }
            case 134: {
                return new FunctionInfo("IMSECH", 1, 1, 134);
            }
            case 135: {
                return new FunctionInfo("IMSEC", 1, 1, 135);
            }
            case 136: {
                return new FunctionInfo("IMCSCH", 1, 1, 136);
            }
            case 137: {
                return new FunctionInfo("IMCSC", 1, 1, 137);
            }
            case 138: {
                return new FunctionInfo("IMCOT", 1, 1, 138);
            }
            case 139: {
                return new FunctionInfo("IMCOSH", 1, 1, 139);
            }
            case 140: {
                return new FunctionInfo("DATEVALUE", 1, 1, 140);
            }
            case 141: {
                return new FunctionInfo("TIMEVALUE", 1, 1, 141);
            }
            case 142: {
                return new FunctionInfo("SLN", 3, 3, 142);
            }
            case 143: {
                return new FunctionInfo("SYD", 4, 4, 143);
            }
            case 144: {
                return new FunctionInfo("DDB", 4, 5, 144);
            }
            case 145: {
                return new FunctionInfo("GAUSS", 1, 1, 145);
            }
            case 146: {
                return new FunctionInfo("GAMMA", 1, 1, 146);
            }
            case 148: {
                return new FunctionInfo("INDIRECT", 1, 2, 148);
            }
            case 149: {
                return new FunctionInfo("ISO.CEILING", 1, 2, 149);
            }
            case 150: {
                return new FunctionInfo("FORECAST.LINEAR", 3, 3, 150);
            }
            case 151: {
                return new FunctionInfo("FORECAST.ETS.STAT", 3, 6, 151);
            }
            case 152: {
                return new FunctionInfo("FORECAST.ETS.SEASONALITY", 2, 4, 152);
            }
            case 153: {
                return new FunctionInfo("FORECAST.ETS.CONFINT", 3, 7, 153);
            }
            case 154: {
                return new FunctionInfo("FLOOR.PRECISE", 1, 2, 154);
            }
            case 155: {
                return new FunctionInfo("FLOOR.MATH", 1, 3, 155);
            }
            case 156: {
                return new FunctionInfo("FILTERXML", 2, 2, 156);
            }
            case 157: {
                return new FunctionInfo("ERFC.PRECISE", 1, 1, 157);
            }
            case 158: {
                return new FunctionInfo("ERF.PRECISE", 1, 1, 158);
            }
            case 159: {
                return new FunctionInfo("ENCODEURL", 1, 1, 159);
            }
            case 160: {
                return new FunctionInfo("DECIMAL", 2, 2, 160);
            }
            case 161: {
                return new FunctionInfo("CSCH", 1, 1, 161);
            }
            case 162: {
                return new FunctionInfo("CLEAN", 1, 1, 162);
            }
            case 163: {
                return new FunctionInfo("MDETERM", 1, 1, 163);
            }
            case 164: {
                return new FunctionInfo("MINVERSE", 1, 1, 164);
            }
            case 165: {
                return new FunctionInfo("MMULT", 2, 2, 165);
            }
            case 166: {
                return new FunctionInfo("CSC", 1, 1, 166);
            }
            case 167: {
                return new FunctionInfo("IPMT", 4, 6, 167);
            }
            case 168: {
                return new FunctionInfo("PPMT", 4, 6, 168);
            }
            case 169: {
                return new FunctionInfo("COUNTA", 1, 255, 169);
            }
            case 170: {
                return new FunctionInfo("CANCEL.KEY", 1, 2, 170);
            }
            case 171: {
                return new FunctionInfo("FOR", 3, 4, 171);
            }
            case 172: {
                return new FunctionInfo("WHILE", 1, 1, 172);
            }
            case 173: {
                return new FunctionInfo("BREAK", 0, 0, 173);
            }
            case 174: {
                return new FunctionInfo("NEXT", 0, 0, 174);
            }
            case 175: {
                return new FunctionInfo("INITIATE", 2, 2, 175);
            }
            case 176: {
                return new FunctionInfo("REQUEST", 2, 2, 176);
            }
            case 177: {
                return new FunctionInfo("POKE", 1, 2, 177);
            }
            case 178: {
                return new FunctionInfo("EXECUTE", 2, 2, 178);
            }
            case 179: {
                return new FunctionInfo("TERMINATE", 1, 1, 179);
            }
            case 180: {
                return new FunctionInfo("RESTART", 0, 1, 180);
            }
            case 181: {
                return new FunctionInfo("HELP", 0, 1, 181);
            }
            case 182: {
                return new FunctionInfo("GET.BAR", 4, 4, 182);
            }
            case 183: {
                return new FunctionInfo("PRODUCT", 1, 255, 183);
            }
            case 184: {
                return new FunctionInfo("FACT", 1, 1, 184);
            }
            case 185: {
                return new FunctionInfo("GET.CELL", 1, 2, 185);
            }
            case 186: {
                return new FunctionInfo("GET.WORKSPACE", 1, 1, 186);
            }
            case 187: {
                return new FunctionInfo("GET.WINDOW", 1, 2, 187);
            }
            case 188: {
                return new FunctionInfo("GET.DOCUMENT", 1, 2, 188);
            }
            case 189: {
                return new FunctionInfo("DPRODUCT", 3, 3, 189);
            }
            case 190: {
                return new FunctionInfo("ISNONTEXT", 1, 1, 190);
            }
            case 191: {
                return new FunctionInfo("GET.NOTE", 1, 1, 191);
            }
            case 192: {
                return new FunctionInfo("NOTE", 1, 1, 192);
            }
            case 193: {
                return new FunctionInfo("STDEVP", 1, 255, 193);
            }
            case 194: {
                return new FunctionInfo("VARP", 1, 255, 194);
            }
            case 195: {
                return new FunctionInfo("DSTDEVP", 3, 3, 195);
            }
            case 196: {
                return new FunctionInfo("DVARP", 3, 3, 196);
            }
            case 197: {
                return new FunctionInfo("TRUNC", 1, 2, 197);
            }
            case 198: {
                return new FunctionInfo("ISLOGICAL", 1, 1, 198);
            }
            case 199: {
                return new FunctionInfo("DCOUNTA", 3, 3, 199);
            }
            case 200: {
                return new FunctionInfo("COTH", 1, 1, 200);
            }
            case 201: {
                return new FunctionInfo("COT", 1, 1, 201);
            }
            case 202: {
                return new FunctionInfo("COMBINA", 2, 2, 202);
            }
            case 203: {
                return new FunctionInfo("BINOM.DIST.RANGE", 3, 4, 203);
            }
            case 204: {
                return new FunctionInfo("USDOLLAR", 1, 2, 204);
            }
            case 205: {
                return new FunctionInfo("FINDB", 2, 3, 205);
            }
            case 206: {
                return new FunctionInfo("SEARCHB", 2, 3, 206);
            }
            case 207: {
                return new FunctionInfo("REPLACEB", 4, 4, 207);
            }
            case 208: {
                return new FunctionInfo("LEFTB", 1, 2, 208);
            }
            case 209: {
                return new FunctionInfo("RIGHTB", 1, 2, 209);
            }
            case 210: {
                return new FunctionInfo("MIDB", 3, 3, 210);
            }
            case 211: {
                return new FunctionInfo("LENB", 1, 1, 211);
            }
            case 212: {
                return new FunctionInfo("ROUNDUP", 2, 2, 212);
            }
            case 213: {
                return new FunctionInfo("ROUNDDOWN", 2, 2, 213);
            }
            case 214: {
                return new FunctionInfo("ASC", 1, 1, 214);
            }
            case 215: {
                return new FunctionInfo("DBCS", 1, 1, 215);
            }
            case 216: {
                return new FunctionInfo("RANK", 2, 3, 216);
            }
            case 219: {
                return new FunctionInfo("ADDRESS", 2, 5, 219);
            }
            case 220: {
                return new FunctionInfo("DAYS360", 2, 3, 220);
            }
            case 221: {
                return new FunctionInfo("TODAY", 0, 0, 221);
            }
            case 222: {
                return new FunctionInfo("VDB", 5, 7, 222);
            }
            case 227: {
                return new FunctionInfo("MEDIAN", 1, 255, 227);
            }
            case 228: {
                return new FunctionInfo("SUMPRODUCT", 1, 255, 228);
            }
            case 229: {
                return new FunctionInfo("SINH", 1, 1, 229);
            }
            case 230: {
                return new FunctionInfo("COSH", 1, 1, 230);
            }
            case 231: {
                return new FunctionInfo("TANH", 1, 1, 231);
            }
            case 232: {
                return new FunctionInfo("ASINH", 1, 1, 232);
            }
            case 233: {
                return new FunctionInfo("ACOSH", 1, 1, 233);
            }
            case 234: {
                return new FunctionInfo("ATANH", 1, 1, 234);
            }
            case 235: {
                return new FunctionInfo("DGET", 3, 3, 235);
            }
            case 236: {
                return new FunctionInfo("BASE", 2, 3, 236);
            }
            case 237: {
                return new FunctionInfo("BAHTTEXT", 1, 1, 237);
            }
            case 238: {
                return new FunctionInfo("ARABIC", 1, 1, 238);
            }
            case 239: {
                return new FunctionInfo("ACOTH", 1, 1, 239);
            }
            case 240: {
                return new FunctionInfo("ACOT", 1, 1, 240);
            }
            case 244: {
                return new FunctionInfo("INFO", 1, 1, 244);
            }
            case 247: {
                return new FunctionInfo("DB", 4, 5, 247);
            }
            case 252: {
                return new FunctionInfo("FREQUENCY", 2, 2, 252);
            }
            case 261: {
                return new FunctionInfo("ERROR.TYPE", 1, 1, 261);
            }
            case 268: {
                return new FunctionInfo("GET.WORKBOOK", 1, 2, 268);
            }
            case 269: {
                return new FunctionInfo("AVEDEV", 1, 255, 269);
            }
            case 270: {
                return new FunctionInfo("BETADIST", 3, 5, 270);
            }
            case 271: {
                return new FunctionInfo("GAMMALN", 1, 1, 271);
            }
            case 272: {
                return new FunctionInfo("BETAINV", 3, 5, 272);
            }
            case 273: {
                return new FunctionInfo("BINOMDIST", 4, 4, 273);
            }
            case 274: {
                return new FunctionInfo("CHIDIST", 2, 2, 274);
            }
            case 275: {
                return new FunctionInfo("CHIINV", 2, 2, 275);
            }
            case 276: {
                return new FunctionInfo("COMBIN", 2, 2, 276);
            }
            case 277: {
                return new FunctionInfo("CONFIDENCE", 3, 3, 277);
            }
            case 278: {
                return new FunctionInfo("CRITBINOM", 3, 3, 278);
            }
            case 279: {
                return new FunctionInfo("EVEN", 1, 1, 279);
            }
            case 280: {
                return new FunctionInfo("EXPONDIST", 3, 3, 280);
            }
            case 281: {
                return new FunctionInfo("FDIST", 3, 3, 281);
            }
            case 282: {
                return new FunctionInfo("FINV", 3, 3, 282);
            }
            case 283: {
                return new FunctionInfo("FISHER", 1, 1, 283);
            }
            case 284: {
                return new FunctionInfo("FISHERINV", 1, 1, 284);
            }
            case 285: {
                return new FunctionInfo("FLOOR", 2, 2, 285);
            }
            case 286: {
                return new FunctionInfo("GAMMADIST", 4, 4, 286);
            }
            case 287: {
                return new FunctionInfo("GAMMAINV", 3, 3, 287);
            }
            case 288: {
                return new FunctionInfo("CEILING", 2, 2, 288);
            }
            case 289: {
                return new FunctionInfo("HYPGEOMDIST", 4, 4, 289);
            }
            case 290: {
                return new FunctionInfo("LOGNORMDIST", 3, 3, 290);
            }
            case 291: {
                return new FunctionInfo("LOGINV", 3, 3, 291);
            }
            case 292: {
                return new FunctionInfo("NEGBINOMDIST", 3, 3, 292);
            }
            case 293: {
                return new FunctionInfo("NORMDIST", 4, 4, 293);
            }
            case 294: {
                return new FunctionInfo("NORMSDIST", 1, 1, 294);
            }
            case 295: {
                return new FunctionInfo("NORMINV", 3, 3, 295);
            }
            case 296: {
                return new FunctionInfo("NORMSINV", 1, 1, 296);
            }
            case 297: {
                return new FunctionInfo("STANDARDIZE", 3, 3, 297);
            }
            case 298: {
                return new FunctionInfo("ODD", 1, 1, 298);
            }
            case 299: {
                return new FunctionInfo("PERMUT", 2, 2, 299);
            }
            case 300: {
                return new FunctionInfo("POISSON", 3, 3, 300);
            }
            case 301: {
                return new FunctionInfo("TDIST", 3, 3, 301);
            }
            case 302: {
                return new FunctionInfo("WEIBULL", 4, 4, 302);
            }
            case 303: {
                return new FunctionInfo("SUMXMY2", 2, 2, 303);
            }
            case 304: {
                return new FunctionInfo("SUMX2MY2", 2, 2, 304);
            }
            case 305: {
                return new FunctionInfo("SUMX2PY2", 2, 2, 305);
            }
            case 306: {
                return new FunctionInfo("CHITEST", 2, 2, 306);
            }
            case 307: {
                return new FunctionInfo("CORREL", 2, 2, 307);
            }
            case 308: {
                return new FunctionInfo("COVAR", 2, 2, 308);
            }
            case 309: {
                return new FunctionInfo("FORECAST", 3, 3, 309);
            }
            case 310: {
                return new FunctionInfo("FTEST", 2, 2, 310);
            }
            case 311: {
                return new FunctionInfo("INTERCEPT", 2, 2, 311);
            }
            case 312: {
                return new FunctionInfo("PEARSON", 2, 2, 312);
            }
            case 313: {
                return new FunctionInfo("RSQ", 2, 2, 313);
            }
            case 314: {
                return new FunctionInfo("STEYX", 2, 2, 314);
            }
            case 315: {
                return new FunctionInfo("SLOPE", 2, 2, 315);
            }
            case 316: {
                return new FunctionInfo("TTEST", 4, 4, 316);
            }
            case 317: {
                return new FunctionInfo("PROB", 3, 4, 317);
            }
            case 318: {
                return new FunctionInfo("DEVSQ", 1, 255, 318);
            }
            case 319: {
                return new FunctionInfo("GEOMEAN", 1, 255, 319);
            }
            case 320: {
                return new FunctionInfo("HARMEAN", 1, 255, 320);
            }
            case 321: {
                return new FunctionInfo("SUMSQ", 1, 255, 321);
            }
            case 322: {
                return new FunctionInfo("KURT", 1, 255, 322);
            }
            case 323: {
                return new FunctionInfo("SKEW", 1, 255, 323);
            }
            case 324: {
                return new FunctionInfo("ZTEST", 2, 3, 324);
            }
            case 325: {
                return new FunctionInfo("LARGE", 2, 2, 325);
            }
            case 326: {
                return new FunctionInfo("SMALL", 2, 2, 326);
            }
            case 327: {
                return new FunctionInfo("QUARTILE", 2, 2, 327);
            }
            case 328: {
                return new FunctionInfo("PERCENTILE", 2, 2, 328);
            }
            case 329: {
                return new FunctionInfo("PERCENTRANK", 2, 3, 329);
            }
            case 330: {
                return new FunctionInfo("MODE", 1, 255, 330);
            }
            case 331: {
                return new FunctionInfo("TRIMMEAN", 2, 2, 331);
            }
            case 332: {
                return new FunctionInfo("TINV", 2, 2, 332);
            }
            case 333: {
                return new FunctionInfo("SKEW.P", 1, 255, 333);
            }
            case 336: {
                return new FunctionInfo("CONCATENATE", 1, 255, 336);
            }
            case 337: {
                return new FunctionInfo("POWER", 2, 2, 337);
            }
            case 342: {
                return new FunctionInfo("RADIANS", 1, 1, 342);
            }
            case 343: {
                return new FunctionInfo("DEGREES", 1, 1, 343);
            }
            case 344: {
                return new FunctionInfo("SUBTOTAL", 2, 255, 344);
            }
            case 345: {
                return new FunctionInfo("SUMIF", 2, 3, 345);
            }
            case 346: {
                return new FunctionInfo("COUNTIF", 2, 2, 346);
            }
            case 347: {
                return new FunctionInfo("COUNTBLANK", 1, 1, 347);
            }
            case 350: {
                return new FunctionInfo("ISPMT", 4, 4, 350);
            }
            case 351: {
                return new FunctionInfo("DATEDIF", 3, 3, 351);
            }
            case 352: {
                return new FunctionInfo("DATESTRING", 1, 1, 352);
            }
            case 353: {
                return new FunctionInfo("NUMBERSTRING", 2, 2, 353);
            }
            case 354: {
                return new FunctionInfo("ROMAN", 1, 2, 354);
            }
            case 358: {
                return new FunctionInfo("GETPIVOTDATA", 2, 255, 358);
            }
            case 359: {
                return new FunctionInfo("HYPERLINK", 1, 2, 359);
            }
            case 360: {
                return new FunctionInfo("PHONETIC", 1, 1, 360);
            }
            case 361: {
                return new FunctionInfo("AVERAGEA", 1, 255, 361);
            }
            case 362: {
                return new FunctionInfo("MAXA", 1, 255, 362);
            }
            case 363: {
                return new FunctionInfo("MINA", 1, 255, 363);
            }
            case 364: {
                return new FunctionInfo("STDEVPA", 1, 255, 364);
            }
            case 365: {
                return new FunctionInfo("VARPA", 1, 255, 365);
            }
            case 366: {
                return new FunctionInfo("STDEVA", 1, 255, 366);
            }
            case 367: {
                return new FunctionInfo("VARA", 1, 255, 367);
            }
            case 368: {
                return new FunctionInfo("STDEV.P", 1, 255, 368);
            }
            case 369: {
                return new FunctionInfo("STDEV.S", 1, 255, 369);
            }
            case 380: {
                return new FunctionInfo("CUBEVALUE", 1, 255, 380);
            }
            case 381: {
                return new FunctionInfo("CUBEMEMBER", 2, 3, 381);
            }
            case 382: {
                return new FunctionInfo("CUBEMEMBERPROPERTY", 3, 3, 382);
            }
            case 383: {
                return new FunctionInfo("CUBERANKEDMEMBER", 3, 4, 383);
            }
            case 384: {
                return new FunctionInfo("HEX2BIN", 1, 2, 384);
            }
            case 385: {
                return new FunctionInfo("HEX2DEC", 1, 1, 385);
            }
            case 386: {
                return new FunctionInfo("HEX2OCT", 1, 2, 386);
            }
            case 387: {
                return new FunctionInfo("DEC2BIN", 1, 2, 387);
            }
            case 388: {
                return new FunctionInfo("DEC2HEX", 1, 2, 388);
            }
            case 389: {
                return new FunctionInfo("DEC2OCT", 1, 2, 389);
            }
            case 390: {
                return new FunctionInfo("OCT2BIN", 1, 2, 390);
            }
            case 391: {
                return new FunctionInfo("OCT2HEX", 1, 2, 391);
            }
            case 392: {
                return new FunctionInfo("OCT2DEC", 1, 1, 392);
            }
            case 393: {
                return new FunctionInfo("BIN2DEC", 1, 1, 393);
            }
            case 394: {
                return new FunctionInfo("BIN2OCT", 1, 2, 394);
            }
            case 395: {
                return new FunctionInfo("BIN2HEX", 1, 2, 395);
            }
            case 396: {
                return new FunctionInfo("IMSUB", 2, 2, 396);
            }
            case 397: {
                return new FunctionInfo("IMDIV", 2, 2, 397);
            }
            case 398: {
                return new FunctionInfo("IMPOWER", 2, 2, 398);
            }
            case 399: {
                return new FunctionInfo("IMABS", 1, 1, 399);
            }
            case 400: {
                return new FunctionInfo("IMSQRT", 1, 1, 400);
            }
            case 401: {
                return new FunctionInfo("IMLN", 1, 1, 401);
            }
            case 402: {
                return new FunctionInfo("IMLOG2", 1, 1, 402);
            }
            case 403: {
                return new FunctionInfo("IMLOG10", 1, 1, 403);
            }
            case 404: {
                return new FunctionInfo("IMSIN", 1, 1, 404);
            }
            case 405: {
                return new FunctionInfo("IMCOS", 1, 1, 405);
            }
            case 406: {
                return new FunctionInfo("IMEXP", 1, 1, 406);
            }
            case 407: {
                return new FunctionInfo("IMARGUMENT", 1, 1, 407);
            }
            case 408: {
                return new FunctionInfo("IMCONJUGATE", 1, 1, 408);
            }
            case 409: {
                return new FunctionInfo("IMAGINARY", 1, 1, 409);
            }
            case 410: {
                return new FunctionInfo("IMREAL", 1, 1, 410);
            }
            case 411: {
                return new FunctionInfo("COMPLEX", 2, 3, 411);
            }
            case 412: {
                return new FunctionInfo("IMSUM", 1, 255, 412);
            }
            case 413: {
                return new FunctionInfo("IMPRODUCT", 1, 255, 413);
            }
            case 414: {
                return new FunctionInfo("SERIESSUM", 4, 4, 414);
            }
            case 415: {
                return new FunctionInfo("FACTDOUBLE", 1, 1, 415);
            }
            case 416: {
                return new FunctionInfo("SQRTPI", 1, 1, 416);
            }
            case 417: {
                return new FunctionInfo("QUOTIENT", 2, 2, 417);
            }
            case 418: {
                return new FunctionInfo("DELTA", 1, 2, 418);
            }
            case 419: {
                return new FunctionInfo("GESTEP", 1, 2, 419);
            }
            case 420: {
                return new FunctionInfo("ISEVEN", 1, 1, 420);
            }
            case 421: {
                return new FunctionInfo("ISODD", 1, 1, 421);
            }
            case 422: {
                return new FunctionInfo("MROUND", 2, 2, 422);
            }
            case 423: {
                return new FunctionInfo("ERF", 1, 2, 423);
            }
            case 424: {
                return new FunctionInfo("ERFC", 1, 1, 424);
            }
            case 425: {
                return new FunctionInfo("BESSELJ", 2, 2, 425);
            }
            case 426: {
                return new FunctionInfo("BESSELK", 2, 2, 426);
            }
            case 427: {
                return new FunctionInfo("BESSELY", 2, 2, 427);
            }
            case 428: {
                return new FunctionInfo("BESSELI", 2, 2, 428);
            }
            case 429: {
                return new FunctionInfo("XIRR", 2, 3, 429);
            }
            case 430: {
                return new FunctionInfo("XNPV", 3, 3, 430);
            }
            case 431: {
                return new FunctionInfo("PRICEMAT", 5, 6, 431);
            }
            case 432: {
                return new FunctionInfo("YIELDMAT", 5, 6, 432);
            }
            case 433: {
                return new FunctionInfo("INTRATE", 4, 5, 433);
            }
            case 434: {
                return new FunctionInfo("RECEIVED", 4, 5, 434);
            }
            case 435: {
                return new FunctionInfo("DISC", 4, 5, 435);
            }
            case 436: {
                return new FunctionInfo("PRICEDISC", 4, 5, 436);
            }
            case 437: {
                return new FunctionInfo("YIELDDISC", 4, 5, 437);
            }
            case 438: {
                return new FunctionInfo("TBILLEQ", 3, 3, 438);
            }
            case 439: {
                return new FunctionInfo("TBILLPRICE", 3, 3, 439);
            }
            case 440: {
                return new FunctionInfo("TBILLYIELD", 3, 3, 440);
            }
            case 441: {
                return new FunctionInfo("PRICE", 6, 7, 441);
            }
            case 442: {
                return new FunctionInfo("YIELD", 6, 7, 442);
            }
            case 443: {
                return new FunctionInfo("DOLLARDE", 2, 2, 443);
            }
            case 444: {
                return new FunctionInfo("DOLLARFR", 2, 2, 444);
            }
            case 445: {
                return new FunctionInfo("NOMINAL", 2, 2, 445);
            }
            case 446: {
                return new FunctionInfo("EFFECT", 2, 2, 446);
            }
            case 447: {
                return new FunctionInfo("CUMPRINC", 6, 6, 447);
            }
            case 448: {
                return new FunctionInfo("CUMIPMT", 6, 6, 448);
            }
            case 449: {
                return new FunctionInfo("EDATE", 2, 2, 449);
            }
            case 450: {
                return new FunctionInfo("EOMONTH", 2, 2, 450);
            }
            case 451: {
                return new FunctionInfo("YEARFRAC", 2, 3, 451);
            }
            case 452: {
                return new FunctionInfo("COUPDAYBS", 3, 4, 452);
            }
            case 453: {
                return new FunctionInfo("COUPDAYS", 3, 4, 453);
            }
            case 454: {
                return new FunctionInfo("COUPDAYSNC", 3, 4, 454);
            }
            case 455: {
                return new FunctionInfo("COUPNCD", 3, 4, 455);
            }
            case 456: {
                return new FunctionInfo("COUPNUM", 3, 4, 456);
            }
            case 457: {
                return new FunctionInfo("COUPPCD", 3, 4, 457);
            }
            case 458: {
                return new FunctionInfo("DURATION", 5, 6, 458);
            }
            case 459: {
                return new FunctionInfo("MDURATION", 5, 6, 459);
            }
            case 460: {
                return new FunctionInfo("ODDLPRICE", 7, 8, 460);
            }
            case 461: {
                return new FunctionInfo("ODDLYIELD", 7, 8, 461);
            }
            case 462: {
                return new FunctionInfo("ODDFPRICE", 8, 9, 462);
            }
            case 463: {
                return new FunctionInfo("ODDFYIELD", 8, 9, 463);
            }
            case 464: {
                return new FunctionInfo("RANDBETWEEN", 2, 2, 464);
            }
            case 465: {
                return new FunctionInfo("WEEKNUM", 1, 2, 465);
            }
            case 466: {
                return new FunctionInfo("AMORDEGRC", 6, 7, 466);
            }
            case 467: {
                return new FunctionInfo("AMORLINC", 6, 7, 467);
            }
            case 468: {
                return new FunctionInfo("CONVERT", 3, 3, 468);
            }
            case 469: {
                return new FunctionInfo("ACCRINT", 6, 8, 469);
            }
            case 470: {
                return new FunctionInfo("ACCRINTM", 4, 5, 470);
            }
            case 471: {
                return new FunctionInfo("WORKDAY", 2, 3, 471);
            }
            case 472: {
                return new FunctionInfo("NETWORKDAYS", 2, 3, 472);
            }
            case 473: {
                return new FunctionInfo("GCD", 1, 255, 473);
            }
            case 474: {
                return new FunctionInfo("MULTINOMIAL", 1, 255, 474);
            }
            case 475: {
                return new FunctionInfo("LCM", 1, 255, 475);
            }
            case 476: {
                return new FunctionInfo("FVSCHEDULE", 2, 2, 476);
            }
            case 477: {
                return new FunctionInfo("CUBEKPIMEMBER", 3, 4, 477);
            }
            case 478: {
                return new FunctionInfo("CUBESET", 2, 5, 478);
            }
            case 479: {
                return new FunctionInfo("CUBESETCOUNT", 1, 1, 479);
            }
            case 480: {
                return new FunctionInfo("IFERROR", 2, 2, 480);
            }
            case 481: {
                return new FunctionInfo("COUNTIFS", 2, 255, 481);
            }
            case 482: {
                return new FunctionInfo("SUMIFS", 3, 255, 482);
            }
            case 483: {
                return new FunctionInfo("AVERAGEIF", 2, 3, 483);
            }
            case 484: {
                return new FunctionInfo("AVERAGEIFS", 3, 255, 484);
            }
            case 485: {
                return new FunctionInfo("DAYS", 2, 2, 485);
            }
            case 486: {
                return new FunctionInfo("WORKDAY.INTL", 2, 4, 486);
            }
            case 487: {
                return new FunctionInfo("NETWORKDAYS.INTL", 2, 4, 487);
            }
            case 488: {
                return new FunctionInfo("AGGREGATE", 3, 255, 488);
            }
            case 489: {
                return new FunctionInfo("IFNA", 2, 2, 489);
            }
            case 490: {
                return new FunctionInfo("BITAND", 2, 2, 490);
            }
            case 491: {
                return new FunctionInfo("BITOR", 2, 2, 491);
            }
            case 492: {
                return new FunctionInfo("BITXOR", 2, 2, 492);
            }
            case 493: {
                return new FunctionInfo("BITLSHIFT", 2, 2, 493);
            }
            case 494: {
                return new FunctionInfo("BITRSHIFT", 2, 2, 494);
            }
            case 495: {
                return new FunctionInfo("PERCENTILE.INC", 2, 2, 495);
            }
            case 496: {
                return new FunctionInfo("PERCENTILE.EXC", 2, 2, 496);
            }
            case 497: {
                return new FunctionInfo("QUARTILE.INC", 2, 2, 497);
            }
            case 498: {
                return new FunctionInfo("QUARTILE.EXC", 2, 2, 498);
            }
            case 499: {
                return new FunctionInfo("NORM.DIST", 4, 4, 499);
            }
            case 500: {
                return new FunctionInfo("NORM.S.DIST", 2, 2, 500);
            }
            case 501: {
                return new FunctionInfo("NORM.INV", 3, 3, 501);
            }
            case 502: {
                return new FunctionInfo("NORM.S.INV", 1, 1, 502);
            }
            case 503: {
                return new FunctionInfo("BETA.DIST", 4, 6, 503);
            }
            case 504: {
                return new FunctionInfo("BETA.INV", 3, 5, 504);
            }
            case 505: {
                return new FunctionInfo("BINOM.DIST", 4, 4, 505);
            }
            case 506: {
                return new FunctionInfo("BINOM.INV", 3, 3, 506);
            }
            case 507: {
                return new FunctionInfo("CHISQ.DIST", 3, 3, 507);
            }
            case 508: {
                return new FunctionInfo("CHISQ.DIST.RT", 2, 2, 508);
            }
            case 509: {
                return new FunctionInfo("CHISQ.INV", 2, 2, 509);
            }
            case 510: {
                return new FunctionInfo("CHISQ.INV.RT", 2, 2, 510);
            }
            case 511: {
                return new FunctionInfo("CHISQ.TEST", 2, 2, 511);
            }
            case 512: {
                return new FunctionInfo("CONFIDENCE.NORM", 3, 3, 512);
            }
            case 513: {
                return new FunctionInfo("CONFIDENCE.T", 3, 3, 513);
            }
            case 514: {
                return new FunctionInfo("COVARIANCE.P", 2, 2, 514);
            }
            case 515: {
                return new FunctionInfo("COVARIANCE.S", 2, 2, 515);
            }
            case 516: {
                return new FunctionInfo("F.DIST", 4, 4, 516);
            }
            case 517: {
                return new FunctionInfo("F.DIST.RT", 3, 3, 517);
            }
            case 518: {
                return new FunctionInfo("F.INV", 3, 3, 518);
            }
            case 519: {
                return new FunctionInfo("F.INV.RT", 3, 3, 519);
            }
            case 520: {
                return new FunctionInfo("F.TEST", 2, 2, 520);
            }
            case 521: {
                return new FunctionInfo("GAMMA.DIST", 4, 4, 521);
            }
            case 522: {
                return new FunctionInfo("GAMMA.INV", 3, 3, 522);
            }
            case 523: {
                return new FunctionInfo("HYPGEOM_DIST", 5, 5, 523);
            }
            case 524: {
                return new FunctionInfo("LOGNORM.DIST", 4, 4, 524);
            }
            case 525: {
                return new FunctionInfo("LOGNORM.INV", 3, 3, 525);
            }
            case 526: {
                return new FunctionInfo("MODE.SNGL", 1, 255, 526);
            }
            case 527: {
                return new FunctionInfo("MODE.MULT", 1, 255, 527);
            }
            case 528: {
                return new FunctionInfo("NEGBINOM.DIST", 4, 4, 528);
            }
            case 529: {
                return new FunctionInfo("PERCENTRANK.INC", 2, 3, 529);
            }
            case 530: {
                return new FunctionInfo("PERCENTRANK.EXC", 2, 3, 530);
            }
            case 531: {
                return new FunctionInfo("POISSON.DIST", 3, 3, 531);
            }
            case 532: {
                return new FunctionInfo("RANK.AVG", 2, 3, 532);
            }
            case 533: {
                return new FunctionInfo("RANK.EQ", 2, 3, 533);
            }
            case 534: {
                return new FunctionInfo("T.DIST", 3, 3, 534);
            }
            case 535: {
                return new FunctionInfo("T.DIST.2T", 2, 2, 535);
            }
            case 536: {
                return new FunctionInfo("T.DIST.RT", 2, 2, 536);
            }
            case 537: {
                return new FunctionInfo("T.INV", 2, 2, 537);
            }
            case 538: {
                return new FunctionInfo("T.INV.2T", 2, 2, 538);
            }
            case 539: {
                return new FunctionInfo("T.TEST", 4, 4, 539);
            }
            case 540: {
                return new FunctionInfo("VAR.P", 1, 255, 540);
            }
            case 541: {
                return new FunctionInfo("VAR.S", 1, 255, 541);
            }
            case 542: {
                return new FunctionInfo("WEIBULL.DIST", 4, 4, 542);
            }
            case 543: {
                return new FunctionInfo("Z.TEST", 2, 3, 543);
            }
            case 544: {
                return new FunctionInfo("GAMMALN.PRECISE", 1, 1, 544);
            }
            case 545: {
                return new FunctionInfo("ISOWEEKNUM", 1, 1, 545);
            }
            case 546: {
                return new FunctionInfo("FORMULATEXT", 1, 1, 546);
            }
            case 547: {
                return new FunctionInfo("MAXIFS", 3, 255, 547);
            }
            case 548: {
                return new FunctionInfo("MINIFS", 3, 255, 548);
            }
            case 549: {
                return new FunctionInfo("IFS", 2, 255, 549);
            }
            case 550: {
                return new FunctionInfo("SWITCH", 3, 255, 550);
            }
            case 551: {
                return new FunctionInfo("CONCAT", 1, 255, 551);
            }
            case 552: {
                return new FunctionInfo("TEXTJOIN", 3, 3, 552);
            }
            case 553: {
                return new FunctionInfo("ISFORMULA", 1, 1, 553);
            }
            case 560: {
                return new FunctionInfo("CEILING.PRECISE", 1, 2, 560);
            }
            case 561: {
                return new FunctionInfo("CEILING.MATH", 1, 3, 561);
            }
            case 562: {
                return new FunctionInfo("LET", 3, 255, 562);
            }
        }
        return null;
    }

    static {
        _map.put("COUNT", 0);
        _map.put("IF", 1);
        _map.put("ISNA", 2);
        _map.put("ISERROR", 3);
        _map.put("SUM", 4);
        _map.put("AVERAGE", 5);
        _map.put("MIN", 6);
        _map.put("MAX", 7);
        _map.put("ROW", 8);
        _map.put("COLUMN", 9);
        _map.put("NA", 10);
        _map.put("NPV", 11);
        _map.put("STDEV", 12);
        _map.put("DOLLAR", 13);
        _map.put("FIXED", 14);
        _map.put("SIN", 15);
        _map.put("COS", 16);
        _map.put("TAN", 17);
        _map.put("ATAN", 18);
        _map.put("PI", 19);
        _map.put("SQRT", 20);
        _map.put("EXP", 21);
        _map.put("LN", 22);
        _map.put("LOG10", 23);
        _map.put("ABS", 24);
        _map.put("INT", 25);
        _map.put("SIGN", 26);
        _map.put("ROUND", 27);
        _map.put("LOOKUP", 28);
        _map.put("INDEX", 29);
        _map.put("REPT", 30);
        _map.put("MID", 31);
        _map.put("LEN", 32);
        _map.put("VALUE", 33);
        _map.put("TRUE", 34);
        _map.put("FALSE", 35);
        _map.put("AND", 36);
        _map.put("OR", 37);
        _map.put("NOT", 38);
        _map.put("MOD", 39);
        _map.put("DCOUNT", 40);
        _map.put("DSUM", 41);
        _map.put("DAVERAGE", 42);
        _map.put("DMIN", 43);
        _map.put("DMAX", 44);
        _map.put("DSTDEV", 45);
        _map.put("VAR", 46);
        _map.put("DVAR", 47);
        _map.put("TEXT", 48);
        _map.put("LINEST", 49);
        _map.put("TREND", 50);
        _map.put("LOGEST", 51);
        _map.put("GROWTH", 52);
        _map.put("HALT", 54);
        _map.put("RETURN", 55);
        _map.put("PV", 56);
        _map.put("FV", 57);
        _map.put("NPER", 58);
        _map.put("PMT", 59);
        _map.put("RATE", 60);
        _map.put("MIRR", 61);
        _map.put("IRR", 62);
        _map.put("RAND", 63);
        _map.put("MATCH", 64);
        _map.put("DATE", 65);
        _map.put("TIME", 66);
        _map.put("DAY", 67);
        _map.put("MONTH", 68);
        _map.put("YEAR", 69);
        _map.put("WEEKDAY", 70);
        _map.put("HOUR", 71);
        _map.put("MINUTE", 72);
        _map.put("SECOND", 73);
        _map.put("NOW", 74);
        _map.put("AREAS", 75);
        _map.put("ROWS", 76);
        _map.put("COLUMNS", 77);
        _map.put("OFFSET", 78);
        _map.put("ABSREF", 79);
        _map.put("ARGUMENT", 81);
        _map.put("SEARCH", 82);
        _map.put("TRANSPOSE", 83);
        _map.put("ERROR", 84);
        _map.put("TYPE", 86);
        _map.put("ECHO", 87);
        _map.put("UNICHAR", 88);
        _map.put("UNICODE", 89);
        _map.put("SHEET", 90);
        _map.put("SHEETS", 91);
        _map.put("SEC", 92);
        _map.put("SECH", 93);
        _map.put("RTD", 94);
        _map.put("RRI", 95);
        _map.put("ATAN2", 97);
        _map.put("ASIN", 98);
        _map.put("ACOS", 99);
        _map.put("CHOOSE", 100);
        _map.put("HLOOKUP", 101);
        _map.put("VLOOKUP", 102);
        _map.put("WEBSERVICE", 103);
        _map.put("ISREF", 105);
        _map.put("PHI", 106);
        _map.put("PERMUTATIONA", 107);
        _map.put("PDURATION", 108);
        _map.put("LOG", 109);
        _map.put("CHAR", 111);
        _map.put("LOWER", 112);
        _map.put("UPPER", 113);
        _map.put("PROPER", 114);
        _map.put("LEFT", 115);
        _map.put("RIGHT", 116);
        _map.put("EXACT", 117);
        _map.put("TRIM", 118);
        _map.put("REPLACE", 119);
        _map.put("SUBSTITUTE", 120);
        _map.put("CODE", 121);
        _map.put("NUMBERVALUE", 122);
        _map.put("MUNIT", 123);
        _map.put("FIND", 124);
        _map.put("CELL", 125);
        _map.put("ISERR", 126);
        _map.put("ISTEXT", 127);
        _map.put("ISNUMBER", 128);
        _map.put("ISBLANK", 129);
        _map.put("T", 130);
        _map.put("N", 131);
        _map.put("IMTAN", 132);
        _map.put("IMSINH", 133);
        _map.put("IMSECH", 134);
        _map.put("IMSEC", 135);
        _map.put("IMCSCH", 136);
        _map.put("IMCSC", 137);
        _map.put("IMCOT", 138);
        _map.put("IMCOSH", 139);
        _map.put("DATEVALUE", 140);
        _map.put("TIMEVALUE", 141);
        _map.put("SLN", 142);
        _map.put("SYD", 143);
        _map.put("DDB", 144);
        _map.put("GAUSS", 145);
        _map.put("GAMMA", 146);
        _map.put("INDIRECT", 148);
        _map.put("ISO.CEILING", 149);
        _map.put("FORECAST.LINEAR", 150);
        _map.put("FORECAST.ETS.STAT", 151);
        _map.put("FORECAST.ETS.SEASONALITY", 152);
        _map.put("FORECAST.ETS.CONFINT", 153);
        _map.put("FLOOR.PRECISE", 154);
        _map.put("FLOOR.MATH", 155);
        _map.put("FILTERXML", 156);
        _map.put("ERFC.PRECISE", 157);
        _map.put("ERF.PRECISE", 158);
        _map.put("ENCODEURL", 159);
        _map.put("DECIMAL", 160);
        _map.put("CSCH", 161);
        _map.put("CLEAN", 162);
        _map.put("MDETERM", 163);
        _map.put("MINVERSE", 164);
        _map.put("MMULT", 165);
        _map.put("CSC", 166);
        _map.put("IPMT", 167);
        _map.put("PPMT", 168);
        _map.put("COUNTA", 169);
        _map.put("CANCEL.KEY", 170);
        _map.put("FOR", 171);
        _map.put("WHILE", 172);
        _map.put("BREAK", 173);
        _map.put("NEXT", 174);
        _map.put("INITIATE", 175);
        _map.put("REQUEST", 176);
        _map.put("POKE", 177);
        _map.put("EXECUTE", 178);
        _map.put("TERMINATE", 179);
        _map.put("RESTART", 180);
        _map.put("HELP", 181);
        _map.put("GET.BAR", 182);
        _map.put("PRODUCT", 183);
        _map.put("FACT", 184);
        _map.put("GET.CELL", 185);
        _map.put("GET.WORKSPACE", 186);
        _map.put("GET.WINDOW", 187);
        _map.put("GET.DOCUMENT", 188);
        _map.put("DPRODUCT", 189);
        _map.put("ISNONTEXT", 190);
        _map.put("GET.NOTE", 191);
        _map.put("NOTE", 192);
        _map.put("STDEVP", 193);
        _map.put("VARP", 194);
        _map.put("DSTDEVP", 195);
        _map.put("DVARP", 196);
        _map.put("TRUNC", 197);
        _map.put("ISLOGICAL", 198);
        _map.put("DCOUNTA", 199);
        _map.put("COTH", 200);
        _map.put("COT", 201);
        _map.put("COMBINA", 202);
        _map.put("BINOM.DIST.RANGE", 203);
        _map.put("USDOLLAR", 204);
        _map.put("FINDB", 205);
        _map.put("SEARCHB", 206);
        _map.put("REPLACEB", 207);
        _map.put("LEFTB", 208);
        _map.put("RIGHTB", 209);
        _map.put("MIDB", 210);
        _map.put("LENB", 211);
        _map.put("ROUNDUP", 212);
        _map.put("ROUNDDOWN", 213);
        _map.put("ASC", 214);
        _map.put("WIDECHAR", 215);
        _map.put("DBCS", 215);
        _map.put("RANK", 216);
        _map.put("ADDRESS", 219);
        _map.put("DAYS360", 220);
        _map.put("TODAY", 221);
        _map.put("VDB", 222);
        _map.put("MEDIAN", 227);
        _map.put("SUMPRODUCT", 228);
        _map.put("SINH", 229);
        _map.put("COSH", 230);
        _map.put("TANH", 231);
        _map.put("ASINH", 232);
        _map.put("ACOSH", 233);
        _map.put("ATANH", 234);
        _map.put("DGET", 235);
        _map.put("BASE", 236);
        _map.put("BAHTTEXT", 237);
        _map.put("ARABIC", 238);
        _map.put("ACOTH", 239);
        _map.put("ACOT", 240);
        _map.put("INFO", 244);
        _map.put("DB", 247);
        _map.put("FREQUENCY", 252);
        _map.put("ERROR.TYPE", 261);
        _map.put("GET.WORKBOOK", 268);
        _map.put("AVEDEV", 269);
        _map.put("BETADIST", 270);
        _map.put("GAMMALN", 271);
        _map.put("BETAINV", 272);
        _map.put("BINOMDIST", 273);
        _map.put("CHIDIST", 274);
        _map.put("CHIINV", 275);
        _map.put("COMBIN", 276);
        _map.put("CONFIDENCE", 277);
        _map.put("CRITBINOM", 278);
        _map.put("EVEN", 279);
        _map.put("EXPONDIST", 280);
        _map.put("FDIST", 281);
        _map.put("FINV", 282);
        _map.put("FISHER", 283);
        _map.put("FISHERINV", 284);
        _map.put("FLOOR", 285);
        _map.put("GAMMADIST", 286);
        _map.put("GAMMAINV", 287);
        _map.put("CEILING", 288);
        _map.put("HYPGEOMDIST", 289);
        _map.put("LOGNORMDIST", 290);
        _map.put("LOGINV", 291);
        _map.put("NEGBINOMDIST", 292);
        _map.put("NORMDIST", 293);
        _map.put("NORMSDIST", 294);
        _map.put("NORMINV", 295);
        _map.put("NORMSINV", 296);
        _map.put("STANDARDIZE", 297);
        _map.put("ODD", 298);
        _map.put("PERMUT", 299);
        _map.put("POISSON", 300);
        _map.put("TDIST", 301);
        _map.put("WEIBULL", 302);
        _map.put("SUMXMY2", 303);
        _map.put("SUMX2MY2", 304);
        _map.put("SUMX2PY2", 305);
        _map.put("CHITEST", 306);
        _map.put("CORREL", 307);
        _map.put("COVAR", 308);
        _map.put("FORECAST", 309);
        _map.put("FTEST", 310);
        _map.put("INTERCEPT", 311);
        _map.put("PEARSON", 312);
        _map.put("RSQ", 313);
        _map.put("STEYX", 314);
        _map.put("SLOPE", 315);
        _map.put("TTEST", 316);
        _map.put("PROB", 317);
        _map.put("DEVSQ", 318);
        _map.put("GEOMEAN", 319);
        _map.put("HARMEAN", 320);
        _map.put("SUMSQ", 321);
        _map.put("KURT", 322);
        _map.put("SKEW", 323);
        _map.put("ZTEST", 324);
        _map.put("LARGE", 325);
        _map.put("SMALL", 326);
        _map.put("QUARTILE", 327);
        _map.put("PERCENTILE", 328);
        _map.put("PERCENTRANK", 329);
        _map.put("MODE", 330);
        _map.put("TRIMMEAN", 331);
        _map.put("TINV", 332);
        _map.put("SKEW.P", 333);
        _map.put("CONCATENATE", 336);
        _map.put("POWER", 337);
        _map.put("RADIANS", 342);
        _map.put("DEGREES", 343);
        _map.put("SUBTOTAL", 344);
        _map.put("SUMIF", 345);
        _map.put("COUNTIF", 346);
        _map.put("COUNTBLANK", 347);
        _map.put("ISPMT", 350);
        _map.put("DATEDIF", 351);
        _map.put("DATESTRING", 352);
        _map.put("NUMBERSTRING", 353);
        _map.put("ROMAN", 354);
        _map.put("GETPIVOTDATA", 358);
        _map.put("HYPERLINK", 359);
        _map.put("PHONETIC", 360);
        _map.put("AVERAGEA", 361);
        _map.put("MAXA", 362);
        _map.put("MINA", 363);
        _map.put("STDEVPA", 364);
        _map.put("VARPA", 365);
        _map.put("STDEVA", 366);
        _map.put("VARA", 367);
        _map.put("STDEV.P", 368);
        _map.put("STDEV.S", 369);
        _map.put("CUBEVALUE", 380);
        _map.put("CUBEMEMBER", 381);
        _map.put("CUBEMEMBERPROPERTY", 382);
        _map.put("CUBERANKEDMEMBER", 383);
        _map.put("HEX2BIN", 384);
        _map.put("HEX2DEC", 385);
        _map.put("HEX2OCT", 386);
        _map.put("DEC2BIN", 387);
        _map.put("DEC2HEX", 388);
        _map.put("DEC2OCT", 389);
        _map.put("OCT2BIN", 390);
        _map.put("OCT2HEX", 391);
        _map.put("OCT2DEC", 392);
        _map.put("BIN2DEC", 393);
        _map.put("BIN2OCT", 394);
        _map.put("BIN2HEX", 395);
        _map.put("IMSUB", 396);
        _map.put("ISEVEN", 420);
        _map.put("ISODD", 421);
        _map.put("MROUND", 422);
        _map.put("XIRR", 429);
        _map.put("XNPV", 430);
        _map.put("PRICEMAT", 431);
        _map.put("YIELDMAT", 432);
        _map.put("INTRATE", 433);
        _map.put("RECEIVED", 434);
        _map.put("DISC", 435);
        _map.put("PRICEDISC", 436);
        _map.put("YIELDDISC", 437);
        _map.put("TBILLEQ", 438);
        _map.put("TBILLPRICE", 439);
        _map.put("TBILLYIELD", 440);
        _map.put("PRICE", 441);
        _map.put("YIELD", 442);
        _map.put("DOLLARDE", 443);
        _map.put("DOLLARFR", 444);
        _map.put("NOMINAL", 445);
        _map.put("EFFECT", 446);
        _map.put("CUMPRINC", 447);
        _map.put("CUMIPMT", 448);
        _map.put("EDATE", 449);
        _map.put("EOMONTH", 450);
        _map.put("YEARFRAC", 451);
        _map.put("COUPDAYBS", 452);
        _map.put("COUPDAYS", 453);
        _map.put("COUPDAYSNC", 454);
        _map.put("COUPNCD", 455);
        _map.put("COUPNUM", 456);
        _map.put("COUPPCD", 457);
        _map.put("DURATION", 458);
        _map.put("MDURATION", 459);
        _map.put("ODDLPRICE", 460);
        _map.put("ODDLYIELD", 461);
        _map.put("ODDFPRICE", 462);
        _map.put("ODDFYIELD", 463);
        _map.put("RANDBETWEEN", 464);
        _map.put("WEEKNUM", 465);
        _map.put("AMORDEGRC", 466);
        _map.put("AMORLINC", 467);
        _map.put("CONVERT", 468);
        _map.put("ACCRINT", 469);
        _map.put("ACCRINTM", 470);
        _map.put("WORKDAY", 471);
        _map.put("NETWORKDAYS", 472);
        _map.put("FVSCHEDULE", 476);
        _map.put("CUBEKPIMEMBER", 477);
        _map.put("CUBESET", 478);
        _map.put("CUBESETCOUNT", 479);
        _map.put("IMSQRT", 400);
        _map.put("IMSIN", 404);
        _map.put("IMDIV", 397);
        _map.put("IMPOWER", 398);
        _map.put("IMABS", 399);
        _map.put("IMLN", 401);
        _map.put("IMLOG2", 402);
        _map.put("IMLOG10", 403);
        _map.put("IMCOS", 405);
        _map.put("IMEXP", 406);
        _map.put("IMARGUMENT", 407);
        _map.put("IMCONJUGATE", 408);
        _map.put("IMAGINARY", 409);
        _map.put("IMREAL", 410);
        _map.put("COMPLEX", 411);
        _map.put("IMSUM", 412);
        _map.put("IMPRODUCT", 413);
        _map.put("SERIESSUM", 414);
        _map.put("FACTDOUBLE", 415);
        _map.put("SQRTPI", 416);
        _map.put("QUOTIENT", 417);
        _map.put("DELTA", 418);
        _map.put("GESTEP", 419);
        _map.put("ERF", 423);
        _map.put("ERFC", 424);
        _map.put("BESSELJ", 425);
        _map.put("BESSELK", 426);
        _map.put("BESSELY", 427);
        _map.put("BESSELI", 428);
        _map.put("GCD", 473);
        _map.put("LCM", 475);
        _map.put("MULTINOMIAL", 474);
        _map.put("IFERROR", 480);
        _map.put("COUNTIFS", 481);
        _map.put("SUMIFS", 482);
        _map.put("AVERAGEIF", 483);
        _map.put("AVERAGEIFS", 484);
        _map.put("DAYS", 485);
        _map.put("WORKDAY.INTL", 486);
        _map.put("NETWORKDAYS.INTL", 487);
        _map.put("AGGREGATE", 488);
        _map.put("IFNA", 489);
        _map.put("BITAND", 490);
        _map.put("BITOR", 491);
        _map.put("BITXOR", 492);
        _map.put("BITLSHIFT", 493);
        _map.put("BITRSHIFT", 494);
        _map.put("PERCENTILE.INC", 495);
        _map.put("PERCENTILE.EXC", 496);
        _map.put("QUARTILE.INC", 497);
        _map.put("QUARTILE.EXC", 498);
        _map.put("NORM.DIST", 499);
        _map.put("NORM.S.DIST", 500);
        _map.put("NORM.INV", 501);
        _map.put("NORM.S.INV", 502);
        _map.put("BETA.DIST", 503);
        _map.put("BETA.INV", 504);
        _map.put("BINOM.DIST", 505);
        _map.put("BINOM.INV", 506);
        _map.put("CHISQ.DIST", 507);
        _map.put("CHISQ.DIST.RT", 508);
        _map.put("CHISQ.INV", 509);
        _map.put("CHISQ.INV.RT", 510);
        _map.put("CHISQ.TEST", 511);
        _map.put("CONFIDENCE.NORM", 512);
        _map.put("CONFIDENCE.T", 513);
        _map.put("COVARIANCE.P", 514);
        _map.put("COVARIANCE.S", 515);
        _map.put("F.DIST", 516);
        _map.put("F.DIST.RT", 517);
        _map.put("F.INV", 518);
        _map.put("F.INV.RT", 519);
        _map.put("F.TEST", 520);
        _map.put("GAMMA.DIST", 521);
        _map.put("GAMMA.INV", 522);
        _map.put("HYPGEOM.DIST", 523);
        _map.put("LOGNORM.DIST", 524);
        _map.put("LOGNORM.INV", 525);
        _map.put("MODE.SNGL", 526);
        _map.put("MODE.MULT", 527);
        _map.put("NEGBINOM.DIST", 528);
        _map.put("PERCENTRANK.INC", 529);
        _map.put("PERCENTRANK.EXC", 530);
        _map.put("POISSON.DIST", 531);
        _map.put("RANK.AVG", 532);
        _map.put("RANK.EQ", 533);
        _map.put("T.DIST", 534);
        _map.put("T.DIST.2T", 535);
        _map.put("T.DIST.RT", 536);
        _map.put("T.INV", 537);
        _map.put("T.INV.2T", 538);
        _map.put("T.TEST", 539);
        _map.put("VAR.P", 540);
        _map.put("VAR.S", 541);
        _map.put("WEIBULL.DIST", 542);
        _map.put("Z.TEST", 543);
        _map.put("GAMMALN.PRECISE", 544);
        _map.put("ISOWEEKNUM", 545);
        _map.put("FORMULATEXT", 546);
        _map.put("MAXIFS", 547);
        _map.put("MINIFS", 548);
        _map.put("IFS", 549);
        _map.put("SWITCH", 550);
        _map.put("CONCAT", 551);
        _map.put("TEXTJOIN", 552);
        _map.put("ISFORMULA", 553);
        _map.put("CEILING.PRECISE", 560);
        _map.put("CEILING.MATH", 561);
        _map.put("LET", 562);
    }
}

