/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.formula.eval.forked;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.zkoss.poi.ss.formula.EvaluationCell;
import org.zkoss.poi.ss.formula.EvaluationSheet;
import org.zkoss.poi.ss.formula.EvaluationWorkbook;
import org.zkoss.poi.ss.formula.eval.forked.ForkedEvaluationCell;
import org.zkoss.poi.ss.usermodel.Cell;
import org.zkoss.poi.ss.usermodel.Row;
import org.zkoss.poi.ss.usermodel.Sheet;
import org.zkoss.poi.ss.util.CellReference;

final class ForkedEvaluationSheet
implements EvaluationSheet {
    private final EvaluationSheet _masterSheet;
    private final Map<RowColKey, ForkedEvaluationCell> _sharedCellsByRowCol;

    public ForkedEvaluationSheet(EvaluationSheet masterSheet) {
        this._masterSheet = masterSheet;
        this._sharedCellsByRowCol = new HashMap<RowColKey, ForkedEvaluationCell>();
    }

    @Override
    public EvaluationCell getCell(int rowIndex, int columnIndex) {
        RowColKey key = new RowColKey(rowIndex, columnIndex);
        ForkedEvaluationCell result = this._sharedCellsByRowCol.get(key);
        if (result == null) {
            return this._masterSheet.getCell(rowIndex, columnIndex);
        }
        return result;
    }

    @Override
    public Iterator<EvaluationCell> nonEmptyCellsIterator(int rowStart, int rowEnd, int columnStart, int columnEnd) {
        LinkedList<EvaluationCell> cells = new LinkedList<EvaluationCell>();
        for (int i = rowStart; i < rowEnd; ++i) {
            for (int j = columnStart; j <= columnEnd; ++j) {
                EvaluationCell evaluationCell = this.getCell(i, j);
                if (evaluationCell == null || evaluationCell.getCellType() == 3) continue;
                cells.add(evaluationCell);
            }
        }
        return cells.iterator();
    }

    @Override
    public Iterator<EvaluationCell> nonEmptyCellsIterator(int columnIndex) {
        return this._masterSheet.nonEmptyCellsIterator(columnIndex);
    }

    public ForkedEvaluationCell getOrCreateUpdatableCell(int rowIndex, int columnIndex) {
        RowColKey key = new RowColKey(rowIndex, columnIndex);
        ForkedEvaluationCell result = this._sharedCellsByRowCol.get(key);
        if (result == null) {
            EvaluationCell mcell = this._masterSheet.getCell(rowIndex, columnIndex);
            if (mcell == null) {
                CellReference cr = new CellReference(rowIndex, columnIndex);
                throw new UnsupportedOperationException("Underlying cell '" + cr.formatAsString() + "' is missing in master sheet.");
            }
            result = new ForkedEvaluationCell(this, mcell);
            this._sharedCellsByRowCol.put(key, result);
        }
        return result;
    }

    public void copyUpdatedCells(Sheet sheet) {
        Object[] keys = new RowColKey[this._sharedCellsByRowCol.size()];
        this._sharedCellsByRowCol.keySet().toArray(keys);
        Arrays.sort(keys);
        for (int i = 0; i < keys.length; ++i) {
            Cell destCell;
            Object key = keys[i];
            Row row = sheet.getRow(((RowColKey)key).getRowIndex());
            if (row == null) {
                row = sheet.createRow(((RowColKey)key).getRowIndex());
            }
            if ((destCell = row.getCell(((RowColKey)key).getColumnIndex())) == null) {
                destCell = row.createCell(((RowColKey)key).getColumnIndex());
            }
            ForkedEvaluationCell srcCell = this._sharedCellsByRowCol.get(key);
            srcCell.copyValue(destCell);
        }
    }

    public int getSheetIndex(EvaluationWorkbook mewb) {
        return mewb.getSheetIndex(this._masterSheet);
    }

    @Override
    public boolean isHidden(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public boolean isRowHidden(int rowIndex) {
        return false;
    }

    @Override
    public boolean isFiltered() {
        return false;
    }

    private static final class RowColKey
    implements Comparable<RowColKey> {
        private final int _rowIndex;
        private final int _columnIndex;

        public RowColKey(int rowIndex, int columnIndex) {
            this._rowIndex = rowIndex;
            this._columnIndex = columnIndex;
        }

        public boolean equals(Object obj) {
            assert (obj instanceof RowColKey) : "these private cache key instances are only compared to themselves";
            RowColKey other = (RowColKey)obj;
            return this._rowIndex == other._rowIndex && this._columnIndex == other._columnIndex;
        }

        public int hashCode() {
            return this._rowIndex ^ this._columnIndex;
        }

        @Override
        public int compareTo(RowColKey o) {
            int cmp = this._rowIndex - o._rowIndex;
            if (cmp != 0) {
                return cmp;
            }
            return this._columnIndex - o._columnIndex;
        }

        public int getRowIndex() {
            return this._rowIndex;
        }

        public int getColumnIndex() {
            return this._columnIndex;
        }
    }
}

