/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.formula.eval;

import org.zkoss.poi.ss.formula.SheetRefEvaluator;
import org.zkoss.poi.ss.formula.TwoDEval;
import org.zkoss.poi.ss.formula.constant.ErrorConstant;
import org.zkoss.poi.ss.formula.eval.AreaEval;
import org.zkoss.poi.ss.formula.eval.BlankEval;
import org.zkoss.poi.ss.formula.eval.BoolEval;
import org.zkoss.poi.ss.formula.eval.ErrorEval;
import org.zkoss.poi.ss.formula.eval.NumberEval;
import org.zkoss.poi.ss.formula.eval.StringEval;
import org.zkoss.poi.ss.formula.eval.ValueEval;
import org.zkoss.poi.ss.formula.ptg.ArrayPtg;

public class ArrayEval
implements AreaEval {
    private final SheetRefEvaluator _evaluator;
    private final int _firstRow;
    private final int _firstCol;
    private final int _lastRow;
    private final int _lastCol;
    private final ValueEval[][] _values;

    private ArrayEval(Object[][] srcvalues, int firstRow, int firstColumn, int lastRow, int lastColumn, SheetRefEvaluator evaluator) {
        this._evaluator = evaluator;
        this._firstRow = firstRow;
        this._firstCol = firstColumn;
        this._lastRow = lastRow;
        this._lastCol = lastColumn;
        int nRows = this.getHeight();
        int nColumns = this.getWidth();
        this._values = new ValueEval[nRows][];
        for (int r = 0; r < nRows; ++r) {
            ValueEval[] dst = new ValueEval[nColumns];
            this._values[r] = dst;
            for (int c = 0; c < nColumns; ++c) {
                Object o = srcvalues[r][c];
                this._values[r][c] = this.getValueEval(o);
            }
        }
    }

    public ArrayEval(ValueEval[][] srcvalues, int firstRow, int firstColumn, int lastRow, int lastColumn, SheetRefEvaluator evaluator) {
        this._firstRow = firstRow;
        this._firstCol = firstColumn;
        this._lastRow = lastRow;
        this._lastCol = lastColumn;
        this._values = srcvalues;
        this._evaluator = evaluator;
    }

    public ArrayEval(ArrayPtg ptg, SheetRefEvaluator evaluator) {
        this(ptg.getTokenArrayValues(), 0, 0, ptg.getRowCount() - 1, ptg.getColumnCount() - 1, evaluator);
    }

    private ValueEval getValueEval(Object o) {
        if (o == null) {
            return BlankEval.instance;
        }
        if (o instanceof String) {
            return new StringEval((String)o);
        }
        if (o instanceof Double) {
            return new NumberEval(((Number)o).doubleValue());
        }
        if (o instanceof Boolean) {
            return BoolEval.valueOf((Boolean)o);
        }
        if (o instanceof ErrorConstant) {
            return ErrorEval.valueOf(((ErrorConstant)o).getErrorCode());
        }
        throw new IllegalArgumentException("Unexpected constant class (" + o.getClass().getName() + ")");
    }

    @Override
    public boolean contains(int row, int col) {
        return this._firstRow <= row && row <= this._lastRow && this._firstCol <= col && col <= this._lastCol;
    }

    @Override
    public boolean containsColumn(int col) {
        return this._firstCol <= col && col <= this._lastCol;
    }

    @Override
    public boolean containsRow(int row) {
        return this._firstRow <= row && row <= this._lastRow;
    }

    @Override
    public ValueEval getAbsoluteValue(int row, int col) {
        return this.getRelativeValue(row - this._firstRow, col - this._firstCol);
    }

    @Override
    public int getFirstColumn() {
        return this._firstCol;
    }

    @Override
    public int getFirstRow() {
        return this._firstRow;
    }

    @Override
    public int getHeight() {
        return this._lastRow - this._firstRow + 1;
    }

    @Override
    public int getLastColumn() {
        return this._lastCol;
    }

    @Override
    public int getLastRow() {
        return this._lastRow;
    }

    @Override
    public ValueEval getRelativeValue(int r, int c) {
        int row = r + this._firstRow;
        int col = c + this._firstCol;
        if (!this.containsRow(row)) {
            throw new IllegalArgumentException("Specified row index (" + row + ") is outside the allowed range (" + this.getFirstRow() + ".." + this.getLastRow() + ")");
        }
        if (!this.containsColumn(col)) {
            throw new IllegalArgumentException("Specified column index (" + col + ") is outside the allowed range (" + this.getFirstColumn() + ".." + this.getLastColumn() + ")");
        }
        return this._values[r][c];
    }

    @Override
    public ValueEval getNonEmptyCellValues() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getWidth() {
        return this._lastCol - this._firstCol + 1;
    }

    @Override
    public AreaEval offset(int relFirstRowIx, int relLastRowIx, int relFirstColIx, int relLastColIx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TwoDEval getColumn(int columnIndex) {
        int nRows = this.getHeight();
        int nColumns = 1;
        ValueEval[][] tgtvalues = new ValueEval[nRows][];
        for (int r = 0; r < nRows; ++r) {
            ValueEval[] dst = new ValueEval[nColumns];
            tgtvalues[r] = dst;
            dst[0] = this._values[r][columnIndex];
        }
        return new ArrayEval(tgtvalues, this.getFirstRow(), columnIndex, this.getLastRow(), columnIndex, this._evaluator);
    }

    @Override
    public TwoDEval getRow(int rowIndex) {
        int nRows = 1;
        int nColumns = this.getWidth();
        ValueEval[][] tgtvalues = new ValueEval[nRows][];
        ValueEval[] dst = new ValueEval[nColumns];
        tgtvalues[0] = dst;
        System.arraycopy(this._values[rowIndex], 0, dst, 0, nColumns);
        return new ArrayEval(tgtvalues, rowIndex, this.getFirstColumn(), rowIndex, this.getLastColumn(), this._evaluator);
    }

    @Override
    public ValueEval getValue(int rowIndex, int columnIndex) {
        return this.getRelativeValue(rowIndex, columnIndex);
    }

    @Override
    public boolean isColumn() {
        return this._firstCol == this._lastCol;
    }

    @Override
    public boolean isRow() {
        return this._firstRow == this._lastRow;
    }

    @Override
    public boolean isSubTotal(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public int getDepth() {
        return 1;
    }

    @Override
    public boolean isHidden(int rowIndex, int columnIndex) {
        return this._evaluator.isHidden(this._evaluator.getSheetIndex(), rowIndex, columnIndex);
    }

    @Override
    public boolean isRowHidden(int rowIndex) {
        return this._evaluator.isRowHidden(rowIndex);
    }

    @Override
    public boolean isFiltered() {
        return this._evaluator.isFiltered();
    }

    @Override
    public SheetRefEvaluator getRefEvaluator() {
        return this._evaluator;
    }
}

