/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.formula;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import java.util.TreeSet;
import org.zkoss.poi.hssf.util.CellReference;
import org.zkoss.poi.ss.formula.CollaboratingWorkbooksEnvironment;
import org.zkoss.poi.ss.formula.ColumnCache;
import org.zkoss.poi.ss.formula.DependencyTracker;
import org.zkoss.poi.ss.formula.EvaluationCache;
import org.zkoss.poi.ss.formula.EvaluationCell;
import org.zkoss.poi.ss.formula.EvaluationName;
import org.zkoss.poi.ss.formula.EvaluationSheet;
import org.zkoss.poi.ss.formula.EvaluationTracker;
import org.zkoss.poi.ss.formula.EvaluationWorkbook;
import org.zkoss.poi.ss.formula.FormulaCellCacheEntry;
import org.zkoss.poi.ss.formula.IEvaluationListener;
import org.zkoss.poi.ss.formula.IStabilityClassifier;
import org.zkoss.poi.ss.formula.OperationEvaluationContext;
import org.zkoss.poi.ss.formula.OperationEvaluatorFactory;
import org.zkoss.poi.ss.formula.SortedValues;
import org.zkoss.poi.ss.formula.atp.AnalysisToolPak;
import org.zkoss.poi.ss.formula.eval.BlankEval;
import org.zkoss.poi.ss.formula.eval.BoolEval;
import org.zkoss.poi.ss.formula.eval.CellValueEval;
import org.zkoss.poi.ss.formula.eval.ErrorEval;
import org.zkoss.poi.ss.formula.eval.EvaluationException;
import org.zkoss.poi.ss.formula.eval.FunctionEval;
import org.zkoss.poi.ss.formula.eval.MissingArgEval;
import org.zkoss.poi.ss.formula.eval.NameEval;
import org.zkoss.poi.ss.formula.eval.NotImplementedException;
import org.zkoss.poi.ss.formula.eval.NumberEval;
import org.zkoss.poi.ss.formula.eval.OperandResolver;
import org.zkoss.poi.ss.formula.eval.StringEval;
import org.zkoss.poi.ss.formula.eval.ValueEval;
import org.zkoss.poi.ss.formula.eval.ValuesEval;
import org.zkoss.poi.ss.formula.functions.Choose;
import org.zkoss.poi.ss.formula.functions.FreeRefFunction;
import org.zkoss.poi.ss.formula.functions.Function;
import org.zkoss.poi.ss.formula.functions.IfFunc;
import org.zkoss.poi.ss.formula.ptg.Area3DPtg;
import org.zkoss.poi.ss.formula.ptg.AreaErrPtg;
import org.zkoss.poi.ss.formula.ptg.AreaPtg;
import org.zkoss.poi.ss.formula.ptg.ArrayPtg;
import org.zkoss.poi.ss.formula.ptg.AttrPtg;
import org.zkoss.poi.ss.formula.ptg.BoolPtg;
import org.zkoss.poi.ss.formula.ptg.ControlPtg;
import org.zkoss.poi.ss.formula.ptg.DeferredNamePtg;
import org.zkoss.poi.ss.formula.ptg.DeletedArea3DPtg;
import org.zkoss.poi.ss.formula.ptg.DeletedRef3DPtg;
import org.zkoss.poi.ss.formula.ptg.ErrPtg;
import org.zkoss.poi.ss.formula.ptg.ExpPtg;
import org.zkoss.poi.ss.formula.ptg.FuncVarPtg;
import org.zkoss.poi.ss.formula.ptg.IntPtg;
import org.zkoss.poi.ss.formula.ptg.MemAreaPtg;
import org.zkoss.poi.ss.formula.ptg.MemErrPtg;
import org.zkoss.poi.ss.formula.ptg.MemFuncPtg;
import org.zkoss.poi.ss.formula.ptg.MissingArgPtg;
import org.zkoss.poi.ss.formula.ptg.NamePtg;
import org.zkoss.poi.ss.formula.ptg.NameXPtg;
import org.zkoss.poi.ss.formula.ptg.NumberPtg;
import org.zkoss.poi.ss.formula.ptg.OperationPtg;
import org.zkoss.poi.ss.formula.ptg.Ptg;
import org.zkoss.poi.ss.formula.ptg.Ref3DPtg;
import org.zkoss.poi.ss.formula.ptg.RefErrorPtg;
import org.zkoss.poi.ss.formula.ptg.RefPtg;
import org.zkoss.poi.ss.formula.ptg.StringPtg;
import org.zkoss.poi.ss.formula.ptg.TablePtg;
import org.zkoss.poi.ss.formula.ptg.UnknownPtg;
import org.zkoss.poi.ss.formula.udf.AggregatingUDFFinder;
import org.zkoss.poi.ss.formula.udf.UDFFinder;
import org.zkoss.poi.util.POILogFactory;
import org.zkoss.poi.util.POILogger;

public final class WorkbookEvaluator {
    private static final POILogger LOG = POILogFactory.getLogger(WorkbookEvaluator.class);
    private final EvaluationWorkbook _workbook;
    private EvaluationCache _cache;
    private int _workbookIx;
    private final IEvaluationListener _evaluationListener;
    private final Map<EvaluationSheet, Integer> _sheetIndexesBySheet;
    private final Map<String, Integer> _sheetIndexesByName;
    private final Map<Integer, ColumnCache> _columnCacheBySheetIndexes;
    private CollaboratingWorkbooksEnvironment _collaboratingWorkbookEnvironment;
    private final IStabilityClassifier _stabilityClassifier;
    private final AggregatingUDFFinder _udfFinder;
    private DependencyTracker _dependencyTracker;
    private boolean _ignoreMissingWorkbooks = false;
    private CacheManager _cacheManager;
    private boolean dbgEvaluationOutputForNextEval = false;
    private final POILogger EVAL_LOG = POILogFactory.getLogger("POI.FormulaEval");
    private int dbgEvaluationOutputIndent = -1;

    public WorkbookEvaluator(EvaluationWorkbook workbook, IStabilityClassifier stabilityClassifier, UDFFinder udfFinder) {
        this(workbook, null, stabilityClassifier, udfFinder);
    }

    public WorkbookEvaluator(EvaluationWorkbook workbook, IStabilityClassifier stabilityClassifier, UDFFinder udfFinder, CacheManager cacheManager) {
        this(workbook, null, stabilityClassifier, udfFinder);
        this._cacheManager = cacheManager;
    }

    WorkbookEvaluator(EvaluationWorkbook workbook, IEvaluationListener evaluationListener, IStabilityClassifier stabilityClassifier, UDFFinder udfFinder) {
        AggregatingUDFFinder defaultToolkit;
        this._workbook = workbook;
        this._evaluationListener = evaluationListener;
        this._cache = new EvaluationCache(evaluationListener);
        this._columnCacheBySheetIndexes = new HashMap<Integer, ColumnCache>();
        this._sheetIndexesBySheet = new HashMap<EvaluationSheet, Integer>();
        this._sheetIndexesByName = new HashMap<String, Integer>();
        this._collaboratingWorkbookEnvironment = CollaboratingWorkbooksEnvironment.EMPTY;
        this._workbookIx = 0;
        this._stabilityClassifier = stabilityClassifier;
        AggregatingUDFFinder aggregatingUDFFinder = defaultToolkit = workbook == null ? null : (AggregatingUDFFinder)workbook.getUDFFinder();
        if (defaultToolkit != null && udfFinder != null) {
            defaultToolkit.add(udfFinder);
        }
        this._udfFinder = defaultToolkit;
    }

    public void setDependencyTracker(DependencyTracker tracker) {
        this._dependencyTracker = tracker;
    }

    String getSheetName(int sheetIndex) {
        return this._workbook.getSheetName(sheetIndex);
    }

    EvaluationSheet getSheet(int sheetIndex) {
        return this._workbook.getSheet(sheetIndex);
    }

    EvaluationWorkbook getWorkbook() {
        return this._workbook;
    }

    EvaluationName getName(String name, int sheetIndex) {
        NamePtg namePtg = this._workbook.getName(name, sheetIndex).createPtg();
        if (namePtg == null) {
            return null;
        }
        return this._workbook.getName(namePtg);
    }

    private static boolean isDebugLogEnabled() {
        return LOG.check(1);
    }

    private static boolean isInfoLogEnabled() {
        return LOG.check(3);
    }

    private static void logDebug(String s) {
        if (WorkbookEvaluator.isDebugLogEnabled()) {
            LOG.log(1, s);
        }
    }

    private static void logInfo(String s) {
        if (WorkbookEvaluator.isInfoLogEnabled()) {
            LOG.log(3, s);
        }
    }

    void attachToEnvironment(CollaboratingWorkbooksEnvironment collaboratingWorkbooksEnvironment, EvaluationCache cache, int workbookIx) {
        this._collaboratingWorkbookEnvironment = collaboratingWorkbooksEnvironment;
        this._cache = cache;
        this._workbookIx = workbookIx;
    }

    CollaboratingWorkbooksEnvironment getEnvironment() {
        return this._collaboratingWorkbookEnvironment;
    }

    void detachFromEnvironment() {
        this._collaboratingWorkbookEnvironment = CollaboratingWorkbooksEnvironment.EMPTY;
        this._cache = new EvaluationCache(this._evaluationListener);
        this._workbookIx = 0;
    }

    WorkbookEvaluator getOtherWorkbookEvaluator(String workbookName) throws CollaboratingWorkbooksEnvironment.WorkbookNotFoundException {
        return this._collaboratingWorkbookEnvironment.getWorkbookEvaluator(workbookName);
    }

    IEvaluationListener getEvaluationListener() {
        return this._evaluationListener;
    }

    public void clearAllCachedResultValues() {
        this._cache.clear();
        this._columnCacheBySheetIndexes.clear();
        this._sheetIndexesBySheet.clear();
        this._sheetIndexesByName.clear();
    }

    public void notifyUpdateCell(EvaluationCell cell) {
        int sheetIndex = this.getSheetIndex(cell.getSheet());
        this._cache.notifyUpdateCell(this._workbookIx, sheetIndex, cell);
        this.clearColumnCache(sheetIndex, cell);
    }

    public void notifyDeleteCell(EvaluationCell cell) {
        int sheetIndex = this.getSheetIndex(cell.getSheet());
        this._cache.notifyDeleteCell(this._workbookIx, sheetIndex, cell);
        this.clearColumnCache(sheetIndex, cell);
    }

    private int getSheetIndex(EvaluationSheet sheet) {
        Integer result = this._sheetIndexesBySheet.get(sheet);
        if (result == null) {
            int sheetIndex = this._workbook.getSheetIndex(sheet);
            if (sheetIndex < 0) {
                throw new RuntimeException("Specified sheet from a different book");
            }
            result = sheetIndex;
            this._sheetIndexesBySheet.put(sheet, result);
        }
        return result;
    }

    public void clearColumnCache(int sheetIndex, int start, int end) {
        ColumnCache columnCache = this._columnCacheBySheetIndexes.get(sheetIndex);
        if (columnCache == null) {
            return;
        }
        columnCache.clear(start, end);
    }

    private void clearColumnCache(int sheetIndex, EvaluationCell cell) {
        this.clearColumnCache(sheetIndex, cell.getColumnIndex());
    }

    private void clearColumnCache(int sheetIndex, int columnIndex) {
        this.clearColumnCache(sheetIndex, columnIndex, columnIndex);
        ColumnCache columnCache = this._columnCacheBySheetIndexes.get(sheetIndex);
        if (columnCache != null) {
            columnCache.remove(columnIndex);
        }
    }

    public ValueEval evaluate(EvaluationCell srcCell, Object ref) {
        return this.evaluate(srcCell, ref, null);
    }

    public ValueEval evaluate(EvaluationCell srcCell, Object ref, int[] offset) {
        int sheetIndex = this.getSheetIndex(srcCell.getSheet());
        return this.evaluateAny(srcCell, sheetIndex, srcCell.getRowIndex(), srcCell.getColumnIndex(), new EvaluationTracker(this._cache), ref, offset);
    }

    int getSheetIndex(String sheetName) {
        Integer result = this._sheetIndexesByName.get(sheetName);
        if (result == null) {
            int sheetIndex = this._workbook.getSheetIndex(sheetName);
            if (sheetIndex < 0) {
                return -1;
            }
            result = sheetIndex;
            this._sheetIndexesByName.put(sheetName, result);
        }
        return result;
    }

    int getSheetIndexByExternIndex(int externSheetIndex) {
        return this._workbook.convertFromExternSheetIndex(externSheetIndex);
    }

    int getLastSheetIndexByExternIndex(int externSheetIndex) {
        return this._workbook.convertLastIndexFromExternSheetIndex(externSheetIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private ValueEval evaluateAny(EvaluationCell srcCell, int sheetIndex, int rowIndex, int columnIndex, EvaluationTracker tracker, Object ref, int[] offset) {
        ValueEval result;
        boolean shouldCellDependencyBeRecorded;
        boolean bl = this._stabilityClassifier == null ? true : (shouldCellDependencyBeRecorded = !this._stabilityClassifier.isCellFinal(sheetIndex, rowIndex, columnIndex));
        if (srcCell == null || srcCell.getCellType() != 2) {
            ValueEval result2 = WorkbookEvaluator.getValueFromNonFormulaCell(srcCell);
            if (!shouldCellDependencyBeRecorded) return result2;
            tracker.acceptPlainValueDependency(this._workbookIx, sheetIndex, rowIndex, columnIndex, result2);
            return result2;
        }
        FormulaCellCacheEntry cce = this._cache.getOrCreateFormulaCellEntry(srcCell);
        if (shouldCellDependencyBeRecorded || cce.isInputSensitive()) {
            tracker.acceptFormulaDependency(cce);
        }
        IEvaluationListener evalListener = this._evaluationListener;
        if (cce.getValue() != null) {
            if (evalListener == null) return cce.getValue();
            evalListener.onCacheHit(sheetIndex, rowIndex, columnIndex, cce.getValue());
            return cce.getValue();
        }
        if (!tracker.startEvaluate(cce)) {
            return ErrorEval.CIRCULAR_REF_ERROR;
        }
        OperationEvaluationContext ec = new OperationEvaluationContext(this, this._workbook, sheetIndex, rowIndex, columnIndex, tracker, this._dependencyTracker, ref, offset);
        try {
            Ptg[] ptgs = this._workbook.getFormulaTokens(srcCell);
            if (evalListener == null) {
                result = this.evaluateFormula(ec, ptgs, false, false);
            } else {
                evalListener.onStartEvaluate(srcCell, cce);
                result = this.evaluateFormula(ec, ptgs, false, false);
                evalListener.onEndEvaluate(cce, result);
            }
            tracker.updateCacheResult(result);
            this.clearColumnCache(sheetIndex, columnIndex);
            if (this._cacheManager != null) {
                this._cacheManager.onUpdateCacheResult(srcCell, result);
            }
        }
        catch (NotImplementedException e) {
            throw this.addExceptionInfo(e, sheetIndex, rowIndex, columnIndex);
        }
        catch (RuntimeException re) {
            if (!(re.getCause() instanceof CollaboratingWorkbooksEnvironment.WorkbookNotFoundException)) throw re;
            if (!this._ignoreMissingWorkbooks) throw re;
            WorkbookEvaluator.logInfo(re.getCause().getMessage() + " - Continuing with cached value!");
            switch (srcCell.getCachedFormulaResultType()) {
                case 0: {
                    result = new NumberEval(srcCell.getNumericCellValue());
                    break;
                }
                case 1: {
                    result = new StringEval(srcCell.getStringCellValue());
                    break;
                }
                case 3: {
                    result = BlankEval.instance;
                    break;
                }
                case 4: {
                    result = BoolEval.valueOf(srcCell.getBooleanCellValue());
                    break;
                }
                case 5: {
                    result = ErrorEval.valueOf(srcCell.getErrorCellValue());
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected cell type '" + srcCell.getCellType() + "' found!");
                }
            }
        }
        finally {
            tracker.endEvaluate(cce);
        }
        if (!WorkbookEvaluator.isDebugLogEnabled()) return result;
        String sheetName = this.getSheetName(sheetIndex);
        CellReference cr = new CellReference(rowIndex, columnIndex);
        WorkbookEvaluator.logDebug("Evaluated " + sheetName + "!" + cr.formatAsString() + " to " + result.toString());
        return result;
    }

    private NotImplementedException addExceptionInfo(NotImplementedException inner, int sheetIndex, int rowIndex, int columnIndex) {
        try {
            String sheetName = this._workbook.getSheetName(sheetIndex);
            CellReference cr = new CellReference(sheetName, rowIndex, columnIndex, false, false);
            String msg = "Error evaluating cell " + cr.formatAsString();
            return new NotImplementedException(msg, inner);
        }
        catch (Exception e) {
            e.printStackTrace();
            return inner;
        }
    }

    static ValueEval getValueFromNonFormulaCell(EvaluationCell cell) {
        if (cell == null) {
            return BlankEval.instance;
        }
        int cellType = cell.getCellType();
        switch (cellType) {
            case 0: {
                return new NumberEval(cell.getNumericCellValue());
            }
            case 1: {
                return new StringEval(cell.getStringCellValue());
            }
            case 4: {
                return BoolEval.valueOf(cell.getBooleanCellValue());
            }
            case 3: {
                return BlankEval.instance;
            }
            case 5: {
                return ErrorEval.valueOf(cell.getErrorCellValue());
            }
        }
        throw new RuntimeException("Unexpected cell type (" + cellType + ")");
    }

    private ValueEval postProcessValueEval(OperationEvaluationContext ec, ValueEval opResult, boolean eval) {
        if (this._dependencyTracker != null) {
            opResult = this._dependencyTracker.postProcessValueEval(ec, opResult, eval);
        }
        return opResult;
    }

    private void addDependency(OperationEvaluationContext ec, Ptg[] ptgs) {
        if (this._dependencyTracker != null) {
            this._dependencyTracker.addDependency(ec, ptgs);
        }
    }

    ValueEval evaluateFormula(OperationEvaluationContext ec, Ptg[] ptgs, boolean ignoreDependency, boolean ignoreDereference) {
        ValueEval result;
        if (!ignoreDependency) {
            this.addDependency(ec, ptgs);
        }
        String dbgIndentStr = "";
        if (this.dbgEvaluationOutputForNextEval) {
            this.dbgEvaluationOutputIndent = 1;
            this.dbgEvaluationOutputForNextEval = false;
        }
        if (this.dbgEvaluationOutputIndent > 0) {
            dbgIndentStr = "                                                                                                    ";
            dbgIndentStr = dbgIndentStr.substring(0, Math.min(dbgIndentStr.length(), this.dbgEvaluationOutputIndent * 2));
            this.EVAL_LOG.log(5, dbgIndentStr + "- evaluateFormula('" + ec.getRefEvaluatorForCurrentSheet().getSheetName() + "'/" + new CellReference(ec.getRowIndex(), ec.getColumnIndex()).formatAsString() + "): " + Arrays.toString(ptgs).replaceAll("\\Qorg.zkoss.poi.ss.formula.ptg.\\E", ""));
            ++this.dbgEvaluationOutputIndent;
        }
        Stack<ValueEval> stack = new Stack<ValueEval>();
        int iSize = ptgs.length;
        for (int i = 0; i < iSize; ++i) {
            ValueEval opResult;
            ec.setPtgIndex(i);
            Ptg ptg = ptgs[i];
            if (this.dbgEvaluationOutputIndent > 0) {
                this.EVAL_LOG.log(3, dbgIndentStr + "  * ptg " + i + ": " + ptg);
            }
            if (ptg instanceof AttrPtg) {
                AttrPtg attrPtg = (AttrPtg)ptg;
                if (attrPtg.isSum()) {
                    ptg = FuncVarPtg.SUM;
                }
                if (attrPtg.isOptimizedChoose()) {
                    int dist;
                    ValueEval arg0 = (ValueEval)stack.pop();
                    int[] jumpTable = attrPtg.getJumpTable();
                    int nChoices = jumpTable.length;
                    try {
                        int switchIndex = Choose.evaluateFirstArg(arg0, ec.getRowIndex(), ec.getColumnIndex());
                        if (switchIndex < 1 || switchIndex > nChoices) {
                            stack.push(ErrorEval.VALUE_INVALID);
                            dist = attrPtg.getChooseFuncOffset() + 4;
                        } else {
                            dist = jumpTable[switchIndex - 1];
                        }
                    }
                    catch (EvaluationException e) {
                        stack.push(e.getErrorEval());
                        dist = attrPtg.getChooseFuncOffset() + 4;
                    }
                    i += WorkbookEvaluator.countTokensToBeSkipped(ptgs, i, dist -= nChoices * 2 + 2);
                    continue;
                }
                if (attrPtg.isOptimizedIf()) {
                    boolean evaluatedPredicate;
                    ValueEval arg0 = (ValueEval)stack.pop();
                    try {
                        evaluatedPredicate = IfFunc.evaluateFirstArg(arg0, ec.getRowIndex(), ec.getColumnIndex());
                    }
                    catch (EvaluationException e) {
                        stack.push(e.getErrorEval());
                        int dist = attrPtg.getData();
                        i += WorkbookEvaluator.countTokensToBeSkipped(ptgs, i, dist);
                        attrPtg = (AttrPtg)ptgs[i];
                        dist = attrPtg.getData() + 1;
                        i += WorkbookEvaluator.countTokensToBeSkipped(ptgs, i, dist);
                        continue;
                    }
                    if (evaluatedPredicate) continue;
                    short dist = attrPtg.getData();
                    i += WorkbookEvaluator.countTokensToBeSkipped(ptgs, i, dist);
                    Ptg nextPtg = ptgs[i + 1];
                    if (!(ptgs[i] instanceof AttrPtg) || !(nextPtg instanceof FuncVarPtg)) continue;
                    ++i;
                    stack.push(BoolEval.FALSE);
                    continue;
                }
                if (attrPtg.isSkip()) {
                    int dist = attrPtg.getData() + 1;
                    i += WorkbookEvaluator.countTokensToBeSkipped(ptgs, i, dist);
                    if (stack.peek() != MissingArgEval.instance) continue;
                    stack.pop();
                    stack.push(BlankEval.instance);
                    continue;
                }
            }
            if (ptg instanceof ControlPtg || ptg instanceof MemFuncPtg || ptg instanceof MemAreaPtg || ptg instanceof MemErrPtg) continue;
            if (ptg instanceof OperationPtg) {
                OperationPtg optg = (OperationPtg)ptg;
                int numops = optg.getNumberOfOperands();
                ValueEval[] ops = new ValueEval[numops];
                for (int j = numops - 1; j >= 0; --j) {
                    ValueEval p = (ValueEval)stack.pop();
                    p = optg instanceof FuncVarPtg && ((FuncVarPtg)optg).isExternal() ? this.postProcessValueEval(ec, p, j > 0) : this.postProcessValueEval(ec, p, true);
                    ops[j] = p;
                }
                opResult = OperationEvaluatorFactory.evaluate(optg, ops, ec);
                opResult = this.postProcessValueEval(ec, opResult, true);
            } else {
                opResult = this.getEvalForPtg(ptg, ec);
                opResult = this.postProcessValueEval(ec, opResult, false);
            }
            if (opResult == null) {
                throw new RuntimeException("Evaluation result must not be null");
            }
            stack.push(opResult);
            if (this.dbgEvaluationOutputIndent <= 0) continue;
            this.EVAL_LOG.log(3, dbgIndentStr + "    = " + opResult);
        }
        ValueEval value = (ValueEval)stack.pop();
        if (!stack.isEmpty()) {
            throw new IllegalStateException("evaluation stack not empty");
        }
        value = this.postProcessValueEval(ec, value, true);
        ValueEval valueEval = result = ignoreDereference ? value : WorkbookEvaluator.dereferenceResult(value, ec.getRowIndex(), ec.getColumnIndex());
        if (this.dbgEvaluationOutputIndent > 0) {
            this.EVAL_LOG.log(3, dbgIndentStr + "finshed eval of " + new CellReference(ec.getRowIndex(), ec.getColumnIndex()).formatAsString() + ": " + result);
            --this.dbgEvaluationOutputIndent;
            if (this.dbgEvaluationOutputIndent == 1) {
                this.dbgEvaluationOutputIndent = -1;
            }
        }
        return result;
    }

    private static int countTokensToBeSkipped(Ptg[] ptgs, int startIndex, int distInBytes) {
        int remBytes = distInBytes;
        int index = startIndex;
        while (remBytes != 0) {
            if ((remBytes -= ptgs[++index].getSize()) < 0) {
                throw new RuntimeException("Bad skip distance (wrong token size calculation).");
            }
            if (index < ptgs.length) continue;
            throw new RuntimeException("Skip distance too far (ran out of formula tokens).");
        }
        return index - startIndex;
    }

    public static ValueEval dereferenceResult(ValueEval evaluationResult, int srcRowNum, int srcColNum) {
        ValueEval value;
        try {
            value = OperandResolver.getSingleValue(evaluationResult, srcRowNum, srcColNum);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
        if (value == BlankEval.instance) {
            return NumberEval.ZERO;
        }
        return value;
    }

    ValueEval getEvalForPtg(Ptg ptg, OperationEvaluationContext ec) {
        if (ptg instanceof NamePtg) {
            NamePtg namePtg = (NamePtg)ptg;
            int contextSheetIndex = ec.getWorkbook().getSheetIndex(ec.getSheetName());
            EvaluationName nameRecord = this._workbook.getName(namePtg, contextSheetIndex);
            if (nameRecord.isFunctionName()) {
                return new NameEval(nameRecord.getNameText());
            }
            if (nameRecord.hasFormula()) {
                return this.evaluateNameFormula(nameRecord.getNameDefinition(), ec);
            }
            return new NameEval(nameRecord.getNameText());
        }
        if (ptg instanceof NameXPtg) {
            return ec.getNameXEval((NameXPtg)ptg);
        }
        if (ptg instanceof IntPtg) {
            return new NumberEval(((IntPtg)ptg).getValue());
        }
        if (ptg instanceof NumberPtg) {
            return new NumberEval(((NumberPtg)ptg).getValue());
        }
        if (ptg instanceof StringPtg) {
            return new StringEval(((StringPtg)ptg).getValue());
        }
        if (ptg instanceof BoolPtg) {
            return BoolEval.valueOf(((BoolPtg)ptg).getValue());
        }
        if (ptg instanceof ErrPtg) {
            return ErrorEval.valueOf(((ErrPtg)ptg).getErrorCode());
        }
        if (ptg instanceof MissingArgPtg) {
            return MissingArgEval.instance;
        }
        if (ptg instanceof AreaErrPtg || ptg instanceof RefErrorPtg || ptg instanceof DeletedArea3DPtg || ptg instanceof DeletedRef3DPtg) {
            return ErrorEval.REF_INVALID;
        }
        if (ptg instanceof TablePtg) {
            TablePtg aptg = (TablePtg)ptg;
            int row1 = aptg.getFirstRow();
            int row2 = aptg.getLastRow();
            int col1 = aptg.getFirstColumn();
            int col2 = aptg.getLastColumn();
            int extIdx = aptg.getExternSheetIndex();
            return row1 == row2 && col1 == col2 ? ec.getRef3DEval(row1, col1, false, false, extIdx) : ec.getArea3DEval(row1, col1, row2, col2, false, false, false, false, extIdx);
        }
        if (ptg instanceof Ref3DPtg) {
            Ref3DPtg rptg = (Ref3DPtg)ptg;
            return ec.getRef3DEval(rptg.getRow(), rptg.getColumn(), rptg.isRowRelative(), rptg.isColRelative(), rptg.getExternSheetIndex());
        }
        if (ptg instanceof Area3DPtg) {
            Area3DPtg aptg = (Area3DPtg)ptg;
            return ec.getArea3DEval(aptg.getFirstRow(), aptg.getFirstColumn(), aptg.getLastRow(), aptg.getLastColumn(), aptg.isFirstRowRelative(), aptg.isFirstColRelative(), aptg.isLastRowRelative(), aptg.isLastColRelative(), aptg.getExternSheetIndex());
        }
        if (ptg instanceof RefPtg) {
            RefPtg rptg = (RefPtg)ptg;
            return ec.getRefEval(rptg.getRow(), rptg.getColumn(), rptg.isRowRelative(), rptg.isColRelative());
        }
        if (ptg instanceof AreaPtg) {
            AreaPtg aptg = (AreaPtg)ptg;
            return ec.getAreaEval(aptg.getFirstRow(), aptg.getFirstColumn(), aptg.getLastRow(), aptg.getLastColumn(), aptg.isFirstRowRelative(), aptg.isFirstColRelative(), aptg.isLastRowRelative(), aptg.isLastColRelative());
        }
        if (ptg instanceof UnknownPtg) {
            throw new RuntimeException("UnknownPtg not allowed");
        }
        if (ptg instanceof ExpPtg) {
            throw new RuntimeException("ExpPtg currently not supported");
        }
        if (ptg instanceof ArrayPtg) {
            return ec.getArrayEval((ArrayPtg)ptg);
        }
        if (ptg instanceof DeferredNamePtg) {
            DeferredNamePtg pnp = (DeferredNamePtg)ptg;
            return new NameEval(pnp.toFormulaString());
        }
        throw new RuntimeException("Unexpected ptg class (" + ptg.getClass().getName() + ")");
    }

    ValueEval evaluateNameFormula(Ptg[] ptgs, OperationEvaluationContext ec) {
        if (ptgs.length > 1) {
            return this.evaluateFormula(ec, ptgs, true, true);
        }
        return this.getEvalForPtg(ptgs[0], ec);
    }

    ValueEval evaluateReference(String sheetname1, String sheetname2, int rowIndex, int columnIndex, EvaluationTracker tracker) {
        if ("#REF".equals(sheetname1)) {
            return ErrorEval.REF_INVALID;
        }
        int i1 = this.getSheetIndex(sheetname1);
        int i2 = this.getSheetIndex(sheetname2);
        int sheetIndex1 = Math.min(i1, i2);
        int sheetIndex2 = Math.max(i1, i2);
        int size = sheetIndex2 - sheetIndex1 + 1;
        ValueEval[] results = new ValueEval[size];
        int j = sheetIndex1;
        int k = 0;
        while (j <= sheetIndex2) {
            EvaluationSheet sheet = this.getSheet(j);
            EvaluationCell cell = sheet.getCell(rowIndex, columnIndex);
            results[k] = this.evaluateAny(cell, j, rowIndex, columnIndex, tracker, null, null);
            ++j;
            ++k;
        }
        return size > 1 ? new ValuesEval(results) : results[0];
    }

    ValueEval evaluateNonEmptyCells(String sheetName1, String sheetName2, int rowStart, int rowEnd, int columnStart, int colEnd, EvaluationTracker tracker) {
        if ("#REF".equals(sheetName1)) {
            return ErrorEval.REF_INVALID;
        }
        int i1 = this.getSheetIndex(sheetName1);
        int i2 = this.getSheetIndex(sheetName2);
        int sheetIndex1 = Math.min(i1, i2);
        int sheetIndex2 = Math.max(i1, i2);
        int size = sheetIndex2 - sheetIndex1 + 1;
        ValueEval[] results = new ValueEval[size];
        int j = sheetIndex1;
        int k = 0;
        while (j <= sheetIndex2) {
            EvaluationSheet sheet = this.getSheet(j);
            Iterator<EvaluationCell> iter = sheet.nonEmptyCellsIterator(rowStart, rowEnd, columnStart, colEnd);
            LinkedList<CellValueEval> values = new LinkedList<CellValueEval>();
            while (iter.hasNext()) {
                EvaluationCell cell = iter.next();
                int rowIndex = cell.getRowIndex();
                int columnIndex = cell.getColumnIndex();
                ValueEval value = this.evaluateAny(cell, j, rowIndex, columnIndex, tracker, null, null);
                CellValueEval cellValueEval = new CellValueEval(rowIndex, columnIndex, value);
                values.add(cellValueEval);
            }
            results[k] = new ValuesEval(values.toArray(new ValueEval[0]));
            ++j;
            ++k;
        }
        return size > 1 ? new ValuesEval(results) : results[0];
    }

    SortedValues getSortedColumnValue(String sheetName, int columnIndex, EvaluationTracker tracker) {
        ColumnCache columnCache;
        if ("#REF".equals(sheetName)) {
            return null;
        }
        int index = this.getSheetIndex(sheetName);
        if (this._columnCacheBySheetIndexes.containsKey(index)) {
            columnCache = this._columnCacheBySheetIndexes.get(index);
        } else {
            columnCache = new ColumnCache();
            this._columnCacheBySheetIndexes.put(index, columnCache);
        }
        SortedValues sortedValues = columnCache.get(columnIndex);
        if (sortedValues == null) {
            sortedValues = new SortedValues();
            EvaluationSheet sheet = this.getSheet(index);
            Iterator<EvaluationCell> iter = sheet.nonEmptyCellsIterator(columnIndex);
            while (iter.hasNext()) {
                int rowIndex;
                EvaluationCell cell = iter.next();
                ValueEval value = this.evaluateAny(cell, index, rowIndex = cell.getRowIndex(), columnIndex, tracker, null, null);
                if (value instanceof NumberEval) {
                    sortedValues.addValue(((NumberEval)value).getNumberValue(), rowIndex);
                    continue;
                }
                if (value instanceof StringEval) {
                    sortedValues.addValue(((StringEval)value).getStringValue().toLowerCase(), rowIndex);
                    continue;
                }
                if (!(value instanceof BoolEval)) continue;
                sortedValues.addValue(((BoolEval)value).getBooleanValue(), rowIndex);
            }
            columnCache.put(columnIndex, sortedValues);
        }
        return sortedValues;
    }

    public FreeRefFunction findUserDefinedFunction(String functionName) {
        return this._udfFinder.findFunction(functionName);
    }

    public void setIgnoreMissingWorkbooks(boolean ignore) {
        this._ignoreMissingWorkbooks = ignore;
    }

    public static Collection<String> getSupportedFunctionNames() {
        TreeSet<String> lst = new TreeSet<String>();
        lst.addAll(FunctionEval.getSupportedFunctionNames());
        lst.addAll(AnalysisToolPak.getSupportedFunctionNames());
        return lst;
    }

    public static Collection<String> getNotSupportedFunctionNames() {
        TreeSet<String> lst = new TreeSet<String>();
        lst.addAll(FunctionEval.getNotSupportedFunctionNames());
        lst.addAll(AnalysisToolPak.getNotSupportedFunctionNames());
        return lst;
    }

    public static void registerFunction(String name, FreeRefFunction func) {
        AnalysisToolPak.registerFunction(name, func);
    }

    public static void registerFunction(String name, Function func) {
        FunctionEval.registerFunction(name, func);
    }

    public ValueEval evaluate(int sheetIndex, String formula, boolean ignoreDereference, Object ref) {
        return this.evaluateAny(formula, sheetIndex, 0, 0, new EvaluationTracker(this._cache), ignoreDereference, ref, null);
    }

    @Deprecated
    public ValueEval evaluate(int sheetIndex, String formula, boolean ignoreDereference, Object ref, int[] offset) {
        return this.evaluateAny(formula, sheetIndex, 0, 0, new EvaluationTracker(this._cache), ignoreDereference, ref, offset);
    }

    public ValueEval evaluate(int sheetIndex, int rowIndex, int columnIndex, String formula, boolean ignoreDereference, Object ref, int[] offset) {
        return this.evaluateAny(formula, sheetIndex, rowIndex, columnIndex, new EvaluationTracker(this._cache), ignoreDereference, ref, offset);
    }

    private ValueEval evaluateAny(String formula, int sheetIndex, int rowIndex, int columnIndex, EvaluationTracker tracker, boolean ignoreDeference, Object ref, int[] offset) {
        ValueEval result;
        EvaluationCell virtualCell = new EvaluationCell(){

            @Override
            public Object getIdentityKey() {
                return null;
            }

            @Override
            public EvaluationSheet getSheet() {
                return null;
            }

            @Override
            public int getRowIndex() {
                return 0;
            }

            @Override
            public int getColumnIndex() {
                return 0;
            }

            @Override
            public int getCellType() {
                return 2;
            }

            @Override
            public double getNumericCellValue() {
                return 0.0;
            }

            @Override
            public String getStringCellValue() {
                return null;
            }

            @Override
            public boolean getBooleanCellValue() {
                return false;
            }

            @Override
            public int getErrorCellValue() {
                return 0;
            }

            @Override
            public int getCachedFormulaResultType() {
                return 3;
            }
        };
        FormulaCellCacheEntry cce = this._cache.getOrCreateFormulaCellEntry(virtualCell);
        if (cce.getValue() == null) {
            if (!tracker.startEvaluate(cce)) {
                return ErrorEval.CIRCULAR_REF_ERROR;
            }
            OperationEvaluationContext ec = new OperationEvaluationContext(this, this._workbook, sheetIndex, rowIndex, columnIndex, tracker, this._dependencyTracker, ref, offset);
            try {
                Ptg[] ptgs = this._workbook.getFormulaTokens(sheetIndex, formula);
                result = this.evaluateFormula(ec, ptgs, true, ignoreDeference);
                tracker.updateCacheResult(result);
            }
            catch (NotImplementedException e) {
                throw this.addExceptionInfo(e, sheetIndex, rowIndex, columnIndex);
            }
            finally {
                tracker.endEvaluate(cce);
                this._cache.notifyDeleteCell(0, sheetIndex, virtualCell);
            }
        } else {
            return cce.getValue();
        }
        if (WorkbookEvaluator.isDebugLogEnabled()) {
            String sheetName = this.getSheetName(sheetIndex);
            CellReference cr = new CellReference(rowIndex, columnIndex);
            WorkbookEvaluator.logDebug("Evaluated " + sheetName + "!" + cr.formatAsString() + " to " + result.toString());
        }
        return result;
    }

    public void setDebugEvaluationOutputForNextEval(boolean value) {
        this.dbgEvaluationOutputForNextEval = value;
    }

    public ValueEval evaluatePtgs(int sheetIndex, Ptg[] tokens, boolean ignoreDereference, Object ref) {
        return this.evaluatePtgs(sheetIndex, tokens, ignoreDereference, ref, null);
    }

    public ValueEval evaluatePtgs(int sheetIndex, Ptg[] tokens, boolean ignoreDereference, Object ref, int[] offset) {
        return this.evaluateAnyPtgs(tokens, sheetIndex, 0, 0, new EvaluationTracker(this._cache), ignoreDereference, ref, offset);
    }

    private ValueEval evaluateAnyPtgs(Ptg[] ptgs, int sheetIndex, int rowIndex, int columnIndex, EvaluationTracker tracker, boolean ignoreDeference, Object ref, int[] offset) {
        ValueEval result;
        EvaluationCell virtualCell = new EvaluationCell(){

            @Override
            public Object getIdentityKey() {
                return null;
            }

            @Override
            public EvaluationSheet getSheet() {
                return null;
            }

            @Override
            public int getRowIndex() {
                return 0;
            }

            @Override
            public int getColumnIndex() {
                return 0;
            }

            @Override
            public int getCellType() {
                return 2;
            }

            @Override
            public double getNumericCellValue() {
                return 0.0;
            }

            @Override
            public String getStringCellValue() {
                return null;
            }

            @Override
            public boolean getBooleanCellValue() {
                return false;
            }

            @Override
            public int getErrorCellValue() {
                return 0;
            }

            @Override
            public int getCachedFormulaResultType() {
                return 3;
            }
        };
        FormulaCellCacheEntry cce = this._cache.getOrCreateFormulaCellEntry(virtualCell);
        if (cce.getValue() == null) {
            if (!tracker.startEvaluate(cce)) {
                return ErrorEval.CIRCULAR_REF_ERROR;
            }
            OperationEvaluationContext ec = new OperationEvaluationContext(this, this._workbook, sheetIndex, rowIndex, columnIndex, tracker, this._dependencyTracker, ref, offset);
            try {
                result = this.evaluateFormula(ec, ptgs, true, ignoreDeference);
                tracker.updateCacheResult(result);
            }
            catch (NotImplementedException e) {
                throw this.addExceptionInfo(e, sheetIndex, rowIndex, columnIndex);
            }
            finally {
                tracker.endEvaluate(cce);
                this._cache.notifyDeleteCell(0, sheetIndex, virtualCell);
            }
        } else {
            return cce.getValue();
        }
        if (WorkbookEvaluator.isDebugLogEnabled()) {
            String sheetName = this.getSheetName(sheetIndex);
            CellReference cr = new CellReference(rowIndex, columnIndex);
            WorkbookEvaluator.logDebug("Evaluated " + sheetName + "!" + cr.formatAsString() + " to " + result.toString());
        }
        return result;
    }

    public static interface CacheManager {
        public void onUpdateCacheResult(EvaluationCell var1, ValueEval var2);
    }
}

