/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.formula;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.zkoss.poi.ss.formula.OperationEvaluationContext;
import org.zkoss.poi.ss.formula.UserDefinedFunction;
import org.zkoss.poi.ss.formula.eval.ConcatEval;
import org.zkoss.poi.ss.formula.eval.FunctionEval;
import org.zkoss.poi.ss.formula.eval.IntersectionEval;
import org.zkoss.poi.ss.formula.eval.PercentEval;
import org.zkoss.poi.ss.formula.eval.RangeEval;
import org.zkoss.poi.ss.formula.eval.RelationalOperationEval;
import org.zkoss.poi.ss.formula.eval.TwoOperandNumericOperation;
import org.zkoss.poi.ss.formula.eval.UnaryMinusEval;
import org.zkoss.poi.ss.formula.eval.UnaryPlusEval;
import org.zkoss.poi.ss.formula.eval.UnionEval;
import org.zkoss.poi.ss.formula.eval.ValueEval;
import org.zkoss.poi.ss.formula.functions.Function;
import org.zkoss.poi.ss.formula.functions.Indirect;
import org.zkoss.poi.ss.formula.functions.Offset;
import org.zkoss.poi.ss.formula.ptg.AbstractFunctionPtg;
import org.zkoss.poi.ss.formula.ptg.AddPtg;
import org.zkoss.poi.ss.formula.ptg.ConcatPtg;
import org.zkoss.poi.ss.formula.ptg.DividePtg;
import org.zkoss.poi.ss.formula.ptg.EqualPtg;
import org.zkoss.poi.ss.formula.ptg.GreaterEqualPtg;
import org.zkoss.poi.ss.formula.ptg.GreaterThanPtg;
import org.zkoss.poi.ss.formula.ptg.IntersectionPtg;
import org.zkoss.poi.ss.formula.ptg.LessEqualPtg;
import org.zkoss.poi.ss.formula.ptg.LessThanPtg;
import org.zkoss.poi.ss.formula.ptg.MultiplyPtg;
import org.zkoss.poi.ss.formula.ptg.NotEqualPtg;
import org.zkoss.poi.ss.formula.ptg.OperationPtg;
import org.zkoss.poi.ss.formula.ptg.PercentPtg;
import org.zkoss.poi.ss.formula.ptg.PowerPtg;
import org.zkoss.poi.ss.formula.ptg.RangePtg;
import org.zkoss.poi.ss.formula.ptg.SubtractPtg;
import org.zkoss.poi.ss.formula.ptg.UnaryMinusPtg;
import org.zkoss.poi.ss.formula.ptg.UnaryPlusPtg;
import org.zkoss.poi.ss.formula.ptg.UnionPtg;

final class OperationEvaluatorFactory {
    private static final Map<OperationPtg, Function> _instancesByPtgClass = OperationEvaluatorFactory.initialiseInstancesMap();

    private OperationEvaluatorFactory() {
    }

    private static Map<OperationPtg, Function> initialiseInstancesMap() {
        HashMap<OperationPtg, Function> m = new HashMap<OperationPtg, Function>(32);
        OperationEvaluatorFactory.put(m, EqualPtg.instance, RelationalOperationEval.EqualEval);
        OperationEvaluatorFactory.put(m, GreaterEqualPtg.instance, RelationalOperationEval.GreaterEqualEval);
        OperationEvaluatorFactory.put(m, GreaterThanPtg.instance, RelationalOperationEval.GreaterThanEval);
        OperationEvaluatorFactory.put(m, LessEqualPtg.instance, RelationalOperationEval.LessEqualEval);
        OperationEvaluatorFactory.put(m, LessThanPtg.instance, RelationalOperationEval.LessThanEval);
        OperationEvaluatorFactory.put(m, NotEqualPtg.instance, RelationalOperationEval.NotEqualEval);
        OperationEvaluatorFactory.put(m, ConcatPtg.instance, ConcatEval.instance);
        OperationEvaluatorFactory.put(m, AddPtg.instance, TwoOperandNumericOperation.AddEval);
        OperationEvaluatorFactory.put(m, DividePtg.instance, TwoOperandNumericOperation.DivideEval);
        OperationEvaluatorFactory.put(m, PercentPtg.instance, PercentEval.instance);
        OperationEvaluatorFactory.put(m, PowerPtg.instance, TwoOperandNumericOperation.PowerEval);
        OperationEvaluatorFactory.put(m, SubtractPtg.instance, TwoOperandNumericOperation.SubtractEval);
        OperationEvaluatorFactory.put(m, UnaryMinusPtg.instance, UnaryMinusEval.instance);
        OperationEvaluatorFactory.put(m, UnaryPlusPtg.instance, UnaryPlusEval.instance);
        OperationEvaluatorFactory.put(m, RangePtg.instance, RangeEval.instance);
        OperationEvaluatorFactory.put(m, IntersectionPtg.instance, IntersectionEval.instance);
        return m;
    }

    private static void put(Map<OperationPtg, Function> m, OperationPtg ptgKey, Function instance) {
        Constructor<?>[] cc = ptgKey.getClass().getDeclaredConstructors();
        if (cc.length > 1 || !Modifier.isPrivate(cc[0].getModifiers())) {
            throw new RuntimeException("Failed to verify instance (" + ptgKey.getClass().getName() + ") is a singleton.");
        }
        m.put(ptgKey, instance);
    }

    public static ValueEval evaluate(OperationPtg ptg, ValueEval[] args, OperationEvaluationContext ec) {
        Function result;
        if (ptg == null) {
            throw new IllegalArgumentException("ptg must not be null");
        }
        if (ptg instanceof UnionPtg) {
            return new UnionEval(args);
        }
        Function function = result = ptg instanceof MultiplyPtg ? new TwoOperandNumericOperation.MultiplyFunc(((MultiplyPtg)ptg).isOperator()) : _instancesByPtgClass.get(ptg);
        if (result != null) {
            return result.evaluate(args, ec.getRowIndex(), (short)ec.getColumnIndex());
        }
        if (ptg instanceof AbstractFunctionPtg) {
            AbstractFunctionPtg fptg = (AbstractFunctionPtg)ptg;
            short functionIndex = fptg.getFunctionIndex();
            switch (functionIndex) {
                case 148: {
                    return Indirect.instance.evaluate(args, ec);
                }
                case 78: {
                    return Offset.instance.evaluate(args, ec);
                }
                case 255: {
                    return UserDefinedFunction.instance.evaluate(args, ec);
                }
            }
            return FunctionEval.getBasicFunction(functionIndex).evaluate(args, ec.getRowIndex(), (short)ec.getColumnIndex());
        }
        throw new RuntimeException("Unexpected operation ptg class (" + ptg.getClass().getName() + ")");
    }
}

