/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.formula;

import org.zkoss.poi.ss.SpreadsheetVersion;
import org.zkoss.poi.ss.formula.CollaboratingWorkbooksEnvironment;
import org.zkoss.poi.ss.formula.DependencyTracker;
import org.zkoss.poi.ss.formula.EvaluationName;
import org.zkoss.poi.ss.formula.EvaluationTracker;
import org.zkoss.poi.ss.formula.EvaluationWorkbook;
import org.zkoss.poi.ss.formula.ExternSheetReferenceToken;
import org.zkoss.poi.ss.formula.FormulaParsingWorkbook;
import org.zkoss.poi.ss.formula.LazyAreaEval;
import org.zkoss.poi.ss.formula.LazyRefEval;
import org.zkoss.poi.ss.formula.NameRangeEval;
import org.zkoss.poi.ss.formula.SheetRefEvaluator;
import org.zkoss.poi.ss.formula.UserDefinedFunction;
import org.zkoss.poi.ss.formula.WorkbookEvaluator;
import org.zkoss.poi.ss.formula.eval.ArrayEval;
import org.zkoss.poi.ss.formula.eval.ErrorEval;
import org.zkoss.poi.ss.formula.eval.NameXEval;
import org.zkoss.poi.ss.formula.eval.ValueEval;
import org.zkoss.poi.ss.formula.functions.FreeRefFunction;
import org.zkoss.poi.ss.formula.ptg.Area3DPtg;
import org.zkoss.poi.ss.formula.ptg.ArrayPtg;
import org.zkoss.poi.ss.formula.ptg.NameXPtg;
import org.zkoss.poi.ss.formula.ptg.Ptg;
import org.zkoss.poi.ss.formula.ptg.Ref3DPtg;
import org.zkoss.poi.ss.util.CellReference;

public final class OperationEvaluationContext {
    public static final FreeRefFunction UDF = UserDefinedFunction.instance;
    private final EvaluationWorkbook _workbook;
    private final int _sheetIndex;
    private final int _rowIndex;
    private final int _columnIndex;
    private final EvaluationTracker _tracker;
    private final WorkbookEvaluator _bookEvaluator;
    int _ptgIndex;
    private final DependencyTracker _dependencyTracker;
    private final Object _dependent;
    private final int[] _offset;

    @Deprecated
    public OperationEvaluationContext(WorkbookEvaluator bookEvaluator, EvaluationWorkbook workbook, int sheetIndex, int srcRowNum, int srcColNum, EvaluationTracker tracker, DependencyTracker dependencyTracker, Object ref) {
        this(bookEvaluator, workbook, sheetIndex, srcRowNum, srcColNum, tracker, dependencyTracker, ref, null);
    }

    public OperationEvaluationContext(WorkbookEvaluator bookEvaluator, EvaluationWorkbook workbook, int sheetIndex, int srcRowNum, int srcColNum, EvaluationTracker tracker, DependencyTracker dependencyTracker, Object ref, int[] offset) {
        this._bookEvaluator = bookEvaluator;
        this._workbook = workbook;
        this._sheetIndex = sheetIndex;
        this._rowIndex = srcRowNum;
        this._columnIndex = srcColNum;
        this._tracker = tracker;
        this._dependencyTracker = dependencyTracker;
        this._dependent = ref;
        this._offset = offset;
    }

    public EvaluationWorkbook getWorkbook() {
        return this._workbook;
    }

    public int getRowIndex() {
        return this._rowIndex;
    }

    public int getColumnIndex() {
        return this._columnIndex;
    }

    public String getSheetName() {
        return this._workbook.getSheetName(this._sheetIndex);
    }

    SheetRefEvaluator createExternSheetRefEvaluator(ExternSheetReferenceToken ptg) {
        return this.createExternSheetRefEvaluator(ptg.getExternSheetIndex());
    }

    SheetRefEvaluator createExternSheetRefEvaluator(int externSheetIndex) {
        WorkbookEvaluator targetEvaluator;
        int otherLastSheetIndex;
        int otherSheetIndex;
        EvaluationWorkbook.ExternalSheet externalSheet = this._workbook.getExternalSheet(externSheetIndex);
        if (externalSheet == null) {
            otherSheetIndex = this._workbook.convertFromExternSheetIndex(externSheetIndex);
            otherLastSheetIndex = this._workbook.convertLastIndexFromExternSheetIndex(externSheetIndex);
            targetEvaluator = this._bookEvaluator;
        } else {
            String workbookName = externalSheet.getWorkbookName();
            try {
                targetEvaluator = this._bookEvaluator.getOtherWorkbookEvaluator(workbookName);
            }
            catch (CollaboratingWorkbooksEnvironment.WorkbookNotFoundException e) {
                return null;
            }
            otherSheetIndex = targetEvaluator.getSheetIndex(externalSheet.getSheetName());
            otherLastSheetIndex = targetEvaluator.getSheetIndex(externalSheet.getLastSheetName());
            if (otherSheetIndex < 0) {
                return null;
            }
            if (otherLastSheetIndex < 0) {
                return null;
            }
        }
        return new SheetRefEvaluator(targetEvaluator, this._tracker, otherSheetIndex, otherLastSheetIndex);
    }

    private SheetRefEvaluator createExternSheetRefEvaluator(String workbookName, String sheetName, String lastSheetName) {
        int otherSheetIndex;
        WorkbookEvaluator targetEvaluator;
        if (workbookName == null) {
            targetEvaluator = this._bookEvaluator;
        } else {
            if (sheetName == null) {
                throw new IllegalArgumentException("sheetName must not be null if workbookName is provided");
            }
            try {
                targetEvaluator = this._bookEvaluator.getOtherWorkbookEvaluator(workbookName);
            }
            catch (CollaboratingWorkbooksEnvironment.WorkbookNotFoundException e) {
                return null;
            }
        }
        int n = otherSheetIndex = sheetName == null ? this._sheetIndex : targetEvaluator.getSheetIndex(sheetName);
        if (otherSheetIndex < 0) {
            return null;
        }
        int otherLastSheetIndex = lastSheetName == null ? this._sheetIndex : targetEvaluator.getSheetIndex(lastSheetName);
        return new SheetRefEvaluator(targetEvaluator, this._tracker, otherSheetIndex, otherLastSheetIndex);
    }

    public SheetRefEvaluator getRefEvaluatorForCurrentSheet() {
        return new SheetRefEvaluator(this._bookEvaluator, this._tracker, this._sheetIndex, this._sheetIndex);
    }

    public ValueEval getDynamicReference(String workbookName, String sheetName, String lastSheetName, String refStrPart1, String refStrPart2, boolean isA1Style) {
        int lastCol;
        int firstCol;
        int lastRow;
        int firstRow;
        this.clearIndirectRefPrecedent();
        if (!isA1Style) {
            throw new RuntimeException("R1C1 style not supported yet");
        }
        SheetRefEvaluator sre = this.createExternSheetRefEvaluator(workbookName, sheetName, lastSheetName);
        if (sre == null) {
            return ErrorEval.REF_INVALID;
        }
        SpreadsheetVersion ssVersion = ((FormulaParsingWorkbook)((Object)this._workbook)).getSpreadsheetVersion();
        CellReference.NameType part1refType = OperationEvaluationContext.classifyCellReference(refStrPart1, ssVersion);
        switch (part1refType) {
            case BAD_CELL_OR_NAMED_RANGE: {
                return ErrorEval.REF_INVALID;
            }
            case NAMED_RANGE: {
                EvaluationName nm = this.getName(refStrPart1, sheetName == null ? -1 : sre.getSheetIndex());
                if (nm == null) {
                    return ErrorEval.REF_INVALID;
                }
                if (!nm.isRange()) {
                    return ErrorEval.REF_INVALID;
                }
                this.createIndirectRefPrecedent(new NameRangeEval(nm.createPtg()));
                return this._bookEvaluator.evaluateNameFormula(nm.getNameDefinition(), this);
            }
        }
        if (refStrPart2 == null) {
            switch (part1refType) {
                case COLUMN: 
                case ROW: {
                    return ErrorEval.REF_INVALID;
                }
                case CELL: {
                    CellReference cr = new CellReference(refStrPart1);
                    LazyRefEval valueEval = new LazyRefEval(cr.getRow(), cr.getCol(), !cr.isRowAbsolute(), !cr.isColAbsolute(), sre);
                    this.createIndirectRefPrecedent(valueEval);
                    return valueEval;
                }
            }
            throw new IllegalStateException("Unexpected reference classification of '" + refStrPart1 + "'.");
        }
        CellReference.NameType part2refType = OperationEvaluationContext.classifyCellReference(refStrPart2, ssVersion);
        switch (part2refType) {
            case BAD_CELL_OR_NAMED_RANGE: {
                return ErrorEval.REF_INVALID;
            }
            case NAMED_RANGE: {
                return ErrorEval.REF_INVALID;
            }
        }
        if (part2refType != part1refType) {
            return ErrorEval.REF_INVALID;
        }
        boolean firstRowRel = false;
        boolean firstColRel = false;
        boolean lastRowRel = false;
        boolean lastColRel = false;
        switch (part1refType) {
            case COLUMN: {
                firstRow = 0;
                lastRow = ssVersion.getLastRowIndex();
                if (refStrPart1.startsWith("$")) {
                    refStrPart1 = refStrPart1.substring(1);
                } else {
                    firstColRel = true;
                }
                if (refStrPart2.startsWith("$")) {
                    refStrPart2 = refStrPart2.substring(1);
                } else {
                    lastColRel = true;
                }
                firstCol = OperationEvaluationContext.parseColRef(refStrPart1);
                lastCol = OperationEvaluationContext.parseColRef(refStrPart2);
                break;
            }
            case ROW: {
                firstCol = 0;
                lastCol = ssVersion.getLastColumnIndex();
                if (refStrPart1.startsWith("$")) {
                    refStrPart1 = refStrPart1.substring(1);
                } else {
                    firstRowRel = true;
                }
                if (refStrPart2.startsWith("$")) {
                    refStrPart2 = refStrPart2.substring(1);
                } else {
                    lastRowRel = true;
                }
                firstRow = OperationEvaluationContext.parseRowRef(refStrPart1);
                lastRow = OperationEvaluationContext.parseRowRef(refStrPart2);
                break;
            }
            case CELL: {
                CellReference cr = new CellReference(refStrPart1);
                firstRow = cr.getRow();
                firstCol = cr.getCol();
                firstRowRel = !cr.isRowAbsolute();
                firstColRel = !cr.isColAbsolute();
                cr = new CellReference(refStrPart2);
                lastRow = cr.getRow();
                lastCol = cr.getCol();
                lastRowRel = !cr.isRowAbsolute();
                lastColRel = !cr.isColAbsolute();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected reference classification of '" + refStrPart1 + "'.");
            }
        }
        LazyAreaEval valueEval = new LazyAreaEval(firstRow, firstCol, lastRow, lastCol, firstRowRel, firstColRel, lastRowRel, lastColRel, sre);
        this.createIndirectRefPrecedent(valueEval);
        return valueEval;
    }

    public void clearOffsetRefPrecedent() {
        this._dependencyTracker.clearOffsetRefPrecedent(this);
    }

    public void createOffsetRefPrecedent(ValueEval precedent) {
        this._dependencyTracker.setOffsetRefPrecedent(this, precedent);
    }

    private static int parseRowRef(String refStrPart) {
        return Integer.parseInt(refStrPart) - 1;
    }

    private static int parseColRef(String refStrPart) {
        return CellReference.convertColStringToIndex(refStrPart);
    }

    private static CellReference.NameType classifyCellReference(String str, SpreadsheetVersion ssVersion) {
        int len = str.length();
        if (len < 1) {
            return CellReference.NameType.BAD_CELL_OR_NAMED_RANGE;
        }
        return CellReference.classifyCellReference(str, ssVersion);
    }

    public FreeRefFunction findUserDefinedFunction(String functionName) {
        return this._bookEvaluator.findUserDefinedFunction(functionName);
    }

    public ValueEval getRefEval(int rowIndex, int columnIndex, boolean rowRel, boolean colRel) {
        if (this._offset != null) {
            if (rowRel) {
                rowIndex += this._offset[0];
            }
            if (colRel) {
                columnIndex += this._offset[1];
            }
        }
        SheetRefEvaluator sre = this.getRefEvaluatorForCurrentSheet();
        return new LazyRefEval(rowIndex, columnIndex, rowRel, colRel, sre);
    }

    public ValueEval getRef3DEval(int rowIndex, int columnIndex, boolean rowRel, boolean colRel, int extSheetIndex) {
        SheetRefEvaluator sre = this.createExternSheetRefEvaluator(extSheetIndex);
        if (sre == null) {
            return ErrorEval.REF_INVALID;
        }
        return new LazyRefEval(rowIndex, columnIndex, rowRel, rowRel, sre);
    }

    public ValueEval getAreaEval(int firstRowIndex, int firstColumnIndex, int lastRowIndex, int lastColumnIndex, boolean row1Rel, boolean col1Rel, boolean row2Rel, boolean col2Rel) {
        if (this._offset != null) {
            if (row1Rel) {
                firstRowIndex += this._offset[0];
            }
            if (row2Rel) {
                lastRowIndex += this._offset[0];
            }
            if (col1Rel) {
                firstColumnIndex += this._offset[1];
            }
            if (col2Rel) {
                lastColumnIndex += this._offset[1];
            }
        }
        SheetRefEvaluator sre = this.getRefEvaluatorForCurrentSheet();
        return new LazyAreaEval(firstRowIndex, firstColumnIndex, lastRowIndex, lastColumnIndex, row1Rel, col1Rel, row2Rel, col2Rel, sre);
    }

    public WorkbookEvaluator getWorkbookEvaluator() {
        return this._bookEvaluator;
    }

    public ValueEval getArea3DEval(int firstRowIndex, int firstColumnIndex, int lastRowIndex, int lastColumnIndex, boolean row1Rel, boolean col1Rel, boolean row2Rel, boolean col2Rel, int extSheetIndex) {
        SheetRefEvaluator sre = this.createExternSheetRefEvaluator(extSheetIndex);
        if (sre == null) {
            return ErrorEval.REF_INVALID;
        }
        return new LazyAreaEval(firstRowIndex, firstColumnIndex, lastRowIndex, lastColumnIndex, row1Rel, col1Rel, row2Rel, col2Rel, sre);
    }

    public ValueEval getNameXEval(NameXPtg nameXPtg) {
        EvaluationWorkbook.ExternalSheet externSheet = this._workbook.getExternalSheet(nameXPtg.getSheetRefIndex());
        if (externSheet == null) {
            return new NameXEval(nameXPtg);
        }
        String workbookName = externSheet.getWorkbookName();
        EvaluationWorkbook.ExternalName externName = this._workbook.getExternalName(nameXPtg.getSheetRefIndex(), nameXPtg.getNameIndex());
        try {
            WorkbookEvaluator refWorkbookEvaluator = this._bookEvaluator.getOtherWorkbookEvaluator(workbookName);
            EvaluationName evaluationName = refWorkbookEvaluator.getName(externName.getName(), externName.getIx() - 1);
            if (evaluationName != null && evaluationName.hasFormula()) {
                if (evaluationName.getNameDefinition().length > 1) {
                    throw new RuntimeException("Complex name formulas not supported yet");
                }
                Ptg ptg = evaluationName.getNameDefinition()[0];
                if (ptg instanceof Ref3DPtg) {
                    Ref3DPtg ref3D = (Ref3DPtg)ptg;
                    int sheetIndex = refWorkbookEvaluator.getSheetIndexByExternIndex(ref3D.getExternSheetIndex());
                    int lastSheetIndex = refWorkbookEvaluator.getLastSheetIndexByExternIndex(ref3D.getExternSheetIndex());
                    String sheetName = refWorkbookEvaluator.getSheetName(sheetIndex);
                    String lastSheetName = refWorkbookEvaluator.getSheetName(lastSheetIndex);
                    SheetRefEvaluator sre = this.createExternSheetRefEvaluator(workbookName, sheetName, lastSheetName);
                    return new LazyRefEval(ref3D.getRow(), ref3D.getColumn(), ref3D.isRowRelative(), ref3D.isColRelative(), sre);
                }
                if (ptg instanceof Area3DPtg) {
                    Area3DPtg area3D = (Area3DPtg)ptg;
                    int sheetIndex = refWorkbookEvaluator.getSheetIndexByExternIndex(area3D.getExternSheetIndex());
                    int lastSheetIndex = refWorkbookEvaluator.getLastSheetIndexByExternIndex(area3D.getExternSheetIndex());
                    String sheetName = refWorkbookEvaluator.getSheetName(sheetIndex);
                    String lastSheetName = refWorkbookEvaluator.getSheetName(lastSheetIndex);
                    SheetRefEvaluator sre = this.createExternSheetRefEvaluator(workbookName, sheetName, lastSheetName);
                    return new LazyAreaEval(area3D.getFirstRow(), area3D.getFirstColumn(), area3D.getLastRow(), area3D.getLastColumn(), area3D.isFirstRowRelative(), area3D.isFirstColRelative(), area3D.isLastRowRelative(), area3D.isLastColRelative(), sre);
                }
            }
            return ErrorEval.REF_INVALID;
        }
        catch (CollaboratingWorkbooksEnvironment.WorkbookNotFoundException wnfe) {
            return ErrorEval.REF_INVALID;
        }
    }

    public int getPtgIndex() {
        return this._ptgIndex;
    }

    public void setPtgIndex(int index) {
        this._ptgIndex = index;
    }

    private void clearIndirectRefPrecedent() {
        this._dependencyTracker.clearIndirectRefPrecedent(this);
    }

    private void createIndirectRefPrecedent(ValueEval precedent) {
        this._dependencyTracker.setIndirectRefPrecedent(this, precedent);
    }

    public EvaluationName getName(String name, int contextSheetIndex) {
        EvaluationName nm = ((FormulaParsingWorkbook)((Object)this._workbook)).getName(name, contextSheetIndex < 0 ? this._sheetIndex : contextSheetIndex);
        if (nm == null && contextSheetIndex < 0) {
            nm = ((FormulaParsingWorkbook)((Object)this._workbook)).getName(name, null);
        }
        return nm;
    }

    public Object getDependent() {
        return this._dependent;
    }

    public ValueEval getArrayEval(ArrayPtg ptg) {
        SheetRefEvaluator sre = this.getRefEvaluatorForCurrentSheet();
        return new ArrayEval(ptg, sre);
    }
}

